/*
 * Decompiled with CFR 0.152.
 */
package com.lowdragmc.mbd2.integration.photon;

import com.lowdragmc.mbd2.api.machine.IMachine;
import com.lowdragmc.mbd2.common.machine.MBDMachine;
import com.lowdragmc.photon.client.fx.FX;
import com.lowdragmc.photon.client.fx.FXEffect;
import com.lowdragmc.photon.client.fx.IEffect;
import com.lowdragmc.photon.client.gameobject.emitter.IParticleEmitter;
import java.util.Map;
import net.minecraft.core.BlockPos;
import net.minecraft.world.level.BlockGetter;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;
import org.joml.Vector3f;

@OnlyIn(value=Dist.CLIENT)
public class MachineFX
extends FXEffect {
    public final String identifier;
    public final MBDMachine machine;

    public MachineFX(FX fx, String identifier, MBDMachine machine) {
        super(fx, machine.getLevel());
        this.identifier = identifier;
        this.machine = machine;
    }

    public void kill(boolean forcedDeath) {
        for (IParticleEmitter emitter : this.emitters) {
            emitter.remove(forcedDeath);
        }
    }

    public void start() {
        this.emitters.clear();
        this.emitters.addAll(this.fx.generateEmitters());
        if (this.emitters.isEmpty()) {
            return;
        }
        Map<String, Object> fxs = this.machine.getPhotonFXs();
        Object previous = fxs.get(this.identifier);
        if (previous instanceof MachineFX) {
            MachineFX machineFX = (MachineFX)((Object)previous);
            machineFX.kill(machineFX.forcedDeath);
        }
        fxs.put(this.identifier, (Object)this);
        BlockPos pos = this.machine.getPos();
        Vector3f realPos = new Vector3f((float)pos.m_123341_(), (float)pos.m_123342_(), (float)pos.m_123343_()).add((float)(this.xOffset + 0.5), (float)(this.yOffset + 0.5), (float)(this.zOffset + 0.5));
        for (IParticleEmitter emitter : this.emitters) {
            if (emitter.isSubEmitter()) continue;
            emitter.reset();
            emitter.self().setDelay(this.delay);
            emitter.emmitToLevel((IEffect)this, this.level, (double)realPos.x, (double)realPos.y, (double)realPos.z, this.xRotation, this.yRotation, this.zRotation);
        }
    }

    public boolean updateEmitter(IParticleEmitter emitter) {
        BlockPos pos = this.machine.getPos();
        if (!this.level.m_46749_(pos) || this.machine.getPhotonFXs().get(this.identifier) != this || this.machine.isInValid() || IMachine.ofMachine((BlockGetter)this.level, pos).stream().noneMatch(m -> m == this.machine)) {
            emitter.remove(this.forcedDeath);
            return this.forcedDeath;
        }
        return false;
    }
}

