/*
 * Decompiled with CFR 0.152.
 */
package com.lowdragmc.mbd2.integration.pneumaticcraft.trait.pressure;

import com.lowdragmc.lowdraglib.syncdata.IContentChangeAware;
import com.lowdragmc.lowdraglib.syncdata.ITagSerializable;
import me.desht.pneumaticcraft.api.pressure.PressureTier;
import me.desht.pneumaticcraft.common.capabilities.MachineAirHandler;
import net.minecraft.nbt.CompoundTag;

public class CopiableAirHandler
extends MachineAirHandler
implements ITagSerializable<CompoundTag>,
IContentChangeAware {
    public Runnable onContentsChanged = () -> {};
    protected final float maxPressure;
    private final PressureTier tier;

    public CopiableAirHandler(PressureTier tier, int baseVolume, float maxPressure) {
        this(tier, baseVolume, 0.0f, maxPressure);
    }

    public CopiableAirHandler(PressureTier tier, int baseVolume, float pressure, float maxPressure) {
        super(tier, baseVolume);
        this.tier = tier;
        this.maxPressure = maxPressure;
        super.setPressure(pressure);
    }

    public CopiableAirHandler copy() {
        return new CopiableAirHandler(this.tier, this.getBaseVolume(), this.getPressure(), this.maxPressure);
    }

    public void addAir(int amount) {
        super.addAir(amount);
        if (amount != 0) {
            this.onContentsChanged.run();
        }
    }

    public void setBaseVolume(int newBaseVolume) {
        if (newBaseVolume != this.getBaseVolume()) {
            super.setBaseVolume(newBaseVolume);
            this.onContentsChanged.run();
        }
    }

    public Runnable getOnContentsChanged() {
        return this.onContentsChanged;
    }

    public float maxPressure() {
        return this.maxPressure;
    }

    public PressureTier getTier() {
        return this.tier;
    }

    public void setOnContentsChanged(Runnable onContentsChanged) {
        this.onContentsChanged = onContentsChanged;
    }
}

