/*
 * Decompiled with CFR 0.152.
 */
package com.lowdragmc.mbd2.integration.pneumaticcraft.trait.pressure;

import com.lowdragmc.lowdraglib.syncdata.annotation.DescSynced;
import com.lowdragmc.lowdraglib.syncdata.annotation.Persisted;
import com.lowdragmc.lowdraglib.syncdata.field.ManagedFieldHolder;
import com.lowdragmc.mbd2.api.capability.recipe.IO;
import com.lowdragmc.mbd2.api.capability.recipe.IRecipeHandlerTrait;
import com.lowdragmc.mbd2.api.capability.recipe.RecipeCapability;
import com.lowdragmc.mbd2.api.recipe.MBDRecipe;
import com.lowdragmc.mbd2.common.machine.MBDMachine;
import com.lowdragmc.mbd2.common.trait.ICapabilityProviderTrait;
import com.lowdragmc.mbd2.common.trait.RecipeCapabilityTrait;
import com.lowdragmc.mbd2.integration.pneumaticcraft.PNCPressureAirRecipeCapability;
import com.lowdragmc.mbd2.integration.pneumaticcraft.PressureAir;
import com.lowdragmc.mbd2.integration.pneumaticcraft.trait.pressure.CopiableAirHandler;
import com.lowdragmc.mbd2.integration.pneumaticcraft.trait.pressure.PNCPressureAirHandlerTraitDefinition;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import me.desht.pneumaticcraft.api.PNCCapabilities;
import me.desht.pneumaticcraft.api.tileentity.IAirHandler;
import me.desht.pneumaticcraft.api.tileentity.IAirHandlerMachine;
import me.desht.pneumaticcraft.common.util.DirectionUtil;
import net.minecraft.core.Direction;
import net.minecraftforge.common.capabilities.Capability;
import org.jetbrains.annotations.Nullable;

public class PNCPressureAirHandlerTrait
extends RecipeCapabilityTrait
implements IRecipeHandlerTrait<PressureAir> {
    public static final ManagedFieldHolder MANAGED_FIELD_HOLDER = new ManagedFieldHolder(PNCPressureAirHandlerTrait.class);
    @Persisted
    @DescSynced
    public final CopiableAirHandler handler;
    private final AirHandlerMachineCap airHandlerMachineCap = new AirHandlerMachineCap();
    private final AirHandlerCap airHandlerCap = new AirHandlerCap();
    @Nullable
    private Direction lastFront = null;

    public ManagedFieldHolder getFieldHolder() {
        return MANAGED_FIELD_HOLDER;
    }

    public PNCPressureAirHandlerTrait(MBDMachine machine, PNCPressureAirHandlerTraitDefinition definition) {
        super(machine, definition);
        this.handler = this.createHandler();
        this.handler.setOnContentsChanged(this::notifyListeners);
    }

    @Override
    public PNCPressureAirHandlerTraitDefinition getDefinition() {
        return (PNCPressureAirHandlerTraitDefinition)super.getDefinition();
    }

    @Override
    public void onLoadingTraitInPreview() {
        this.handler.addAir((int)(this.handler.maxPressure() / 2.0f * (float)this.handler.getVolume()));
    }

    protected CopiableAirHandler createHandler() {
        return new CopiableAirHandler(this.getDefinition().getPressureTier(), this.getDefinition().getVolume(), this.getDefinition().getMaxPressure());
    }

    protected void updateHullAirHandlers() {
        Direction front = this.getMachine().getFrontFacing().orElse(Direction.NORTH);
        if (this.lastFront == front) {
            return;
        }
        ArrayList<Direction> list = new ArrayList<Direction>();
        for (Direction side : DirectionUtil.VALUES) {
            if (!this.getDefinition().getConnectionIO().getConnection(front, side)) continue;
            list.add(side);
        }
        this.handler.setConnectedFaces(list);
        this.lastFront = front;
    }

    @Override
    public void serverTick() {
        super.serverTick();
        this.updateHullAirHandlers();
        this.handler.tick(this.getMachine().getHolder());
    }

    @Override
    public void clientTick() {
        super.clientTick();
        this.updateHullAirHandlers();
        this.handler.tick(this.getMachine().getHolder());
    }

    @Override
    public List<PressureAir> handleRecipeInner(IO io, MBDRecipe recipe, List<PressureAir> left, @Nullable String slotName, boolean simulate) {
        block6: {
            CopiableAirHandler handler;
            block5: {
                if (!this.compatibleWith(io)) {
                    return left;
                }
                CopiableAirHandler copiableAirHandler = handler = simulate ? this.handler.copy() : this.handler;
                if (io != IO.IN) break block5;
                Iterator<PressureAir> iterator = left.iterator();
                while (iterator.hasNext()) {
                    int leftAir;
                    PressureAir pressureAir = iterator.next();
                    float air = pressureAir.value();
                    if (!pressureAir.isAir()) {
                        air = (float)handler.getVolume() * air;
                    }
                    if (air > (float)(leftAir = handler.getAir())) continue;
                    handler.addAir((int)(-air));
                    iterator.remove();
                }
                break block6;
            }
            if (io != IO.OUT) break block6;
            Iterator<PressureAir> iterator = left.iterator();
            while (iterator.hasNext()) {
                float leftPressure;
                PressureAir pressureAir = iterator.next();
                float pressure = pressureAir.value();
                if (pressureAir.isAir()) {
                    pressure /= (float)handler.getVolume();
                }
                if (pressure > (leftPressure = handler.maxPressure() - handler.getPressure())) continue;
                int air = (int)(pressure * (float)handler.getVolume());
                handler.addAir(air);
                iterator.remove();
            }
        }
        return left.isEmpty() ? null : left;
    }

    @Override
    public RecipeCapability<PressureAir> getRecipeCapability() {
        return PNCPressureAirRecipeCapability.CAP;
    }

    @Override
    public List<IRecipeHandlerTrait<?>> getRecipeHandlerTraits() {
        return List.of(this);
    }

    @Override
    public List<ICapabilityProviderTrait<?>> getCapabilityProviderTraits() {
        return List.of(this.airHandlerMachineCap, this.airHandlerCap);
    }

    public CopiableAirHandler getHandler() {
        return this.handler;
    }

    public AirHandlerMachineCap getAirHandlerMachineCap() {
        return this.airHandlerMachineCap;
    }

    public AirHandlerCap getAirHandlerCap() {
        return this.airHandlerCap;
    }

    @Nullable
    public Direction getLastFront() {
        return this.lastFront;
    }

    public class AirHandlerMachineCap
    implements ICapabilityProviderTrait<IAirHandlerMachine> {
        @Override
        public IO getCapabilityIO(@Nullable Direction side) {
            return IO.BOTH;
        }

        @Override
        public Capability<? super IAirHandlerMachine> getCapability() {
            return PNCCapabilities.AIR_HANDLER_MACHINE_CAPABILITY;
        }

        @Override
        public IAirHandlerMachine getCapContent(IO capbilityIO) {
            return PNCPressureAirHandlerTrait.this.handler;
        }

        @Override
        public IAirHandlerMachine mergeContents(List<IAirHandlerMachine> contents) {
            return PNCPressureAirHandlerTrait.this.handler;
        }
    }

    public class AirHandlerCap
    implements ICapabilityProviderTrait<IAirHandler> {
        @Override
        public IO getCapabilityIO(@Nullable Direction side) {
            return IO.BOTH;
        }

        @Override
        public Capability<? super IAirHandler> getCapability() {
            return PNCCapabilities.AIR_HANDLER_CAPABILITY;
        }

        @Override
        public IAirHandler getCapContent(IO capbilityIO) {
            return PNCPressureAirHandlerTrait.this.handler;
        }

        @Override
        public IAirHandler mergeContents(List<IAirHandler> contents) {
            return PNCPressureAirHandlerTrait.this.handler;
        }
    }
}

