/*
 * Decompiled with CFR 0.152.
 */
package com.lowdragmc.mbd2.integration.pneumaticcraft.trait.pressure;

import com.lowdragmc.lowdraglib.gui.editor.annotation.Configurable;
import com.lowdragmc.lowdraglib.gui.editor.annotation.LDLRegister;
import com.lowdragmc.lowdraglib.gui.editor.annotation.NumberRange;
import com.lowdragmc.lowdraglib.gui.texture.IGuiTexture;
import com.lowdragmc.lowdraglib.gui.texture.ItemStackTexture;
import com.lowdragmc.lowdraglib.gui.texture.ProgressTexture;
import com.lowdragmc.lowdraglib.gui.widget.ProgressWidget;
import com.lowdragmc.lowdraglib.gui.widget.TextTextureWidget;
import com.lowdragmc.lowdraglib.gui.widget.Widget;
import com.lowdragmc.lowdraglib.gui.widget.WidgetGroup;
import com.lowdragmc.lowdraglib.utils.LocalizationUtils;
import com.lowdragmc.mbd2.common.machine.MBDMachine;
import com.lowdragmc.mbd2.common.trait.ConnectedIO;
import com.lowdragmc.mbd2.common.trait.ITrait;
import com.lowdragmc.mbd2.common.trait.IUIProviderTrait;
import com.lowdragmc.mbd2.common.trait.RecipeCapabilityTraitDefinition;
import com.lowdragmc.mbd2.integration.pneumaticcraft.PNCPressureAirRecipeCapability;
import com.lowdragmc.mbd2.integration.pneumaticcraft.trait.pressure.PNCPressureAirHandlerTrait;
import com.lowdragmc.mbd2.utils.WidgetUtils;
import me.desht.pneumaticcraft.api.pressure.PressureTier;
import me.desht.pneumaticcraft.common.core.ModItems;
import net.minecraft.network.chat.Component;
import net.minecraft.world.item.Item;

@LDLRegister(name="pneumatic_pressure_air_handler", group="trait", modID="pneumaticcraft")
public class PNCPressureAirHandlerTraitDefinition
extends RecipeCapabilityTraitDefinition
implements IUIProviderTrait {
    @Configurable(name="config.definition.trait.pneumatic_pressure_air_handler.volume")
    @NumberRange(range={1.0, 1.7976931348623157E308})
    private int volume = 1;
    @Configurable(name="config.definition.trait.pneumatic_pressure_air_handler.max_pressure", tips={"config.definition.trait.pneumatic_pressure_air_handler.max_pressure.tips"})
    @NumberRange(range={1.0, 1.7976931348623157E308})
    private float maxPressure = 20.0f;
    @Configurable(name="config.definition.trait.pneumatic_pressure_air_handler.danger_pressure", tips={"config.definition.trait.pneumatic_pressure_air_handler.danger_pressure.tips.0", "config.definition.trait.pneumatic_pressure_air_handler.danger_pressure.tips.1"})
    @NumberRange(range={0.0, 1.7976931348623157E308})
    private float dangerPressure = 0.0f;
    @Configurable(name="config.definition.trait.pneumatic_pressure_air_handler.critical_pressure", tips={"config.definition.trait.pneumatic_pressure_air_handler.critical_pressure.tips.0", "config.definition.trait.pneumatic_pressure_air_handler.critical_pressure.tips.1"})
    @NumberRange(range={0.0, 1.7976931348623157E308})
    private float criticalPressure = 0.0f;
    @Configurable(name="config.definition.trait.connected_io", subConfigurable=true, tips={"config.definition.trait.pneumatic_pressure_air_handler.connected_io.tooltip"})
    private final ConnectedIO connectionIO = new ConnectedIO();

    @Override
    public PNCPressureAirHandlerTrait createTrait(MBDMachine machine) {
        return new PNCPressureAirHandlerTrait(machine, this);
    }

    @Override
    public IGuiTexture getIcon() {
        return new ItemStackTexture(new Item[]{(Item)ModItems.PRESSURE_GAUGE.get()});
    }

    @Override
    public boolean allowMultiple() {
        return false;
    }

    public float getRealDangerPressure() {
        return this.dangerPressure == 0.0f ? this.maxPressure : this.dangerPressure;
    }

    public float getRealCriticalPressure() {
        return this.criticalPressure == 0.0f ? this.getRealDangerPressure() : this.criticalPressure;
    }

    public PressureTier getPressureTier() {
        return new PressureTier(){

            public float getDangerPressure() {
                return PNCPressureAirHandlerTraitDefinition.this.getRealDangerPressure();
            }

            public float getCriticalPressure() {
                return PNCPressureAirHandlerTraitDefinition.this.getRealCriticalPressure();
            }
        };
    }

    @Override
    public void createTraitUITemplate(WidgetGroup ui) {
        String prefix = this.uiPrefixName();
        ProgressWidget pressureBar = new ProgressWidget(ProgressWidget.JEIProgress, 0, 0, 100, 15, new ProgressTexture(IGuiTexture.EMPTY, (IGuiTexture)PNCPressureAirRecipeCapability.HUD_BAR));
        pressureBar.setBackground(new IGuiTexture[]{PNCPressureAirRecipeCapability.HUD_BACKGROUND});
        pressureBar.setId(prefix);
        TextTextureWidget energyBarText = new TextTextureWidget(5, 3, 90, 10).setText("0 pressure").textureStyle(texture -> texture.setDropShadow(true));
        energyBarText.setId(prefix + "_text");
        ui.addWidget((Widget)pressureBar);
        ui.addWidget((Widget)energyBarText);
    }

    @Override
    public void initTraitUI(ITrait trait, WidgetGroup group) {
        if (trait instanceof PNCPressureAirHandlerTrait) {
            PNCPressureAirHandlerTrait pressureAirHandlerTrait = (PNCPressureAirHandlerTrait)trait;
            String prefix = this.uiPrefixName();
            WidgetUtils.widgetByIdForEach(group, "^%s$".formatted(prefix), ProgressWidget.class, energyBar -> {
                energyBar.setProgressSupplier(() -> Math.max(pressureAirHandlerTrait.handler.getPressure(), 0.0f) / pressureAirHandlerTrait.handler.maxPressure());
                energyBar.setDynamicHoverTips(value -> LocalizationUtils.format((String)"config.definition.trait.pneumatic_pressure_air_handler.ui_container_hover", (Object[])new Object[]{Math.round((double)pressureAirHandlerTrait.handler.maxPressure() * value), Float.valueOf(pressureAirHandlerTrait.handler.maxPressure())}));
            });
            WidgetUtils.widgetByIdForEach(group, "^%s_text$".formatted(prefix), TextTextureWidget.class, energyBarText -> energyBarText.setText(() -> Component.m_237113_((String)(Math.round(pressureAirHandlerTrait.handler.getPressure()) + " pressure"))));
        }
    }

    public int getVolume() {
        return this.volume;
    }

    public void setVolume(int volume) {
        this.volume = volume;
    }

    public float getMaxPressure() {
        return this.maxPressure;
    }

    public void setMaxPressure(float maxPressure) {
        this.maxPressure = maxPressure;
    }

    public float getDangerPressure() {
        return this.dangerPressure;
    }

    public void setDangerPressure(float dangerPressure) {
        this.dangerPressure = dangerPressure;
    }

    public float getCriticalPressure() {
        return this.criticalPressure;
    }

    public void setCriticalPressure(float criticalPressure) {
        this.criticalPressure = criticalPressure;
    }

    public ConnectedIO getConnectionIO() {
        return this.connectionIO;
    }
}

