/*
 * Decompiled with CFR 0.152.
 */
package com.lowdragmc.mbd2.utils;

import java.io.File;
import java.io.IOException;
import java.nio.file.FileVisitResult;
import java.nio.file.FileVisitor;
import java.nio.file.Files;
import java.nio.file.Path;
import java.nio.file.SimpleFileVisitor;
import java.nio.file.attribute.BasicFileAttributes;
import java.util.function.BiConsumer;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.NbtIo;

public class FileUtils {
    public static void loadNBTFiles(File path, final String extension, final BiConsumer<File, CompoundTag> consumer) {
        if (path.exists() && path.isDirectory()) {
            try {
                Files.walkFileTree(path.toPath(), (FileVisitor<? super Path>)new SimpleFileVisitor<Path>(){

                    @Override
                    public FileVisitResult visitFile(Path path, BasicFileAttributes attrs) {
                        if (path.getFileName().toString().endsWith(extension)) {
                            try {
                                CompoundTag tag = NbtIo.m_128953_((File)path.toFile());
                                if (tag != null) {
                                    consumer.accept(path.toFile(), tag);
                                }
                            }
                            catch (IOException iOException) {
                                // empty catch block
                            }
                        }
                        return FileVisitResult.CONTINUE;
                    }
                });
            }
            catch (IOException iOException) {
                // empty catch block
            }
        }
    }
}

