/*
 * Decompiled with CFR 0.152.
 */
package com.lowdragmc.mbd2.utils;

import com.lowdragmc.mbd2.MBD2;
import net.minecraft.core.Registry;
import net.minecraft.core.registries.BuiltInRegistries;
import net.minecraft.resources.ResourceKey;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.tags.TagKey;
import net.minecraft.world.item.Item;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.material.Fluid;

public class TagUtil {
    public static <T> TagKey<T> optionalTag(Registry<T> registry, ResourceLocation id) {
        return TagKey.m_203882_((ResourceKey)registry.m_123023_(), (ResourceLocation)id);
    }

    public static <T> TagKey<T> optionalTag(ResourceKey<? extends Registry<T>> registryKey, ResourceLocation id) {
        return TagKey.m_203882_(registryKey, (ResourceLocation)id);
    }

    public static <T> TagKey<T> createTag(Registry<T> registry, String path, boolean vanilla) {
        if (vanilla) {
            return TagUtil.optionalTag(registry, new ResourceLocation("minecraft", path));
        }
        return TagUtil.optionalTag(registry, new ResourceLocation("forge", path));
    }

    public static <T> TagKey<T> createTag(ResourceKey<? extends Registry<T>> registryKey, String path, boolean vanilla) {
        if (vanilla) {
            return TagUtil.optionalTag(registryKey, new ResourceLocation("minecraft", path));
        }
        return TagUtil.optionalTag(registryKey, new ResourceLocation("forge", path));
    }

    public static <T> TagKey<T> createModTag(Registry<T> registry, String path) {
        return TagUtil.optionalTag(registry, MBD2.id(path));
    }

    public static <T> TagKey<T> createModTag(ResourceKey<? extends Registry<T>> registryKey, String path) {
        return TagKey.m_203882_(registryKey, (ResourceLocation)MBD2.id(path));
    }

    public static TagKey<Block> createBlockTag(String path) {
        return TagUtil.createTag(BuiltInRegistries.f_256975_, path, false);
    }

    public static TagKey<Block> createBlockTag(String path, boolean vanilla) {
        return TagUtil.createTag(BuiltInRegistries.f_256975_, path, vanilla);
    }

    public static TagKey<Block> createModBlockTag(String path) {
        return TagUtil.createModTag(BuiltInRegistries.f_256975_, path);
    }

    public static TagKey<Item> createItemTag(String path) {
        return TagUtil.createTag(BuiltInRegistries.f_257033_, path, false);
    }

    public static TagKey<Item> createItemTag(String path, boolean vanilla) {
        return TagUtil.createTag(BuiltInRegistries.f_257033_, path, vanilla);
    }

    public static TagKey<Item> createModItemTag(String path) {
        return TagUtil.createModTag(BuiltInRegistries.f_257033_, path);
    }

    public static TagKey<Fluid> createFluidTag(String path) {
        return TagUtil.createTag(BuiltInRegistries.f_257020_, path, false);
    }
}

