/*
 * Decompiled with CFR 0.152.
 */
package com.lowdragmc.mbd2.api.pattern;

import com.google.common.util.concurrent.ThreadFactoryBuilder;
import com.lowdragmc.lowdraglib.Platform;
import com.lowdragmc.mbd2.MBD2;
import com.lowdragmc.mbd2.api.machine.IMultiController;
import com.lowdragmc.mbd2.api.pattern.MultiblockState;
import com.lowdragmc.mbd2.common.machine.MBDMultiblockMachine;
import it.unimi.dsi.fastutil.longs.Long2ObjectMap;
import it.unimi.dsi.fastutil.longs.Long2ObjectOpenHashMap;
import it.unimi.dsi.fastutil.longs.LongOpenHashSet;
import it.unimi.dsi.fastutil.objects.Object2ObjectOpenHashMap;
import it.unimi.dsi.fastutil.objects.ObjectIterator;
import java.util.Collections;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.CopyOnWriteArrayList;
import java.util.concurrent.Executors;
import java.util.concurrent.ScheduledExecutorService;
import java.util.concurrent.ThreadFactory;
import java.util.concurrent.TimeUnit;
import javax.annotation.Nonnull;
import net.minecraft.core.BlockPos;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.world.level.saveddata.SavedData;

public class MultiblockWorldSavedData
extends SavedData {
    private final ServerLevel serverLevel;
    public final Map<BlockPos, MultiblockState> mapping;
    public final Long2ObjectOpenHashMap<Set<MultiblockState>> structureCachePosMapping;
    public final LongOpenHashSet posCache = new LongOpenHashSet();
    private final CopyOnWriteArrayList<IMultiController> controllers = new CopyOnWriteArrayList();
    private ScheduledExecutorService executorService;
    private static final ThreadFactory THREAD_FACTORY = new ThreadFactoryBuilder().setNameFormat("MBD2 Multiblock Async Thread-%d").setDaemon(true).build();
    private static final ThreadLocal<Boolean> IN_SERVICE = ThreadLocal.withInitial(() -> false);
    private long periodID = Long.MIN_VALUE;

    public static MultiblockWorldSavedData getOrCreate(ServerLevel serverLevel) {
        return (MultiblockWorldSavedData)serverLevel.m_8895_().m_164861_(tag -> new MultiblockWorldSavedData(serverLevel, (CompoundTag)tag), () -> new MultiblockWorldSavedData(serverLevel), "MBD2_multiblock");
    }

    private MultiblockWorldSavedData(ServerLevel serverLevel) {
        this.serverLevel = serverLevel;
        this.mapping = new Object2ObjectOpenHashMap();
        this.structureCachePosMapping = new Long2ObjectOpenHashMap();
    }

    private MultiblockWorldSavedData(ServerLevel serverLevel, CompoundTag tag) {
        this(serverLevel);
    }

    public MultiblockState[] getControllerInPos(BlockPos pos) {
        return (MultiblockState[])((Set)this.structureCachePosMapping.getOrDefault(pos.m_121878_(), Collections.emptySet())).toArray(MultiblockState[]::new);
    }

    public void addMapping(MultiblockState state) {
        this.mapping.put(state.controllerPos, state);
        for (BlockPos blockPos : state.getCache()) {
            ((Set)this.structureCachePosMapping.computeIfAbsent(blockPos.m_121878_(), c -> new HashSet())).add(state);
        }
    }

    public void removeMapping(MultiblockState state) {
        this.mapping.remove(state.controllerPos);
        ObjectIterator iterator = this.structureCachePosMapping.long2ObjectEntrySet().iterator();
        while (iterator.hasNext()) {
            Long2ObjectMap.Entry entry = (Long2ObjectMap.Entry)iterator.next();
            Set stateSet = (Set)entry.getValue();
            stateSet.remove(state);
            if (!stateSet.isEmpty()) continue;
            iterator.remove();
        }
    }

    @Nonnull
    public CompoundTag m_7176_(@Nonnull CompoundTag compound) {
        return compound;
    }

    public void createExecutorService() {
        if (this.executorService != null && !this.executorService.isShutdown()) {
            return;
        }
        this.executorService = Executors.newSingleThreadScheduledExecutor(THREAD_FACTORY);
        this.executorService.scheduleAtFixedRate(this::searchingTask, 0L, 250L, TimeUnit.MILLISECONDS);
    }

    public void addAsyncLogic(IMultiController controller) {
        MBDMultiblockMachine machine;
        if (controller instanceof MBDMultiblockMachine && (machine = (MBDMultiblockMachine)controller).getDefinition().multiblockSettings().catalyst().isEnable()) {
            return;
        }
        this.controllers.add(controller);
        this.createExecutorService();
    }

    public void removeAsyncLogic(IMultiController controller) {
        if (this.controllers.contains(controller)) {
            this.controllers.remove(controller);
            if (this.controllers.isEmpty()) {
                this.releaseExecutorService();
            }
        }
    }

    private void searchingTask() {
        try {
            if (Platform.isServerNotSafe()) {
                return;
            }
            IN_SERVICE.set(true);
            for (IMultiController controller : this.controllers) {
                controller.asyncCheckPattern(this.periodID);
            }
        }
        catch (Throwable e) {
            MBD2.LOGGER.error("asyncThreadLogic error: {}", (Object)e.getMessage());
        }
        finally {
            IN_SERVICE.set(false);
        }
        ++this.periodID;
    }

    public static boolean isThreadService() {
        return IN_SERVICE.get() != false && !Platform.isServerNotSafe();
    }

    public void releaseExecutorService() {
        if (this.executorService != null) {
            this.executorService.shutdownNow();
        }
        this.executorService = null;
    }

    public ServerLevel getServerLevel() {
        return this.serverLevel;
    }

    public long getPeriodID() {
        return this.periodID;
    }
}

