/*
 * Decompiled with CFR 0.152.
 */
package com.lowdragmc.mbd2.client.renderer;

import com.lowdragmc.lowdraglib.client.model.forge.LDLRendererModel;
import com.lowdragmc.lowdraglib.client.renderer.IRenderer;
import com.lowdragmc.mbd2.api.machine.IMachine;
import com.lowdragmc.mbd2.common.machine.MBDMachine;
import com.lowdragmc.mbd2.common.trait.TraitDefinition;
import com.mojang.blaze3d.vertex.PoseStack;
import java.util.Collections;
import java.util.List;
import java.util.Optional;
import java.util.function.BooleanSupplier;
import java.util.function.Supplier;
import net.minecraft.client.renderer.MultiBufferSource;
import net.minecraft.client.renderer.block.model.BakedQuad;
import net.minecraft.client.renderer.texture.TextureAtlasSprite;
import net.minecraft.client.resources.model.BakedModel;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.core.Position;
import net.minecraft.core.Vec3i;
import net.minecraft.util.RandomSource;
import net.minecraft.world.item.ItemDisplayContext;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.BlockAndTintGetter;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.phys.Vec3;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;
import net.minecraftforge.client.model.data.ModelData;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@OnlyIn(value=Dist.CLIENT)
public class MBDBlockRenderer
implements IRenderer {
    protected final BooleanSupplier useAO;
    protected final Supplier<IRenderer> defaultRenderer;

    public boolean useAO() {
        return this.useAO.getAsBoolean();
    }

    public Optional<MBDMachine> getMachine(@Nullable BlockAndTintGetter level, @Nullable BlockPos pos) {
        if (level == null || pos == null) {
            return Optional.empty();
        }
        return IMachine.ofMachine((BlockGetter)level, pos).filter(MBDMachine.class::isInstance).map(MBDMachine.class::cast);
    }

    public Optional<MBDMachine> getMachine(@Nullable BlockEntity blockEntity) {
        if (blockEntity == null) {
            return Optional.empty();
        }
        return IMachine.ofMachine(blockEntity).filter(MBDMachine.class::isInstance).map(MBDMachine.class::cast);
    }

    public void renderItem(ItemStack stack, ItemDisplayContext transformType, boolean leftHand, PoseStack poseStack, MultiBufferSource buffer, int combinedLight, int combinedOverlay, BakedModel model) {
        throw new UnsupportedOperationException("Not implemented yet");
    }

    public List<BakedQuad> renderModel(@Nullable BlockAndTintGetter level, @Nullable BlockPos pos, @Nullable BlockState state, @Nullable Direction side, RandomSource rand) {
        return this.getMachine(level, pos).filter(machine -> !machine.isDisableRendering()).map(machine -> machine.getMachineState().getRealRenderer().renderModel(level, pos, state, side, rand)).orElseGet(Collections::emptyList);
    }

    @NotNull
    public TextureAtlasSprite getParticleTexture() {
        ModelData modelData = (ModelData)LDLRendererModel.RendererBakedModel.CURRENT_MODEL_DATA.get();
        if (modelData != null) {
            BlockAndTintGetter world = (BlockAndTintGetter)modelData.get(LDLRendererModel.RendererBakedModel.WORLD);
            BlockPos pos = (BlockPos)modelData.get(LDLRendererModel.RendererBakedModel.POS);
            return this.getMachine(world, pos).map(machine -> machine.getMachineState().getRealRenderer().getParticleTexture()).orElseGet(() -> this.defaultRenderer.get().getParticleTexture());
        }
        return this.defaultRenderer.get().getParticleTexture();
    }

    public boolean hasTESR(BlockEntity blockEntity) {
        return this.getMachine(blockEntity).map(machine -> machine.getMachineState().getRealRenderer().hasTESR(blockEntity) || machine.getDefinition().machineSettings().traitDefinitions().stream().map(definition -> definition.getBESRenderer((IMachine)machine)).anyMatch(renderer -> renderer.hasTESR(blockEntity))).orElse(false);
    }

    public boolean isGlobalRenderer(BlockEntity blockEntity) {
        return this.getMachine(blockEntity).map(machine -> machine.getMachineState().isGlobalVisible() || machine.getMachineState().getRealRenderer().isGlobalRenderer(blockEntity) || machine.getDefinition().machineSettings().traitDefinitions().stream().map(definition -> definition.getBESRenderer((IMachine)machine)).anyMatch(renderer -> renderer.isGlobalRenderer(blockEntity))).orElse(false);
    }

    public boolean shouldRender(BlockEntity blockEntity, Vec3 cameraPos) {
        return this.getMachine(blockEntity).filter(machine -> !machine.isDisableRendering()).map(machine -> Vec3.m_82512_((Vec3i)blockEntity.m_58899_()).m_82509_((Position)cameraPos, (double)machine.getMachineState().renderingRadius())).orElseGet(() -> this.defaultRenderer.get().shouldRender(blockEntity, cameraPos));
    }

    public void render(BlockEntity blockEntity, float partialTicks, PoseStack stack, MultiBufferSource buffer, int combinedLight, int combinedOverlay) {
        this.getMachine(blockEntity).ifPresent(machine -> {
            machine.getMachineState().getRealRenderer().render(blockEntity, partialTicks, stack, buffer, combinedLight, combinedOverlay);
            for (TraitDefinition traitDefinition : machine.getDefinition().machineSettings().traitDefinitions()) {
                IRenderer renderer = traitDefinition.getBESRenderer((IMachine)machine);
                if (!renderer.hasTESR(blockEntity)) continue;
                renderer.render(blockEntity, partialTicks, stack, buffer, combinedLight, combinedOverlay);
            }
        });
    }

    public MBDBlockRenderer(BooleanSupplier useAO, Supplier<IRenderer> defaultRenderer) {
        this.useAO = useAO;
        this.defaultRenderer = defaultRenderer;
    }
}

