/*
 * Decompiled with CFR 0.152.
 */
package com.lowdragmc.mbd2.common.capability.recipe;

import com.gregtechceu.gtceu.api.gui.widget.TankWidget;
import com.gregtechceu.gtceu.integration.xei.entry.fluid.FluidStackList;
import com.gregtechceu.gtceu.integration.xei.entry.fluid.FluidTagList;
import com.gregtechceu.gtceu.integration.xei.handlers.fluid.CycleFluidEntryHandler;
import com.lowdragmc.lowdraglib.gui.editor.accessors.CompoundTagAccessor;
import com.lowdragmc.lowdraglib.gui.editor.configurator.ArrayConfiguratorGroup;
import com.lowdragmc.lowdraglib.gui.editor.configurator.Configurator;
import com.lowdragmc.lowdraglib.gui.editor.configurator.ConfiguratorGroup;
import com.lowdragmc.lowdraglib.gui.editor.configurator.ConfiguratorSelectorConfigurator;
import com.lowdragmc.lowdraglib.gui.editor.configurator.FluidConfigurator;
import com.lowdragmc.lowdraglib.gui.editor.configurator.NumberConfigurator;
import com.lowdragmc.lowdraglib.gui.editor.configurator.SearchComponentConfigurator;
import com.lowdragmc.lowdraglib.gui.editor.configurator.WrapperConfigurator;
import com.lowdragmc.lowdraglib.gui.texture.GuiTextureGroup;
import com.lowdragmc.lowdraglib.gui.texture.IGuiTexture;
import com.lowdragmc.lowdraglib.gui.texture.ResourceTexture;
import com.lowdragmc.lowdraglib.gui.widget.Widget;
import com.lowdragmc.lowdraglib.jei.IngredientIO;
import com.lowdragmc.lowdraglib.side.fluid.FluidStack;
import com.lowdragmc.lowdraglib.side.fluid.IFluidStorage;
import com.lowdragmc.lowdraglib.side.fluid.IFluidTransfer;
import com.lowdragmc.lowdraglib.side.fluid.forge.FluidHelperImpl;
import com.lowdragmc.lowdraglib.utils.CycleFluidStorage;
import com.lowdragmc.lowdraglib.utils.Size;
import com.lowdragmc.lowdraglib.utils.TagOrCycleFluidTransfer;
import com.lowdragmc.mbd2.MBD2;
import com.lowdragmc.mbd2.api.capability.recipe.RecipeCapability;
import com.lowdragmc.mbd2.api.recipe.content.Content;
import com.lowdragmc.mbd2.api.recipe.content.SerializerFluidIngredient;
import com.lowdragmc.mbd2.api.recipe.ingredient.FluidIngredient;
import com.mojang.datafixers.util.Either;
import com.mojang.datafixers.util.Pair;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.Consumer;
import java.util.function.Supplier;
import java.util.stream.Collectors;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.MutableComponent;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.tags.FluidTags;
import net.minecraft.tags.TagKey;
import net.minecraft.world.level.material.Fluid;
import net.minecraft.world.level.material.Fluids;
import net.minecraftforge.fluids.capability.IFluidHandler;
import net.minecraftforge.registries.ForgeRegistries;
import net.minecraftforge.registries.tags.ITag;
import net.minecraftforge.registries.tags.ITagManager;

public class FluidRecipeCapability
extends RecipeCapability<FluidIngredient> {
    public static final String FLUID_TYPE = "recipe.capability.fluid.ingredient.values.fluid";
    public static final String TAG_TYPE = "recipe.capability.fluid.ingredient.values.tag";
    public static final FluidRecipeCapability CAP = new FluidRecipeCapability();

    protected FluidRecipeCapability() {
        super("fluid", SerializerFluidIngredient.INSTANCE);
    }

    @Override
    public FluidIngredient createDefaultContent() {
        return FluidIngredient.of(1000L, new Fluid[]{Fluids.f_76193_});
    }

    @Override
    public Widget createPreviewWidget(FluidIngredient content) {
        CycleFluidStorage storage = new CycleFluidStorage(content.getAmount(), Arrays.stream(content.getStacks()).toList());
        return new com.lowdragmc.lowdraglib.gui.widget.TankWidget((IFluidStorage)storage, 0, 0, false, false).setDrawHoverOverlay(false);
    }

    @Override
    public Widget createXEITemplate() {
        com.lowdragmc.lowdraglib.gui.widget.TankWidget tankWidget = new com.lowdragmc.lowdraglib.gui.widget.TankWidget();
        tankWidget.initTemplate();
        tankWidget.setSize(new Size(20, 58));
        tankWidget.setOverlay((IGuiTexture)new ResourceTexture("mbd2:textures/gui/fluid_tank_overlay.png"));
        tankWidget.setShowAmount(false);
        return tankWidget;
    }

    @Override
    public void bindXEIWidget(Widget widget, Content content, IngredientIO ingredientIO) {
        if (widget instanceof com.lowdragmc.lowdraglib.gui.widget.TankWidget) {
            com.lowdragmc.lowdraglib.gui.widget.TankWidget tankWidget = (com.lowdragmc.lowdraglib.gui.widget.TankWidget)widget;
            FluidIngredient fluidIngredient = (FluidIngredient)this.of(content.content);
            Either either = null;
            if (Arrays.stream(fluidIngredient.values).allMatch(FluidIngredient.TagValue.class::isInstance)) {
                either = Either.left(Arrays.stream(fluidIngredient.values).map(FluidIngredient.TagValue.class::cast).map(FluidIngredient.TagValue::getTag).map(tagValue -> new Pair(tagValue, (Object)fluidIngredient.getAmount())).toList());
            }
            if (either == null) {
                either = Either.right(List.of(fluidIngredient.getStacks()));
            }
            if (tankWidget.getOverlay() == null || tankWidget.getOverlay() == IGuiTexture.EMPTY) {
                tankWidget.setOverlay(content.createOverlay());
            } else {
                GuiTextureGroup groupTexture = new GuiTextureGroup(new IGuiTexture[]{tankWidget.getOverlay(), content.createOverlay()});
                tankWidget.setOverlay((IGuiTexture)groupTexture);
            }
            tankWidget.setFluidTank((IFluidTransfer)new TagOrCycleFluidTransfer(List.of(either)), 0);
            tankWidget.setIngredientIO(ingredientIO);
            tankWidget.setAllowClickDrained(false);
            tankWidget.setAllowClickFilled(false);
            tankWidget.setXEIChance(content.chance);
        } else if (MBD2.isGTMLoaded()) {
            try {
                if (widget instanceof TankWidget) {
                    TankWidget tankWidget = (TankWidget)widget;
                    FluidIngredient fluidIngredient = (FluidIngredient)this.of(content.content);
                    ArrayList fluidEntries = new ArrayList();
                    Object either = null;
                    Arrays.stream(fluidIngredient.values).forEach(value -> {
                        if (value instanceof FluidIngredient.TagValue) {
                            FluidIngredient.TagValue tagValue = (FluidIngredient.TagValue)value;
                            fluidEntries.add(FluidTagList.of(tagValue.getTag(), (int)((int)fluidIngredient.getAmount()), null));
                        } else {
                            fluidEntries.add(FluidStackList.of(Arrays.stream(fluidIngredient.getStacks()).map(FluidHelperImpl::toFluidStack).toList()));
                        }
                    });
                    if (tankWidget.getOverlay() == null || tankWidget.getOverlay() == IGuiTexture.EMPTY) {
                        tankWidget.setOverlay(content.createOverlay());
                    } else {
                        GuiTextureGroup groupTexture = new GuiTextureGroup(new IGuiTexture[]{tankWidget.getOverlay(), content.createOverlay()});
                        tankWidget.setOverlay((IGuiTexture)groupTexture);
                    }
                    tankWidget.setFluidTank((IFluidHandler)new CycleFluidEntryHandler(fluidEntries), 0);
                    tankWidget.setIngredientIO(ingredientIO);
                    tankWidget.setAllowClickDrained(false);
                    tankWidget.setAllowClickFilled(false);
                    tankWidget.setXEIChance(content.chance);
                }
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
    }

    @Override
    public void createContentConfigurator(ConfiguratorGroup father, Supplier<FluidIngredient> supplier, Consumer<FluidIngredient> onUpdate) {
        father.addConfigurators(new Configurator[]{new NumberConfigurator("recipe.capability.fluid.ingredient.amount", () -> ((FluidIngredient)supplier.get()).getAmount(), number -> {
            int amount = number.intValue();
            onUpdate.accept(((FluidIngredient)supplier.get()).copy(amount));
        }, (Number)1, true).setRange((Number)1, (Number)Integer.MAX_VALUE)});
        ArrayConfiguratorGroup valuesGroup = new ArrayConfiguratorGroup("recipe.capability.fluid.ingredient.candidates", false, () -> Arrays.stream(((FluidIngredient)supplier.get()).values).collect(Collectors.toList()), (getter, setter) -> new ConfiguratorSelectorConfigurator("recipe.capability.item.ingredient.values.type", false, getter, setter, (Object)new FluidIngredient.FluidValue((Fluid)Fluids.f_76193_), true, List.of(new FluidIngredient.FluidValue((Fluid)Fluids.f_76193_), new FluidIngredient.TagValue((TagKey<Fluid>)FluidTags.f_13132_)), value -> {
            if (value instanceof FluidIngredient.FluidValue) {
                return FLUID_TYPE;
            }
            if (value instanceof FluidIngredient.TagValue) {
                return TAG_TYPE;
            }
            return FLUID_TYPE;
        }, (value, valueGroup) -> {
            CycleFluidStorage fluidStorage = new CycleFluidStorage(1L, value.getStacks().stream().map(fluid -> FluidStack.create((Fluid)fluid, (long)1L)).toList());
            com.lowdragmc.lowdraglib.gui.widget.TankWidget tank = new com.lowdragmc.lowdraglib.gui.widget.TankWidget((IFluidStorage)fluidStorage, 0, 0, false, false);
            tank.setBackground((IGuiTexture)com.lowdragmc.lowdraglib.gui.widget.TankWidget.FLUID_SLOT_TEXTURE);
            tank.setShowAmount(false);
            tank.setClientSideWidget();
            if (value instanceof FluidIngredient.FluidValue) {
                FluidIngredient.FluidValue fluidValue = (FluidIngredient.FluidValue)value;
                Configurator[] configuratorArray = new Configurator[1];
                configuratorArray[0] = new FluidConfigurator(FLUID_TYPE, fluidValue::getFluid, fluid -> {
                    fluidValue.setFluid((Fluid)fluid);
                    fluidStorage.updateStacks(value.getStacks().stream().map(f -> FluidStack.create((Fluid)f, (long)1L)).toList());
                    setter.accept(value);
                }, (Fluid)Fluids.f_76193_, true);
                valueGroup.addConfigurators(configuratorArray);
            } else if (value instanceof FluidIngredient.TagValue) {
                FluidIngredient.TagValue tagValue = (FluidIngredient.TagValue)value;
                valueGroup.addConfigurators(new Configurator[]{new SearchComponentConfigurator(TAG_TYPE, () -> tagValue.getTag().f_203868_(), tagKey -> {
                    tagValue.setTag((TagKey<Fluid>)FluidTags.create((ResourceLocation)tagKey));
                    fluidStorage.updateStacks(value.getStacks().stream().map(f -> FluidStack.create((Fluid)f, (long)1L)).toList());
                    setter.accept(value);
                }, (Object)FluidTags.f_13132_.f_203868_(), true, (word, find) -> {
                    ITagManager tags = ForgeRegistries.FLUIDS.tags();
                    if (tags == null) {
                        return;
                    }
                    for (ITag tag : tags) {
                        if (Thread.currentThread().isInterrupted()) {
                            return;
                        }
                        ResourceLocation tagKey = tag.getKey().f_203868_();
                        if (!tagKey.toString().toLowerCase().contains(word.toLowerCase())) continue;
                        find.accept(tagKey);
                    }
                }, ResourceLocation::toString)});
            }
            valueGroup.addConfigurators(new Configurator[]{new WrapperConfigurator("ldlib.gui.editor.group.preview", (Widget)tank)});
        }), true);
        valuesGroup.setAddDefault(() -> new FluidIngredient.FluidValue((Fluid)Fluids.f_76193_));
        valuesGroup.setOnAdd(value -> {
            FluidIngredient fluidIngredient = (FluidIngredient)supplier.get();
            FluidIngredient.Value[] values = fluidIngredient.values;
            FluidIngredient.Value[] newValues = Arrays.copyOf(values, values.length + 1);
            newValues[values.length] = value;
            fluidIngredient.values = newValues;
            fluidIngredient.stacks = null;
        });
        valuesGroup.setOnRemove(value -> {
            FluidIngredient fluidIngredient = (FluidIngredient)supplier.get();
            FluidIngredient.Value[] values = fluidIngredient.values;
            fluidIngredient.values = (FluidIngredient.Value[])Arrays.stream(values).filter(v -> v != value).toArray(FluidIngredient.Value[]::new);
            fluidIngredient.stacks = null;
        });
        valuesGroup.setOnUpdate(values -> {
            FluidIngredient fluidIngredient = (FluidIngredient)supplier.get();
            fluidIngredient.values = (FluidIngredient.Value[])values.toArray(FluidIngredient.Value[]::new);
            fluidIngredient.stacks = null;
        });
        father.addConfigurators(new Configurator[]{valuesGroup});
        try {
            father.addConfigurators(new Configurator[]{new CompoundTagAccessor().create("ldlib.gui.editor.configurator.nbt", () -> Optional.ofNullable(((FluidIngredient)supplier.get()).getNbt()).orElseGet(CompoundTag::new), tag -> {
                CompoundTag newTag;
                FluidIngredient fluidIngredient = (FluidIngredient)supplier.get();
                CompoundTag compoundTag = newTag = tag.m_128456_() ? null : tag;
                if (Objects.equals(newTag, fluidIngredient.getNbt())) {
                    return;
                }
                fluidIngredient.setNbt(newTag);
                onUpdate.accept(fluidIngredient);
            }, false, RecipeCapability.class.getField("name"))});
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    @Override
    public Component getLeftErrorInfo(List<FluidIngredient> left) {
        MutableComponent result = Component.m_237119_();
        for (int i = 0; i < left.size(); ++i) {
            FluidIngredient fluidIngredient = left.get(i);
            result.m_130946_(fluidIngredient.getAmount() + "x ");
            FluidStack[] stacks = fluidIngredient.getStacks();
            if (stacks.length > 0) {
                result.m_7220_(stacks[0].getDisplayName());
            } else {
                result.m_130946_("Unknown");
            }
            if (fluidIngredient.getNbt() != null) {
                result.m_130946_(" with NBT");
                result.m_130946_(fluidIngredient.getNbt().toString());
            }
            if (i >= left.size() - 1) continue;
            result.m_130946_(", ");
        }
        return result;
    }
}

