/*
 * Decompiled with CFR 0.152.
 */
package com.lowdragmc.mbd2.common.graphprocessor.node;

import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import com.google.gson.JsonParser;
import com.lowdragmc.lowdraglib.gui.editor.annotation.Configurable;
import com.lowdragmc.lowdraglib.gui.editor.annotation.LDLRegister;
import com.lowdragmc.lowdraglib.gui.editor.configurator.ConfiguratorGroup;
import com.lowdragmc.lowdraglib.gui.graphprocessor.annotation.InputPort;
import com.lowdragmc.lowdraglib.gui.graphprocessor.annotation.OutputPort;
import com.lowdragmc.lowdraglib.gui.graphprocessor.data.BaseNode;
import com.lowdragmc.lowdraglib.gui.graphprocessor.data.NodePort;
import com.lowdragmc.mbd2.api.recipe.MBDRecipe;
import com.lowdragmc.mbd2.api.recipe.MBDRecipeSerializer;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.resources.ResourceLocation;

@LDLRegister(name="recipe create", group="graph_processor.node.mbd2.machine.recipe")
public class RecipeCreateNode
extends BaseNode {
    @InputPort
    public Object in;
    @InputPort
    public String id;
    @OutputPort
    public MBDRecipe out;
    @Configurable(name="id")
    public String internalID = "mbd2:recipe_on_the_fly";

    protected void process() {
        if (this.id != null && !ResourceLocation.m_135830_((String)this.id)) {
            return;
        }
        ResourceLocation recipeID = new ResourceLocation(this.id == null ? this.internalID : this.id);
        Object object = this.in;
        if (object instanceof CompoundTag) {
            CompoundTag tag = (CompoundTag)object;
            this.out = MBDRecipeSerializer.SERIALIZER.fromNBT(recipeID, tag);
        } else {
            JsonElement json;
            object = this.in;
            if (object instanceof JsonObject) {
                JsonObject json2 = (JsonObject)object;
                this.out = MBDRecipeSerializer.SERIALIZER.fromJson(recipeID, json2);
            } else if (this.in instanceof CharSequence && (json = JsonParser.parseString((String)this.in.toString())).isJsonObject()) {
                this.out = MBDRecipeSerializer.SERIALIZER.fromJson(recipeID, json.getAsJsonObject());
            }
        }
    }

    public void buildConfigurator(ConfiguratorGroup father) {
        for (NodePort port : this.getInputPorts()) {
            if (!port.fieldName.equals("id") || port.getEdges().isEmpty()) continue;
            return;
        }
        super.buildConfigurator(father);
    }
}

