/*
 * Decompiled with CFR 0.152.
 */
package com.lowdragmc.mbd2.common.gui.editor;

import com.lowdragmc.lowdraglib.client.renderer.IRenderer;
import com.lowdragmc.lowdraglib.client.renderer.impl.IModelRenderer;
import com.lowdragmc.lowdraglib.client.renderer.impl.UIResourceRenderer;
import com.lowdragmc.lowdraglib.gui.editor.annotation.LDLRegister;
import com.lowdragmc.lowdraglib.gui.editor.configurator.IConfigurableWidget;
import com.lowdragmc.lowdraglib.gui.editor.data.IProject;
import com.lowdragmc.lowdraglib.gui.editor.data.Resources;
import com.lowdragmc.lowdraglib.gui.editor.data.resource.ColorsResource;
import com.lowdragmc.lowdraglib.gui.editor.data.resource.EntriesResource;
import com.lowdragmc.lowdraglib.gui.editor.data.resource.IRendererResource;
import com.lowdragmc.lowdraglib.gui.editor.data.resource.Resource;
import com.lowdragmc.lowdraglib.gui.editor.data.resource.TexturesResource;
import com.lowdragmc.lowdraglib.gui.editor.ui.Editor;
import com.lowdragmc.lowdraglib.gui.editor.ui.StringTabContainer;
import com.lowdragmc.lowdraglib.gui.texture.IGuiTexture;
import com.lowdragmc.lowdraglib.gui.texture.ResourceBorderTexture;
import com.lowdragmc.lowdraglib.gui.texture.UIResourceTexture;
import com.lowdragmc.lowdraglib.gui.widget.Widget;
import com.lowdragmc.lowdraglib.gui.widget.WidgetGroup;
import com.lowdragmc.lowdraglib.gui.widget.custom.PlayerInventoryWidget;
import com.lowdragmc.lowdraglib.utils.Position;
import com.lowdragmc.mbd2.MBD2;
import com.lowdragmc.mbd2.common.gui.editor.MachineEditor;
import com.lowdragmc.mbd2.common.gui.editor.machine.MachineConfigPanel;
import com.lowdragmc.mbd2.common.gui.editor.machine.MachineEventsPanel;
import com.lowdragmc.mbd2.common.gui.editor.machine.MachineTraitPanel;
import com.lowdragmc.mbd2.common.gui.editor.machine.MachineUIPanel;
import com.lowdragmc.mbd2.common.machine.definition.MBDMachineDefinition;
import com.lowdragmc.mbd2.common.machine.definition.config.MachineState;
import com.lowdragmc.mbd2.common.machine.definition.config.StateMachine;
import java.io.File;
import java.io.IOException;
import java.util.LinkedHashMap;
import java.util.Map;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.NbtIo;
import net.minecraft.nbt.Tag;
import net.minecraft.resources.ResourceLocation;

@LDLRegister(name="sm", group="editor.machine")
public class MachineProject
implements IProject {
    public static final IRenderer FURNACE_RENDERER = new IModelRenderer(new ResourceLocation("block/furnace"));
    protected Resources resources;
    protected MBDMachineDefinition definition;
    protected WidgetGroup ui;

    public MachineProject(Resources resources, MBDMachineDefinition definition, WidgetGroup ui) {
        this.resources = resources;
        this.definition = definition;
        this.ui = ui;
        if (this.definition != null) {
            this.definition.loadFactory();
        }
    }

    protected Map<String, Resource<?>> createResources() {
        LinkedHashMap resources = new LinkedHashMap();
        EntriesResource entries = new EntriesResource();
        entries.buildDefault();
        resources.put("ldlib.gui.editor.group.entries", (Resource<?>)entries);
        IRendererResource renderer = new IRendererResource();
        resources.put("ldlib.gui.editor.group.renderer", (Resource<?>)renderer);
        TexturesResource texture = new TexturesResource();
        resources.put("ldlib.gui.editor.group.textures", (Resource<?>)texture);
        ColorsResource color = new ColorsResource();
        color.buildDefault();
        resources.put("ldlib.gui.editor.group.colors", (Resource<?>)color);
        return resources;
    }

    protected MBDMachineDefinition createDefinition() {
        return MBDMachineDefinition.builder().id(MBD2.id("new_machine")).rootState((MachineState)StateMachine.createSingleDefault(MachineState::builder, FURNACE_RENDERER)).build();
    }

    protected WidgetGroup createDefaultUI() {
        WidgetGroup group = new WidgetGroup(150, 50, 176, 180);
        group.setBackground(new IGuiTexture[]{ResourceBorderTexture.BORDERED_BACKGROUND});
        PlayerInventoryWidget inventory = new PlayerInventoryWidget();
        inventory.setSelfPosition(new Position((group.getSize().width - inventory.getSize().width) / 2, group.getSize().height - 2 - inventory.getSize().height));
        group.addWidget((Widget)inventory);
        return group;
    }

    public MachineProject newEmptyProject() {
        return new MachineProject(new Resources(this.createResources()), this.createDefinition(), this.createDefaultUI());
    }

    public File getProjectWorkSpace(Editor editor) {
        return new File(editor.getWorkSpace(), "machine");
    }

    public CompoundTag serializeNBT() {
        CompoundTag tag = new CompoundTag();
        tag.m_128365_("resources", (Tag)this.resources.serializeNBT());
        UIResourceRenderer.setCurrentResource((Resource)((Resource)this.resources.resources.get("ldlib.gui.editor.group.renderer")), (boolean)true);
        tag.m_128365_("definition", (Tag)this.definition.serializeNBT());
        UIResourceTexture.clearCurrentResource();
        tag.m_128365_("ui", (Tag)IConfigurableWidget.serializeNBT((IConfigurableWidget)this.ui, (Resources)this.resources, (boolean)true));
        return tag;
    }

    public Resources loadResources(CompoundTag tag) {
        Resources resources = new Resources(this.createResources());
        resources.deserializeNBT(tag);
        return resources;
    }

    public void deserializeNBT(CompoundTag tag) {
        this.resources = this.loadResources(tag.m_128469_("resources"));
        if (this.definition == null) {
            this.definition = this.createDefinition();
            this.definition.loadFactory();
        }
        UIResourceRenderer.setCurrentResource((Resource)((Resource)this.resources.resources.get("ldlib.gui.editor.group.renderer")), (boolean)true);
        this.definition.deserializeNBT(tag.m_128469_("definition"));
        UIResourceTexture.clearCurrentResource();
        this.ui = new WidgetGroup();
        IConfigurableWidget.deserializeNBT((IConfigurableWidget)this.ui, (CompoundTag)tag.m_128469_("ui"), (Resources)this.resources, (boolean)true);
    }

    public void saveProject(File file) {
        try {
            NbtIo.m_128955_((CompoundTag)this.serializeNBT(), (File)file);
        }
        catch (IOException iOException) {
            // empty catch block
        }
    }

    public void onLoad(Editor editor) {
        if (editor instanceof MachineEditor) {
            MachineEditor machineEditor = (MachineEditor)editor;
            super.onLoad(editor);
            StringTabContainer tabContainer = machineEditor.getTabPages();
            MachineConfigPanel machineConfigPanel = this.createMachineConfigPanel(machineEditor);
            MachineTraitPanel machineTraitPanel = this.createMachineTraitPanel(machineEditor);
            MachineEventsPanel machineEventsPanel = this.createMachineEventsPanel(machineEditor);
            MachineUIPanel machineUIPanel = this.createMachineUIPanel(machineEditor);
            tabContainer.addTab("editor.machine.basic_settings", (WidgetGroup)machineConfigPanel, machineConfigPanel::onPanelSelected);
            tabContainer.addTab("editor.machine.machine_traits", (WidgetGroup)machineTraitPanel, machineTraitPanel::onPanelSelected, machineTraitPanel::onPanelDeselected);
            tabContainer.addTab("editor.machine.machine_events", (WidgetGroup)machineEventsPanel, machineEventsPanel::onPanelSelected, machineEventsPanel::onPanelDeselected);
            tabContainer.addTab("editor.machine.machine_ui", (WidgetGroup)machineUIPanel, machineUIPanel::onPanelSelected, machineUIPanel::onPanelDeselected);
        }
    }

    protected MachineConfigPanel createMachineConfigPanel(MachineEditor editor) {
        return new MachineConfigPanel(editor);
    }

    protected MachineTraitPanel createMachineTraitPanel(MachineEditor editor) {
        return new MachineTraitPanel(editor);
    }

    protected MachineEventsPanel createMachineEventsPanel(MachineEditor editor) {
        return new MachineEventsPanel(editor);
    }

    protected MachineUIPanel createMachineUIPanel(MachineEditor editor) {
        return new MachineUIPanel(editor);
    }

    public void onClosed(Editor editor) {
        editor.getFloatView().clearAllWidgets();
    }

    public Resources getResources() {
        return this.resources;
    }

    public MBDMachineDefinition getDefinition() {
        return this.definition;
    }

    public WidgetGroup getUi() {
        return this.ui;
    }

    public MachineProject() {
    }
}

