/*
 * Decompiled with CFR 0.152.
 */
package com.lowdragmc.mbd2.common.machine;

import com.google.common.collect.Table;
import com.lowdragmc.lowdraglib.syncdata.annotation.DescSynced;
import com.lowdragmc.lowdraglib.syncdata.annotation.Persisted;
import com.lowdragmc.lowdraglib.syncdata.annotation.RequireRerender;
import com.lowdragmc.lowdraglib.syncdata.annotation.UpdateListener;
import com.lowdragmc.lowdraglib.syncdata.field.ManagedFieldHolder;
import com.lowdragmc.mbd2.api.block.ProxyPartBlock;
import com.lowdragmc.mbd2.api.blockentity.IMachineBlockEntity;
import com.lowdragmc.mbd2.api.blockentity.ProxyPartBlockEntity;
import com.lowdragmc.mbd2.api.capability.recipe.IO;
import com.lowdragmc.mbd2.api.capability.recipe.IRecipeHandler;
import com.lowdragmc.mbd2.api.capability.recipe.IRecipeHandlerTrait;
import com.lowdragmc.mbd2.api.capability.recipe.RecipeCapability;
import com.lowdragmc.mbd2.api.capability.recipe.RecipeHandlerSlotsProxy;
import com.lowdragmc.mbd2.api.machine.IMachine;
import com.lowdragmc.mbd2.api.machine.IMultiController;
import com.lowdragmc.mbd2.api.machine.IMultiPart;
import com.lowdragmc.mbd2.api.pattern.BlockPattern;
import com.lowdragmc.mbd2.api.pattern.MultiblockState;
import com.lowdragmc.mbd2.api.pattern.MultiblockWorldSavedData;
import com.lowdragmc.mbd2.api.recipe.MBDRecipe;
import com.lowdragmc.mbd2.api.recipe.RecipeLogic;
import com.lowdragmc.mbd2.api.recipe.content.ContentModifier;
import com.lowdragmc.mbd2.client.renderer.MultiblockInWorldPreviewRenderer;
import com.lowdragmc.mbd2.common.machine.MBDMachine;
import com.lowdragmc.mbd2.common.machine.definition.MultiblockMachineDefinition;
import com.lowdragmc.mbd2.common.machine.definition.config.MachineState;
import com.lowdragmc.mbd2.common.machine.definition.config.event.MachineRecipeStatusChangedEvent;
import com.lowdragmc.mbd2.common.machine.definition.config.event.MachineStructureFormedEvent;
import com.lowdragmc.mbd2.common.machine.definition.config.event.MachineStructureInvalidEvent;
import com.lowdragmc.mbd2.common.machine.definition.config.event.MachineUseCatalystEvent;
import com.lowdragmc.mbd2.common.machine.definition.config.toggle.ToggleCatalyst;
import com.lowdragmc.mbd2.config.ConfigHolder;
import it.unimi.dsi.fastutil.longs.Long2ObjectMaps;
import it.unimi.dsi.fastutil.longs.LongSet;
import it.unimi.dsi.fastutil.longs.LongSets;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.locks.Lock;
import java.util.concurrent.locks.ReentrantLock;
import javax.annotation.Nonnull;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.InteractionResult;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.phys.BlockHitResult;
import net.minecraftforge.common.MinecraftForge;
import net.minecraftforge.eventbus.api.Event;
import org.jetbrains.annotations.Nullable;

public class MBDMultiblockMachine
extends MBDMachine
implements IMultiController {
    protected static final ManagedFieldHolder MANAGED_FIELD_HOLDER = new ManagedFieldHolder(MBDMultiblockMachine.class, MBDMachine.MANAGED_FIELD_HOLDER);
    private MultiblockState multiblockState;
    private final List<IMultiPart> parts = new ArrayList<IMultiPart>();
    @DescSynced
    @UpdateListener(methodName="onPartsUpdated")
    private BlockPos[] partPositions = new BlockPos[0];
    @Persisted
    @DescSynced
    @RequireRerender
    protected boolean isFormed;
    protected Set<BlockPos> renderingDisabledPositions = new HashSet<BlockPos>();
    private final Lock patternLock = new ReentrantLock();
    @Persisted
    @Nullable
    private BlockState originalBlock;
    private boolean isFormedValid = false;

    @Override
    public ManagedFieldHolder getFieldHolder() {
        return MANAGED_FIELD_HOLDER;
    }

    public MBDMultiblockMachine(IMachineBlockEntity machineHolder, MultiblockMachineDefinition definition, Object ... args) {
        super(machineHolder, definition, args);
    }

    @Override
    public void onLoad() {
        super.onLoad();
        Level level = this.getLevel();
        if (level instanceof ServerLevel) {
            ServerLevel serverLevel = (ServerLevel)level;
            MultiblockWorldSavedData.getOrCreate(serverLevel).addAsyncLogic(this);
        }
    }

    @Override
    public void onUnload() {
        super.onUnload();
        Level level = this.getLevel();
        if (level instanceof ServerLevel) {
            ServerLevel serverLevel = (ServerLevel)level;
            MultiblockWorldSavedData.getOrCreate(serverLevel).removeAsyncLogic(this);
        }
    }

    @Override
    public void serverTick() {
        Level level;
        if (this.isFormed && !this.isFormedValid && (level = this.getLevel()) instanceof ServerLevel) {
            ServerLevel serverLevel = (ServerLevel)level;
            if (this.checkPatternWithTryLock()) {
                this.onStructureFormed();
                MultiblockWorldSavedData mwsd = MultiblockWorldSavedData.getOrCreate(serverLevel);
                mwsd.addMapping(this.getMultiblockState());
                mwsd.removeAsyncLogic(this);
            }
        }
        super.serverTick();
    }

    @Override
    public MultiblockMachineDefinition getDefinition() {
        return (MultiblockMachineDefinition)super.getDefinition();
    }

    @Override
    public void notifyRecipeStatusChanged(RecipeLogic.Status oldStatus, RecipeLogic.Status newStatus) {
        IMultiController.super.notifyRecipeStatusChanged(oldStatus, newStatus);
        if (this.isFormed) {
            switch (newStatus) {
                case WORKING: {
                    this.setMachineState("working");
                    break;
                }
                case IDLE: {
                    this.setMachineState("formed");
                    break;
                }
                case WAITING: {
                    this.setMachineState("waiting");
                    break;
                }
                case SUSPEND: {
                    this.setMachineState("suspend");
                }
            }
        } else {
            this.setMachineState("base");
        }
        MinecraftForge.EVENT_BUS.post((Event)new MachineRecipeStatusChangedEvent(this, oldStatus, newStatus).postCustomEvent());
    }

    @Override
    @Nullable
    public MBDRecipe getModifiedRecipe(@Nonnull MBDRecipe recipe) {
        return IMultiController.super.getModifiedRecipe(this.getDefinition().recipeLogicSettings().recipeModifiers().applyModifiers(this.getRecipeLogic(), recipe));
    }

    @Override
    public ContentModifier getMaxParallel(@Nonnull MBDRecipe recipe) {
        ContentModifier maxParallel = this.getDefinition().recipeLogicSettings().recipeModifiers().getMaxParallel(this.getRecipeLogic(), recipe);
        return maxParallel.merge(IMultiController.super.getMaxParallel(recipe));
    }

    @Override
    public boolean alwaysTryModifyRecipe() {
        return super.alwaysTryModifyRecipe() || IMultiController.super.alwaysTryModifyRecipe();
    }

    @Override
    public boolean beforeWorking(MBDRecipe recipe) {
        if (super.beforeWorking(recipe)) {
            return true;
        }
        return IMultiController.super.beforeWorking(recipe);
    }

    @Override
    public boolean onWorking() {
        if (super.onWorking()) {
            return true;
        }
        return IMultiController.super.onWorking();
    }

    @Override
    public void onWaiting() {
        super.onWaiting();
        IMultiController.super.onWaiting();
    }

    @Override
    public void afterWorking() {
        super.afterWorking();
        IMultiController.super.afterWorking();
    }

    @Override
    public BlockPattern getPattern() {
        return this.getDefinition().getPattern(this);
    }

    @Override
    @Nonnull
    public MultiblockState getMultiblockState() {
        if (this.multiblockState == null) {
            this.multiblockState = new MultiblockState(this.getLevel(), this.getPos());
        }
        return this.multiblockState;
    }

    protected void onPartsUpdated(BlockPos[] newValue, BlockPos[] oldValue) {
        this.parts.clear();
        for (BlockPos pos : newValue) {
            IMultiPart.ofPart((BlockGetter)this.getLevel(), pos).ifPresent(this.parts::add);
        }
    }

    protected void updatePartPositions() {
        this.partPositions = this.parts.isEmpty() ? new BlockPos[]{} : (BlockPos[])this.parts.stream().map(IMachine::getPos).toArray(BlockPos[]::new);
    }

    @Override
    public List<IMultiPart> getParts() {
        if (this.parts.size() != this.partPositions.length) {
            this.parts.clear();
            for (BlockPos pos : this.partPositions) {
                IMultiPart.ofPart((BlockGetter)this.getLevel(), pos).ifPresent(this.parts::add);
            }
        }
        return this.parts;
    }

    public void setFormed(boolean formed) {
        this.isFormed = formed;
        this.setMachineState(this.isFormed ? "formed" : ((MachineState)this.getDefinition().stateMachine().getRootState()).name());
    }

    @Override
    public boolean runRecipeLogic() {
        return super.runRecipeLogic() && this.isFormed() && this.isFormedValid();
    }

    @Override
    public void initCapabilitiesProxy() {
        super.initCapabilitiesProxy();
        if (this.isFormed()) {
            Table<IO, RecipeCapability<?>, List<IRecipeHandler<?>>> capabilitiesProxy = this.getRecipeCapabilitiesProxy();
            Map ioMap = (Map)this.getMultiblockState().getMatchContext().getOrCreate("ioMap", Long2ObjectMaps::emptyMap);
            Map slots = (Map)this.getMultiblockState().getMatchContext().getOrDefault("slots", Long2ObjectMaps.emptyMap());
            for (IMultiPart part : this.getParts()) {
                IO io = ioMap.getOrDefault(part.getPos().m_121878_(), IO.BOTH);
                Set slotNames = slots.getOrDefault(part.getPos().m_121878_(), Collections.emptySet());
                if (io == IO.NONE) continue;
                for (IRecipeHandlerTrait<?> handler : part.getRecipeHandlers()) {
                    IO handlerIO;
                    if (io != IO.BOTH && handler.getHandlerIO() != IO.BOTH && io != handler.getHandlerIO()) continue;
                    IO iO = handlerIO = io == IO.BOTH ? handler.getHandlerIO() : io;
                    if (!capabilitiesProxy.contains((Object)handlerIO, handler.getRecipeCapability())) {
                        capabilitiesProxy.put((Object)handlerIO, handler.getRecipeCapability(), new ArrayList());
                    }
                    if (slotNames.isEmpty()) {
                        ((List)capabilitiesProxy.get((Object)handlerIO, handler.getRecipeCapability())).add(handler);
                        continue;
                    }
                    HashSet<String> mergedSlots = new HashSet<String>(slotNames);
                    mergedSlots.addAll(handler.getSlotNames());
                    ((List)capabilitiesProxy.get((Object)handlerIO, handler.getRecipeCapability())).add(new RecipeHandlerSlotsProxy(handler, mergedSlots));
                }
            }
        }
    }

    @Override
    public void onStructureFormed() {
        this.setFormed(true);
        this.isFormedValid = true;
        this.parts.clear();
        this.renderingDisabledPositions.clear();
        LongSet disabled = (LongSet)this.getMultiblockState().getMatchContext().getOrDefault("renderMask", LongSets.EMPTY_SET);
        for (Long pos : disabled) {
            BlockPos blockPos = BlockPos.m_122022_((long)pos);
            this.renderingDisabledPositions.add(blockPos);
            if (!IMultiPart.ofPart((BlockGetter)this.getLevel(), blockPos).isEmpty()) continue;
            BlockEntity blockEntity = this.getLevel().m_7702_(blockPos);
            if (blockEntity instanceof ProxyPartBlockEntity) {
                ProxyPartBlockEntity proxyPartBlockEntity = (ProxyPartBlockEntity)blockEntity;
                proxyPartBlockEntity.setControllerData(this.getPos());
                continue;
            }
            ProxyPartBlock.replaceOriginalBlock(this.getPos(), this.getLevel(), blockPos);
        }
        Set set = this.getMultiblockState().getMatchContext().getOrCreate("parts", Collections::emptySet);
        for (IMultiPart part : set) {
            if (!this.shouldAddPartToController(part)) continue;
            this.parts.add(part);
        }
        this.getDefinition().sortParts(this.parts);
        for (IMultiPart part : this.parts) {
            part.addedToController(this);
        }
        this.updatePartPositions();
        this.initCapabilitiesProxy();
        MinecraftForge.EVENT_BUS.post((Event)new MachineStructureFormedEvent(this).postCustomEvent());
        this.notifyRecipeStatusChanged(this.getRecipeLogic().getStatus(), this.getRecipeLogic().getStatus());
    }

    @Override
    public void onStructureInvalid(boolean isControllerRemoved) {
        this.setFormed(false);
        this.isFormedValid = false;
        this.getRecipeLogic().resetRecipeLogic();
        for (IMultiPart part : this.parts) {
            part.removedFromController(this);
        }
        this.parts.clear();
        this.updatePartPositions();
        this.initCapabilitiesProxy();
        for (BlockPos pos : this.renderingDisabledPositions) {
            BlockEntity blockEntity = this.getLevel().m_7702_(pos);
            if (!(blockEntity instanceof ProxyPartBlockEntity)) continue;
            ProxyPartBlockEntity proxyPartBlockEntity = (ProxyPartBlockEntity)blockEntity;
            proxyPartBlockEntity.restoreOriginalBlock();
        }
        this.renderingDisabledPositions.clear();
        MinecraftForge.EVENT_BUS.post((Event)new MachineStructureInvalidEvent(this).postCustomEvent());
        if (!isControllerRemoved && this.originalBlock != null) {
            this.getLevel().m_46597_(this.getPos(), this.originalBlock);
        }
    }

    @Override
    public void onPartUnload() {
        this.parts.removeIf(IMachine::isInValid);
        this.getMultiblockState().setError(MultiblockState.UNLOAD_ERROR);
        Level level = this.getLevel();
        if (level instanceof ServerLevel) {
            ServerLevel serverLevel = (ServerLevel)level;
            MultiblockWorldSavedData.getOrCreate(serverLevel).addAsyncLogic(this);
        }
        this.updatePartPositions();
    }

    @Override
    public void onRotated(Direction oldFacing, Direction newFacing) {
        Level level;
        if (oldFacing != newFacing && (level = this.getLevel()) instanceof ServerLevel) {
            ServerLevel serverLevel = (ServerLevel)level;
            this.onStructureInvalid();
            MultiblockWorldSavedData mwsd = MultiblockWorldSavedData.getOrCreate(serverLevel);
            mwsd.removeMapping(this.getMultiblockState());
            mwsd.addAsyncLogic(this);
        }
    }

    @Override
    public boolean shouldOpenUI(InteractionHand hand, BlockHitResult hit) {
        return super.shouldOpenUI(hand, hit) && (!this.getDefinition().multiblockSettings().showUIOnlyFormed() || this.isFormed());
    }

    @Override
    public InteractionResult onUse(BlockState state, Level world, BlockPos pos, Player player, InteractionHand hand, BlockHitResult hit) {
        if (!this.isFormed() && player.m_6144_() && player.m_21120_(hand).m_41619_()) {
            if (world.m_5776_()) {
                MultiblockInWorldPreviewRenderer.showPreview(pos, this, ConfigHolder.multiblockPreviewDuration * 20);
            }
            return InteractionResult.SUCCESS;
        }
        if (!this.isFormed() && this.getDefinition().multiblockSettings().catalyst().isEnable()) {
            ItemStack held;
            ToggleCatalyst catalyst = this.getDefinition().multiblockSettings().catalyst();
            if (catalyst.test(held = player.m_21120_(hand))) {
                if (world instanceof ServerLevel) {
                    ServerLevel serverLevel = (ServerLevel)world;
                    if (this.checkPatternWithLock()) {
                        boolean success = this.onCatalystUsed(player, hand, held);
                        if (success) {
                            this.onStructureFormed();
                            MultiblockWorldSavedData mwsd = MultiblockWorldSavedData.getOrCreate(serverLevel);
                            mwsd.addMapping(this.getMultiblockState());
                            mwsd.removeAsyncLogic(this);
                            return InteractionResult.CONSUME;
                        }
                        return InteractionResult.FAIL;
                    }
                }
                return InteractionResult.SUCCESS;
            }
            return InteractionResult.FAIL;
        }
        return super.onUse(state, world, pos, player, hand, hit);
    }

    public boolean onCatalystUsed(Player player, InteractionHand hand, ItemStack held) {
        ToggleCatalyst catalyst = this.getDefinition().multiblockSettings().catalyst();
        MachineUseCatalystEvent event = new MachineUseCatalystEvent(this, held, player, hand);
        MinecraftForge.EVENT_BUS.post((Event)event.postCustomEvent());
        if (event.isCanceled()) {
            return false;
        }
        if (player.m_7500_()) {
            return true;
        }
        return switch (catalyst.getCatalystType()) {
            default -> throw new IncompatibleClassChangeError();
            case ToggleCatalyst.CatalystType.CONSUME_ITEM -> {
                if (held.m_41613_() >= catalyst.getConsumeItemAmount()) {
                    held.m_41774_(catalyst.getConsumeItemAmount());
                    yield true;
                }
                yield false;
            }
            case ToggleCatalyst.CatalystType.CONSUME_DURABILITY -> {
                if (catalyst.getConsumeDurabilityValue() <= held.m_41776_() - held.m_41773_()) {
                    held.m_41622_(catalyst.getConsumeDurabilityValue(), (LivingEntity)player, p -> p.m_21190_(hand));
                    yield true;
                }
                yield false;
            }
        };
    }

    @Override
    public ItemStack getDropItem() {
        if (this.originalBlock != null) {
            return this.originalBlock.m_60734_().m_5456_().m_7968_();
        }
        return super.getDropItem();
    }

    public BlockPos[] getPartPositions() {
        return this.partPositions;
    }

    @Override
    public boolean isFormed() {
        return this.isFormed;
    }

    public Set<BlockPos> getRenderingDisabledPositions() {
        return this.renderingDisabledPositions;
    }

    @Override
    public Lock getPatternLock() {
        return this.patternLock;
    }

    @Nullable
    public BlockState getOriginalBlock() {
        return this.originalBlock;
    }

    public void setOriginalBlock(@Nullable BlockState originalBlock) {
        this.originalBlock = originalBlock;
    }

    @Override
    public boolean isFormedValid() {
        return this.isFormedValid;
    }
}

