/*
 * Decompiled with CFR 0.152.
 */
package com.lowdragmc.mbd2.common.machine.definition.config.event;

import com.lowdragmc.lowdraglib.LDLib;
import com.lowdragmc.lowdraglib.gui.editor.ILDLRegister;
import com.lowdragmc.lowdraglib.gui.graphprocessor.data.parameter.ExposedParameter;
import com.lowdragmc.mbd2.MBD2;
import com.lowdragmc.mbd2.common.graphprocessor.GraphParameterGet;
import com.lowdragmc.mbd2.common.graphprocessor.GraphParameterSet;
import com.lowdragmc.mbd2.common.machine.MBDMachine;
import com.lowdragmc.mbd2.integration.kubejs.events.MBDClientEvents;
import com.lowdragmc.mbd2.integration.kubejs.events.MBDServerEvents;
import java.lang.annotation.Annotation;
import java.lang.reflect.Field;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import net.minecraftforge.eventbus.api.Cancelable;
import net.minecraftforge.eventbus.api.Event;

public class MachineEvent
extends Event
implements ILDLRegister {
    @GraphParameterGet
    public final MBDMachine machine;

    public MachineEvent(MBDMachine machine) {
        this.machine = machine;
    }

    public MachineEvent postCustomEvent() {
        this.machine.getDefinition().machineEvents().postGraphEvent(this);
        this.postKubeJSEvent();
        return this;
    }

    public MachineEvent postKubeJSEvent() {
        if (MBD2.isKubeJSLoaded()) {
            try {
                if (LDLib.isClient()) {
                    if (MBDServerEvents.postMachineEvent(this).interruptFalse() && this.isCancelable()) {
                        this.setCanceled(true);
                    } else if (MBDClientEvents.postMachineEvent(this).interruptFalse() && this.isCancelable()) {
                        this.setCanceled(true);
                    }
                } else if (MBDServerEvents.postMachineEvent(this).interruptFalse() && this.isCancelable()) {
                    this.setCanceled(true);
                }
            }
            catch (Exception e) {
                MBD2.LOGGER.error("Failed to post KubeJS event {}", (Object)this, (Object)e);
            }
        }
        return this;
    }

    public static List<ExposedParameter<?>> getExposedParameters(Class<? extends MachineEvent> clazz) {
        ArrayList parameters = new ArrayList();
        for (Field field : clazz.getFields()) {
            List<String> tips;
            Class type;
            String displayName;
            String identity;
            Annotation annotation;
            if (field.isAnnotationPresent(GraphParameterGet.class)) {
                annotation = field.getAnnotation(GraphParameterGet.class);
                identity = field.getName();
                displayName = field.getName();
                type = field.getType();
                tips = null;
                if (!annotation.identity().isEmpty()) {
                    identity = annotation.identity();
                }
                if (!annotation.displayName().isEmpty()) {
                    displayName = annotation.displayName();
                }
                if (annotation.type() != ExposedParameter.class) {
                    type = annotation.type();
                }
                if (annotation.tips().length > 0) {
                    tips = Arrays.asList(annotation.tips());
                }
                parameters.add(new ExposedParameter(identity, type).setTips(tips).setAccessor(ExposedParameter.ParameterAccessor.Get).setDisplayName(displayName));
            }
            if (!field.isAnnotationPresent(GraphParameterSet.class)) continue;
            annotation = field.getAnnotation(GraphParameterSet.class);
            identity = field.getName();
            displayName = field.getName();
            type = field.getType();
            tips = null;
            if (!annotation.identity().isEmpty()) {
                identity = annotation.identity();
            }
            if (!annotation.displayName().isEmpty()) {
                displayName = annotation.displayName();
            }
            if (annotation.type() != ExposedParameter.class) {
                type = annotation.type();
            }
            if (annotation.tips().length > 0) {
                tips = Arrays.asList(annotation.tips());
            }
            parameters.add(new ExposedParameter(identity, type).setTips(tips).setAccessor(ExposedParameter.ParameterAccessor.Set).setDisplayName(displayName));
        }
        if (clazz.isAnnotationPresent(Cancelable.class)) {
            parameters.add(new ExposedParameter("cancel", Boolean.class).setAccessor(ExposedParameter.ParameterAccessor.Set).setDisplayName("cancel"));
        }
        return parameters;
    }

    public void bindParameters(Map<String, ExposedParameter> exposedParameters) {
        Optional.ofNullable(exposedParameters.get("machine")).ifPresent(p -> p.setValue((Object)this.machine));
    }

    public void gatherParameters(Map<String, ExposedParameter> exposedParameters) {
        if (this.isCancelable()) {
            Optional.ofNullable(exposedParameters.get("cancel")).ifPresent(p -> {
                Object patt5856$temp = p.getValue();
                if (patt5856$temp instanceof Boolean) {
                    Boolean cancel = (Boolean)patt5856$temp;
                    this.setCanceled(cancel);
                }
            });
        }
    }

    public String toString() {
        return "MachineEvent{machine=" + String.valueOf(this.machine) + ", eventName='" + ((Object)((Object)this)).getClass().getSimpleName() + "', isCanceled=" + this.isCanceled() + "}";
    }

    public MBDMachine getMachine() {
        return this.machine;
    }
}

