/*
 * Decompiled with CFR 0.152.
 */
package com.lowdragmc.mbd2.common.recipe;

import com.google.gson.JsonObject;
import com.lowdragmc.lowdraglib.gui.editor.annotation.Configurable;
import com.lowdragmc.lowdraglib.gui.editor.annotation.NumberRange;
import com.lowdragmc.lowdraglib.gui.texture.IGuiTexture;
import com.lowdragmc.lowdraglib.gui.texture.TextTexture;
import com.lowdragmc.mbd2.api.recipe.MBDRecipe;
import com.lowdragmc.mbd2.api.recipe.RecipeCondition;
import com.lowdragmc.mbd2.api.recipe.RecipeLogic;
import javax.annotation.Nonnull;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.network.FriendlyByteBuf;
import net.minecraft.network.chat.Component;
import net.minecraft.util.GsonHelper;

public class MachineLevelCondition
extends RecipeCondition {
    public static final MachineLevelCondition INSTANCE = new MachineLevelCondition();
    @Configurable(name="config.recipe.condition.machine_level.level", tips={"config.recipe.condition.machine_level.level.tips"})
    @NumberRange(range={0.0, 2.147483647E9})
    private int level;

    public MachineLevelCondition(int level) {
        this.level = level;
    }

    @Override
    public String getType() {
        return "machine_level";
    }

    @Override
    public Component getTooltips() {
        return Component.m_237110_((String)"recipe.condition.machine_level.tooltip", (Object[])new Object[]{this.level});
    }

    @Override
    public IGuiTexture getIcon() {
        return new TextTexture("LV");
    }

    @Override
    public boolean test(@Nonnull MBDRecipe recipe, @Nonnull RecipeLogic recipeLogic) {
        return recipeLogic.machine.getMachineLevel() >= this.level;
    }

    @Override
    @Nonnull
    public JsonObject serialize() {
        JsonObject config = super.serialize();
        config.addProperty("level", (Number)this.level);
        return config;
    }

    @Override
    public RecipeCondition deserialize(@Nonnull JsonObject config) {
        super.deserialize(config);
        this.level = GsonHelper.m_13927_((JsonObject)config, (String)"level");
        return this;
    }

    @Override
    public RecipeCondition fromNetwork(FriendlyByteBuf buf) {
        super.fromNetwork(buf);
        this.level = buf.m_130242_();
        return this;
    }

    @Override
    public void toNetwork(FriendlyByteBuf buf) {
        super.toNetwork(buf);
        buf.m_130130_(this.level);
    }

    @Override
    public CompoundTag toNBT() {
        CompoundTag tag = super.toNBT();
        tag.m_128405_("level", this.level);
        return tag;
    }

    @Override
    public RecipeCondition fromNBT(CompoundTag tag) {
        super.fromNBT(tag);
        this.level = tag.m_128451_("level");
        return this;
    }

    public int getLevel() {
        return this.level;
    }

    public void setLevel(int level) {
        this.level = level;
    }

    public MachineLevelCondition() {
    }
}

