/*
 * Decompiled with CFR 0.152.
 */
package com.lowdragmc.mbd2.common.trait;

import com.lowdragmc.lowdraglib.syncdata.IEnhancedManaged;
import com.lowdragmc.lowdraglib.syncdata.IManaged;
import com.lowdragmc.lowdraglib.syncdata.ISubscription;
import com.lowdragmc.lowdraglib.syncdata.field.FieldManagedStorage;
import com.lowdragmc.mbd2.api.capability.recipe.IO;
import com.lowdragmc.mbd2.common.machine.MBDMachine;
import com.lowdragmc.mbd2.common.trait.ITrait;
import com.lowdragmc.mbd2.common.trait.RecipeCapabilityTraitDefinition;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.Set;
import java.util.stream.Collectors;

public abstract class RecipeCapabilityTrait
implements ITrait,
IEnhancedManaged {
    private final FieldManagedStorage syncStorage = new FieldManagedStorage((IManaged)this);
    private final MBDMachine machine;
    private final RecipeCapabilityTraitDefinition definition;
    private final List<Runnable> listeners = new ArrayList<Runnable>();

    public RecipeCapabilityTrait(MBDMachine machine, RecipeCapabilityTraitDefinition definition) {
        this.machine = machine;
        this.definition = definition;
    }

    public void scheduleRenderUpdate() {
        this.machine.scheduleRenderUpdate();
    }

    public void onChanged() {
        this.machine.onChanged();
    }

    public void notifyListeners() {
        this.listeners.forEach(Runnable::run);
    }

    public ISubscription addChangedListener(Runnable listener) {
        this.listeners.add(listener);
        return () -> this.listeners.remove(listener);
    }

    public IO getHandlerIO() {
        return this.getDefinition().getRecipeHandlerIO();
    }

    public boolean isDistinct() {
        return this.getDefinition().isDistinct();
    }

    public Set<String> getSlotNames() {
        return Arrays.stream(this.getDefinition().getSlotNames()).collect(Collectors.toSet());
    }

    public FieldManagedStorage getSyncStorage() {
        return this.syncStorage;
    }

    @Override
    public MBDMachine getMachine() {
        return this.machine;
    }

    @Override
    public RecipeCapabilityTraitDefinition getDefinition() {
        return this.definition;
    }
}

