/*
 * Decompiled with CFR 0.152.
 */
package com.lowdragmc.mbd2.common.trait;

import com.lowdragmc.lowdraglib.client.renderer.IRenderer;
import com.lowdragmc.lowdraglib.gui.editor.annotation.Configurable;
import com.lowdragmc.lowdraglib.gui.editor.annotation.NumberRange;
import com.lowdragmc.lowdraglib.gui.editor.configurator.IConfigurable;
import com.lowdragmc.lowdraglib.gui.editor.runtime.AnnotationDetector;
import com.lowdragmc.lowdraglib.gui.texture.IGuiTexture;
import com.lowdragmc.lowdraglib.syncdata.IAutoPersistedSerializable;
import com.lowdragmc.mbd2.api.machine.IMachine;
import com.lowdragmc.mbd2.api.registry.MBDRegistries;
import com.lowdragmc.mbd2.common.gui.editor.machine.MachineTraitPanel;
import com.lowdragmc.mbd2.common.machine.MBDMachine;
import com.lowdragmc.mbd2.common.trait.ITrait;
import javax.annotation.Nullable;
import net.minecraft.nbt.CompoundTag;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;

public abstract class TraitDefinition
implements IConfigurable,
IAutoPersistedSerializable {
    @Configurable(name="config.definition.trait.name")
    private String name = this.name();
    @Configurable(name="config.definition.trait.priority", tips={"config.definition.trait.priority.tooltip"})
    @NumberRange(range={-2.147483648E9, 2.147483647E9})
    private int priority;

    public static CompoundTag serializeDefinition(TraitDefinition definition) {
        return definition.serializeNBT();
    }

    @Nullable
    public static TraitDefinition deserializeDefinition(CompoundTag tag) {
        String type = tag.m_128461_("_type");
        AnnotationDetector.Wrapper wrapper = (AnnotationDetector.Wrapper)MBDRegistries.TRAIT_DEFINITION_TYPES.get(type);
        if (wrapper != null) {
            TraitDefinition definition = (TraitDefinition)wrapper.creator().get();
            definition.deserializeNBT(tag);
            return definition;
        }
        return null;
    }

    public abstract ITrait createTrait(MBDMachine var1);

    public abstract IGuiTexture getIcon();

    public boolean allowMultiple() {
        return true;
    }

    public IRenderer getBESRenderer(IMachine machine) {
        return IRenderer.EMPTY;
    }

    public String getTranslateKey() {
        return "config.definition.%s.%s.name".formatted(this.group(), this.name());
    }

    @OnlyIn(value=Dist.CLIENT)
    public void renderAfterWorldInTraitPanel(MachineTraitPanel panel) {
    }

    public String getName() {
        return this.name;
    }

    public int getPriority() {
        return this.priority;
    }

    public void setName(String name) {
        this.name = name;
    }

    public void setPriority(int priority) {
        this.priority = priority;
    }
}

