/*
 * Decompiled with CFR 0.152.
 */
package com.lowdragmc.mbd2.integration.botania.trait;

import com.lowdragmc.lowdraglib.syncdata.annotation.DescSynced;
import com.lowdragmc.lowdraglib.syncdata.annotation.Persisted;
import com.lowdragmc.lowdraglib.syncdata.field.ManagedFieldHolder;
import com.lowdragmc.mbd2.api.capability.recipe.IO;
import com.lowdragmc.mbd2.api.capability.recipe.IRecipeHandlerTrait;
import com.lowdragmc.mbd2.api.recipe.MBDRecipe;
import com.lowdragmc.mbd2.common.machine.MBDMachine;
import com.lowdragmc.mbd2.common.trait.AutoIO;
import com.lowdragmc.mbd2.common.trait.IAutoIOTrait;
import com.lowdragmc.mbd2.common.trait.ICapabilityProviderTrait;
import com.lowdragmc.mbd2.common.trait.RecipeHandlerTrait;
import com.lowdragmc.mbd2.common.trait.SimpleCapabilityTrait;
import com.lowdragmc.mbd2.integration.botania.BotaniaManaRecipeCapability;
import com.lowdragmc.mbd2.integration.botania.trait.BotaniaManaCapabilityTraitDefinition;
import com.lowdragmc.mbd2.integration.botania.trait.CopiableManaPool;
import com.lowdragmc.mbd2.integration.botania.trait.ManaPoolList;
import com.lowdragmc.mbd2.integration.botania.trait.ManaPoolWrapper;
import java.util.List;
import java.util.Optional;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraftforge.common.capabilities.Capability;
import org.jetbrains.annotations.Nullable;
import vazkii.botania.api.BotaniaForgeCapabilities;
import vazkii.botania.api.mana.ManaPool;
import vazkii.botania.api.mana.ManaReceiver;
import vazkii.botania.api.mana.spark.SparkAttachable;

public class BotaniaManaCapabilityTrait
extends SimpleCapabilityTrait
implements IAutoIOTrait {
    public static final ManagedFieldHolder MANAGED_FIELD_HOLDER = new ManagedFieldHolder(BotaniaManaCapabilityTrait.class);
    @Persisted
    @DescSynced
    public final CopiableManaPool storage;
    private final ManaRecipeHandler recipeHandler = new ManaRecipeHandler();
    private final ManaReceiverCap manaReceiverCap = new ManaReceiverCap();
    private final SparkAttachableCap sparkAttachableCap = new SparkAttachableCap();

    public ManagedFieldHolder getFieldHolder() {
        return MANAGED_FIELD_HOLDER;
    }

    public BotaniaManaCapabilityTrait(MBDMachine machine, BotaniaManaCapabilityTraitDefinition definition) {
        super(machine, definition);
        this.storage = this.createStorages(machine);
        this.storage.setOnContentsChanged(this::notifyListeners);
    }

    @Override
    public BotaniaManaCapabilityTraitDefinition getDefinition() {
        return (BotaniaManaCapabilityTraitDefinition)super.getDefinition();
    }

    @Override
    public void onLoadingTraitInPreview() {
        this.storage.receiveMana(this.getDefinition().getCapacity() / 2);
    }

    protected CopiableManaPool createStorages(MBDMachine machine) {
        return new CopiableManaPool(machine, this.getDefinition().getCapacity(), this.getDefinition().isCanAttachSpark());
    }

    @Override
    public List<IRecipeHandlerTrait<?>> getRecipeHandlerTraits() {
        return List.of(this.recipeHandler);
    }

    @Override
    public List<ICapabilityProviderTrait<?>> getCapabilityProviderTraits() {
        return List.of(this.manaReceiverCap, this.sparkAttachableCap);
    }

    @Override
    @Nullable
    public AutoIO getAutoIO() {
        return this.getDefinition().getAutoIO().isEnable() ? this.getDefinition().getAutoIO() : null;
    }

    @Override
    public void handleAutoIO(BlockPos port, Direction side, IO io) {
        if (io.support(IO.IN)) {
            Optional.ofNullable(this.getMachine().getLevel().m_7702_(port.m_121945_(side))).flatMap(be -> be.getCapability(BotaniaForgeCapabilities.MANA_RECEIVER, side.m_122424_()).resolve()).ifPresent(source -> {
                int available = source.getCurrentMana();
                int cost = Math.min(available, this.storage.getMaxMana() - this.storage.getCurrentMana());
                this.storage.receiveMana(cost);
                source.receiveMana(-cost);
            });
        }
        if (io.support(IO.OUT)) {
            Optional.ofNullable(this.getMachine().getLevel().m_7702_(port.m_121945_(side))).flatMap(be -> be.getCapability(BotaniaForgeCapabilities.MANA_RECEIVER, side.m_122424_()).resolve()).ifPresent(target -> {
                int n;
                int available = this.storage.getCurrentMana();
                if (target instanceof ManaPool) {
                    ManaPool pool = (ManaPool)target;
                    n = Math.min(available, pool.getMaxMana() - pool.getCurrentMana());
                } else {
                    n = available;
                }
                int cost = n;
                this.storage.receiveMana(-cost);
                target.receiveMana(cost);
            });
        }
    }

    public class ManaRecipeHandler
    extends RecipeHandlerTrait<Integer> {
        protected ManaRecipeHandler() {
            super(BotaniaManaCapabilityTrait.this, BotaniaManaRecipeCapability.CAP);
        }

        @Override
        public List<Integer> handleRecipeInner(IO io, MBDRecipe recipe, List<Integer> left, @Nullable String slotName, boolean simulate) {
            CopiableManaPool capability;
            if (!this.compatibleWith(io)) {
                return left;
            }
            int required = left.stream().reduce(0, Integer::sum);
            CopiableManaPool copiableManaPool = capability = simulate ? BotaniaManaCapabilityTrait.this.storage.copy() : BotaniaManaCapabilityTrait.this.storage;
            if (io == IO.IN) {
                int cost = Math.min(required, capability.getCurrentMana());
                capability.receiveMana(-cost);
                required -= cost;
            } else {
                if (capability.isFull() || !capability.canReceiveManaFromBursts()) {
                    return left;
                }
                if (required > capability.getMaxMana() - capability.getCurrentMana()) {
                    int received = capability.getMaxMana() - capability.getCurrentMana();
                    capability.receiveMana(received);
                    required -= received;
                } else {
                    capability.receiveMana(required);
                    return null;
                }
            }
            return required > 0 ? List.of(Integer.valueOf(required)) : null;
        }
    }

    public class ManaReceiverCap
    implements ICapabilityProviderTrait<ManaPool> {
        @Override
        public IO getCapabilityIO(@Nullable Direction side) {
            return BotaniaManaCapabilityTrait.this.getCapabilityIO(side);
        }

        @Override
        public Capability<ManaReceiver> getCapability() {
            return BotaniaForgeCapabilities.MANA_RECEIVER;
        }

        @Override
        public ManaPool getCapContent(IO capbilityIO) {
            return new ManaPoolWrapper(BotaniaManaCapabilityTrait.this.storage, capbilityIO);
        }

        @Override
        public ManaPool mergeContents(List<ManaPool> contents) {
            return new ManaPoolList(contents.toArray(new ManaPool[0]));
        }
    }

    public class SparkAttachableCap
    implements ICapabilityProviderTrait<SparkAttachable> {
        @Override
        public IO getCapabilityIO(@Nullable Direction side) {
            return BotaniaManaCapabilityTrait.this.getCapabilityIO(side);
        }

        @Override
        public Capability<SparkAttachable> getCapability() {
            return BotaniaForgeCapabilities.SPARK_ATTACHABLE;
        }

        @Override
        public SparkAttachable getCapContent(IO capbilityIO) {
            return BotaniaManaCapabilityTrait.this.storage;
        }

        @Override
        public SparkAttachable mergeContents(List<SparkAttachable> contents) {
            return contents.get(0);
        }
    }
}

