/*
 * Decompiled with CFR 0.152.
 */
package com.lowdragmc.mbd2.integration.botania.trait;

import com.google.common.base.Predicates;
import com.lowdragmc.lowdraglib.syncdata.IContentChangeAware;
import com.lowdragmc.lowdraglib.syncdata.ITagSerializable;
import com.lowdragmc.mbd2.common.machine.MBDMachine;
import java.util.List;
import java.util.Optional;
import java.util.function.Predicate;
import net.minecraft.core.BlockPos;
import net.minecraft.nbt.IntTag;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.item.DyeColor;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.Level;
import net.minecraft.world.phys.AABB;
import vazkii.botania.api.mana.ManaPool;
import vazkii.botania.api.mana.spark.ManaSpark;
import vazkii.botania.api.mana.spark.SparkAttachable;
import vazkii.botania.common.block.BotaniaBlocks;

public class CopiableManaPool
implements ManaPool,
ITagSerializable<IntTag>,
IContentChangeAware,
SparkAttachable {
    public Runnable onContentsChanged = () -> {};
    private final MBDMachine machine;
    protected final int maxMana;
    protected int mana;
    protected boolean canAttachSpark;

    public CopiableManaPool(MBDMachine machine, int capacity, boolean canAttachSpark) {
        this(machine, capacity, canAttachSpark, 0);
    }

    public CopiableManaPool(MBDMachine machine, int capacity, boolean canAttachSpark, int mana) {
        this.machine = machine;
        this.maxMana = capacity;
        this.mana = mana;
        this.canAttachSpark = canAttachSpark;
    }

    public CopiableManaPool copy() {
        return new CopiableManaPool(this.machine, this.maxMana, this.canAttachSpark, this.mana);
    }

    public Level getManaReceiverLevel() {
        return this.machine.getLevel();
    }

    public BlockPos getManaReceiverPos() {
        return this.machine.getPos();
    }

    public int getCurrentMana() {
        return this.mana;
    }

    public boolean isFull() {
        return this.mana >= this.maxMana;
    }

    public void receiveMana(int mana) {
        int old = this.mana;
        this.mana = Math.max(0, Math.min(this.mana + mana, this.maxMana));
        if (old != this.mana) {
            this.onContentsChanged.run();
        }
    }

    public boolean canReceiveManaFromBursts() {
        return !this.isFull();
    }

    public IntTag serializeNBT() {
        return IntTag.m_128679_((int)this.mana);
    }

    public void deserializeNBT(IntTag nbt) {
        this.mana = nbt.m_7047_();
    }

    public boolean isOutputtingPower() {
        return false;
    }

    public Optional<DyeColor> getColor() {
        return Optional.empty();
    }

    public void setColor(Optional<DyeColor> color) {
    }

    public boolean canAttachSpark(ItemStack stack) {
        return this.canAttachSpark;
    }

    public int getAvailableSpaceForMana() {
        int space = Math.max(0, this.getMaxMana() - this.getCurrentMana());
        if (space > 0) {
            return space;
        }
        if (this.machine.getLevel().m_8055_(this.machine.getPos().m_7495_()).m_60713_(BotaniaBlocks.manaVoid)) {
            return this.getMaxMana();
        }
        return 0;
    }

    public ManaSpark getAttachedSpark() {
        List sparks = this.machine.getLevel().m_6443_(Entity.class, new AABB(this.machine.getPos().m_7494_(), this.machine.getPos().m_7494_().m_7918_(1, 1, 1)), (Predicate)Predicates.instanceOf(ManaSpark.class));
        if (sparks.size() == 1) {
            Entity e = (Entity)sparks.get(0);
            return (ManaSpark)e;
        }
        return null;
    }

    public boolean areIncomingTranfersDone() {
        return false;
    }

    public Runnable getOnContentsChanged() {
        return this.onContentsChanged;
    }

    public void setOnContentsChanged(Runnable onContentsChanged) {
        this.onContentsChanged = onContentsChanged;
    }

    public int getMaxMana() {
        return this.maxMana;
    }
}

