/*
 * Decompiled with CFR 0.152.
 */
package com.lowdragmc.mbd2.integration.create;

import com.lowdragmc.lowdraglib.gui.editor.annotation.LDLRegister;
import com.lowdragmc.lowdraglib.gui.editor.configurator.IConfigurableWidget;
import com.lowdragmc.lowdraglib.gui.widget.Widget;
import com.lowdragmc.lowdraglib.utils.LocalizationUtils;
import com.mojang.blaze3d.systems.RenderSystem;
import com.mojang.blaze3d.vertex.PoseStack;
import com.simibubi.create.AllBlocks;
import java.util.function.Supplier;
import net.createmod.catnip.animation.AnimationTickHolder;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.GuiGraphics;
import net.minecraft.client.renderer.MultiBufferSource;
import net.minecraft.client.renderer.RenderType;
import net.minecraft.client.renderer.entity.ItemRenderer;
import net.minecraft.client.renderer.texture.OverlayTexture;
import net.minecraft.client.resources.model.BakedModel;
import net.minecraft.network.FriendlyByteBuf;
import net.minecraft.world.item.ItemDisplayContext;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.LevelAccessor;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;
import net.minecraftforge.client.ForgeHooksClient;
import org.jetbrains.annotations.NotNull;
import org.joml.Matrix4f;
import org.joml.Quaternionf;

@LDLRegister(name="create_stress", group="widget.container", modID="create")
public class CreateStressWidget
extends Widget
implements IConfigurableWidget {
    public float stress;
    public Supplier<Float> stressSupplier;

    public CreateStressWidget() {
        super(0, 0, 100, 16);
    }

    public void writeInitialData(FriendlyByteBuf buffer) {
        super.writeInitialData(buffer);
        if (this.stressSupplier != null) {
            this.stress = this.stressSupplier.get().floatValue();
        }
        buffer.writeFloat(this.stress);
    }

    public void readInitialData(FriendlyByteBuf buffer) {
        super.readInitialData(buffer);
        this.stress = buffer.readFloat();
    }

    public void detectAndSendChanges() {
        Float newStress;
        super.detectAndSendChanges();
        if (this.stressSupplier != null && (newStress = this.stressSupplier.get()).floatValue() != this.stress) {
            this.stress = newStress.floatValue();
            this.writeUpdateInfo(-1, buf -> buf.writeFloat(this.stress));
        }
    }

    public void readUpdateInfo(int id, FriendlyByteBuf buffer) {
        if (id == -1) {
            this.stress = buffer.readFloat();
        } else {
            super.readUpdateInfo(id, buffer);
        }
    }

    public void updateScreen() {
        super.updateScreen();
        if (this.isClientSideWidget && this.stressSupplier != null) {
            this.stress = this.stressSupplier.get().floatValue();
        }
    }

    @OnlyIn(value=Dist.CLIENT)
    public void drawInBackground(@NotNull GuiGraphics graphics, int mouseX, int mouseY, float partialTicks) {
        super.drawInBackground(graphics, mouseX, mouseY, partialTicks);
        int x = this.getPositionX();
        int y = this.getPositionY();
        this.drawWheel(graphics, x, y, 16, 16);
        graphics.m_280056_(Minecraft.m_91087_().f_91062_, LocalizationUtils.format((String)"recipe.capability.create_stress.stress.unit", (Object[])new Object[]{Float.valueOf(this.stress)}), x + 16, y + 4, 0xFFFFFF, true);
    }

    @OnlyIn(value=Dist.CLIENT)
    public void drawWheel(GuiGraphics graphics, float x, float y, int width, int height) {
        float itemW = (float)width * 16.0f / 16.0f;
        float itemH = (float)height * 16.0f / 16.0f;
        float itemX = x + ((float)width - itemW) / 2.0f;
        float itemY = y + ((float)height - itemH) / 2.0f;
        PoseStack pose = graphics.m_280168_();
        pose.m_85836_();
        pose.m_85841_(itemW / 16.0f, itemH / 16.0f, 1.0f);
        pose.m_252880_(itemX * 16.0f / itemW, itemY * 16.0f / itemH, -200.0f);
        RenderSystem.setShaderColor((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
        RenderSystem.enableDepthTest();
        RenderSystem.depthMask((boolean)true);
        Minecraft mc = Minecraft.m_91087_();
        pose.m_85836_();
        pose.m_252880_(0.0f, 0.0f, 232.0f);
        pose.m_85836_();
        pose.m_252880_(8.0f, 8.0f, 150.0f);
        try {
            pose.m_252931_(new Matrix4f().scaling(1.0f, -1.0f, 1.0f));
            pose.m_85841_(16.0f, 16.0f, 16.0f);
            MultiBufferSource.BufferSource buffers = graphics.m_280091_();
            ItemRenderer itemRenderer = mc.m_91291_();
            ItemStack stack = AllBlocks.COGWHEEL.asStack();
            BakedModel model = itemRenderer.m_174264_(stack, null, null, 0);
            float angle = AnimationTickHolder.getRenderTime((LevelAccessor)mc.f_91073_) * this.stress / 4.0f * 3.0f / 10.0f % 360.0f;
            angle = angle / 180.0f * (float)Math.PI;
            ForgeHooksClient.handleCameraTransforms((PoseStack)pose, (BakedModel)model, (ItemDisplayContext)ItemDisplayContext.GUI, (boolean)false);
            pose.m_252781_(new Quaternionf().rotateX(1.5707964f));
            pose.m_252781_(new Quaternionf().rotateY(angle));
            pose.m_85837_(-0.5, -0.5, -0.5);
            itemRenderer.m_115189_(model, stack, 0xF000F0, OverlayTexture.f_118083_, pose, buffers.m_6299_(RenderType.m_110451_()));
            RenderSystem.disableDepthTest();
            buffers.m_109911_();
            RenderSystem.enableDepthTest();
        }
        catch (Throwable throwable) {
            // empty catch block
        }
        pose.m_85849_();
        pose.m_85849_();
        RenderSystem.clear((int)256, (boolean)Minecraft.f_91002_);
        RenderSystem.depthMask((boolean)false);
        RenderSystem.setShaderColor((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
        RenderSystem.enableBlend();
        RenderSystem.disableDepthTest();
        pose.m_85849_();
    }

    public float getStress() {
        return this.stress;
    }

    public CreateStressWidget setStress(float stress) {
        this.stress = stress;
        return this;
    }

    public CreateStressWidget setStressSupplier(Supplier<Float> stressSupplier) {
        this.stressSupplier = stressSupplier;
        return this;
    }
}

