/*
 * Decompiled with CFR 0.152.
 */
package com.lowdragmc.mbd2.integration.emi;

import com.lowdragmc.lowdraglib.emi.ModularEmiRecipe;
import com.lowdragmc.lowdraglib.gui.widget.WidgetGroup;
import com.lowdragmc.mbd2.MBD2;
import com.lowdragmc.mbd2.api.pattern.PatternPreviewWidget;
import com.lowdragmc.mbd2.api.registry.MBDRegistries;
import com.lowdragmc.mbd2.common.machine.definition.MBDMachineDefinition;
import com.lowdragmc.mbd2.common.machine.definition.MultiblockMachineDefinition;
import dev.emi.emi.api.EmiRegistry;
import dev.emi.emi.api.recipe.EmiRecipeCategory;
import dev.emi.emi.api.render.EmiRenderable;
import dev.emi.emi.api.render.EmiTexture;
import dev.emi.emi.api.stack.EmiIngredient;
import dev.emi.emi.api.stack.EmiStack;
import net.minecraft.network.chat.Component;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.item.ItemStack;
import org.jetbrains.annotations.Nullable;

public class MultiblockInfoEmiCategory
extends EmiRecipeCategory {
    public static final MultiblockInfoEmiCategory CATEGORY = new MultiblockInfoEmiCategory();

    private MultiblockInfoEmiCategory() {
        super(MBD2.id("multiblock_info"), (EmiRenderable)new EmiTexture(MBD2.id("textures/gui/multiblock_info_page.png"), 0, 0, 16, 16, 16, 16, 16, 16));
    }

    public static void registerDisplays(EmiRegistry registry) {
        MBDRegistries.MACHINE_DEFINITIONS.values().stream().filter(MultiblockMachineDefinition.class::isInstance).map(MultiblockMachineDefinition.class::cast).map(MultiblockInfoEmiRecipe::new).forEach(arg_0 -> ((EmiRegistry)registry).addRecipe(arg_0));
    }

    public static void registerWorkStations(EmiRegistry registry) {
        for (MBDMachineDefinition definition : MBDRegistries.MACHINE_DEFINITIONS.values()) {
            if (!(definition instanceof MultiblockMachineDefinition)) continue;
            MultiblockMachineDefinition multiblockDefinition = (MultiblockMachineDefinition)definition;
            registry.addWorkstation((EmiRecipeCategory)CATEGORY, (EmiIngredient)EmiStack.of((ItemStack)multiblockDefinition.asStack()));
        }
    }

    public Component getName() {
        return Component.m_237115_((String)"mbd2.jei.multiblock_info");
    }

    public static class MultiblockInfoEmiRecipe
    extends ModularEmiRecipe<WidgetGroup> {
        public final MultiblockMachineDefinition definition;

        public MultiblockInfoEmiRecipe(MultiblockMachineDefinition definition) {
            super(() -> PatternPreviewWidget.getPatternWidget(definition));
            this.definition = definition;
        }

        public EmiRecipeCategory getCategory() {
            return CATEGORY;
        }

        @Nullable
        public ResourceLocation getId() {
            return this.definition.id();
        }
    }
}

