/*
 * Decompiled with CFR 0.152.
 */
package com.lowdragmc.mbd2.integration.geckolib;

import com.lowdragmc.lowdraglib.LDLib;
import com.lowdragmc.lowdraglib.client.model.ModelFactory;
import com.lowdragmc.lowdraglib.client.renderer.IItemRendererProvider;
import com.lowdragmc.lowdraglib.client.renderer.IRenderer;
import com.lowdragmc.lowdraglib.client.renderer.ISerializableRenderer;
import com.lowdragmc.lowdraglib.gui.editor.ColorPattern;
import com.lowdragmc.lowdraglib.gui.editor.annotation.Configurable;
import com.lowdragmc.lowdraglib.gui.editor.annotation.LDLRegisterClient;
import com.lowdragmc.lowdraglib.gui.editor.annotation.NumberRange;
import com.lowdragmc.lowdraglib.gui.editor.configurator.ArrayConfiguratorGroup;
import com.lowdragmc.lowdraglib.gui.editor.configurator.Configurator;
import com.lowdragmc.lowdraglib.gui.editor.configurator.ConfiguratorGroup;
import com.lowdragmc.lowdraglib.gui.editor.configurator.StringConfigurator;
import com.lowdragmc.lowdraglib.gui.editor.configurator.WrapperConfigurator;
import com.lowdragmc.lowdraglib.gui.editor.runtime.ConfiguratorParser;
import com.lowdragmc.lowdraglib.gui.editor.ui.Editor;
import com.lowdragmc.lowdraglib.gui.texture.ColorBorderTexture;
import com.lowdragmc.lowdraglib.gui.texture.GuiTextureGroup;
import com.lowdragmc.lowdraglib.gui.texture.IGuiTexture;
import com.lowdragmc.lowdraglib.gui.texture.TextTexture;
import com.lowdragmc.lowdraglib.gui.widget.ButtonWidget;
import com.lowdragmc.lowdraglib.gui.widget.DialogWidget;
import com.lowdragmc.lowdraglib.gui.widget.Widget;
import com.lowdragmc.lowdraglib.gui.widget.WidgetGroup;
import com.lowdragmc.lowdraglib.syncdata.annotation.Persisted;
import com.lowdragmc.lowdraglib.utils.ResourceHelper;
import com.lowdragmc.mbd2.MBD2;
import com.lowdragmc.mbd2.api.machine.IMachine;
import com.lowdragmc.mbd2.common.machine.MBDMachine;
import com.lowdragmc.mbd2.core.mixins.LevelRendererAccessor;
import com.lowdragmc.mbd2.integration.geckolib.AnimatableMachine;
import com.lowdragmc.mbd2.integration.geckolib.Animation;
import com.lowdragmc.mbd2.integration.geckolib.GeckolibRendererModel;
import com.lowdragmc.mbd2.integration.geckolib.StaticAnimatable;
import com.mojang.blaze3d.platform.Lighting;
import com.mojang.blaze3d.systems.RenderSystem;
import com.mojang.blaze3d.vertex.PoseStack;
import com.mojang.blaze3d.vertex.VertexConsumer;
import com.mojang.math.Axis;
import java.io.File;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.function.Consumer;
import java.util.function.Predicate;
import javax.annotation.Nullable;
import net.minecraft.client.Minecraft;
import net.minecraft.client.renderer.MultiBufferSource;
import net.minecraft.client.renderer.RenderType;
import net.minecraft.client.renderer.entity.ItemRenderer;
import net.minecraft.client.renderer.texture.TextureAtlas;
import net.minecraft.client.renderer.texture.TextureAtlasSprite;
import net.minecraft.client.resources.model.BakedModel;
import net.minecraft.client.resources.model.BlockModelRotation;
import net.minecraft.client.resources.model.Material;
import net.minecraft.client.resources.model.ModelState;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.ListTag;
import net.minecraft.nbt.Tag;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.item.ItemDisplayContext;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;
import net.minecraftforge.client.ForgeHooksClient;
import org.jetbrains.annotations.NotNull;
import org.joml.Matrix4f;
import org.joml.Matrix4fc;
import org.joml.Vector3f;
import org.joml.Vector3fc;
import software.bernie.geckolib.animatable.GeoItem;
import software.bernie.geckolib.cache.GeckoLibCache;
import software.bernie.geckolib.cache.object.BakedGeoModel;
import software.bernie.geckolib.cache.object.GeoBone;
import software.bernie.geckolib.cache.texture.AnimatableTexture;
import software.bernie.geckolib.constant.DataTickets;
import software.bernie.geckolib.core.animatable.GeoAnimatable;
import software.bernie.geckolib.core.animation.AnimationState;
import software.bernie.geckolib.core.animation.RawAnimation;
import software.bernie.geckolib.model.GeoModel;
import software.bernie.geckolib.renderer.GeoRenderer;
import software.bernie.geckolib.renderer.layer.AutoGlowingGeoLayer;
import software.bernie.geckolib.renderer.layer.GeoRenderLayer;
import software.bernie.geckolib.renderer.layer.GeoRenderLayersContainer;
import software.bernie.geckolib.util.RenderUtils;

@LDLRegisterClient(name="geckolib", group="renderer", modID="geckolib")
@OnlyIn(value=Dist.CLIENT)
public class GeckolibRenderer
implements ISerializableRenderer,
GeoRenderer<GeoAnimatable> {
    public static final ResourceLocation DEFAULT_MODEL_PATH = MBD2.id("geo/fire_pedestal.geo.json");
    public static final ResourceLocation DEFAULT_TEXTURE_PATH = MBD2.id("textures/block/fire_pedestal.png");
    public static final ResourceLocation DEFAULT_ANIMATION_PATH = MBD2.id("animations/fire_pedestal.animation.json");
    public static final ResourceLocation DEFAULT_ITEM_TRANSFORM_MODEL = MBD2.id("item/model");
    @Persisted
    protected ResourceLocation modelPath;
    @Persisted
    protected ResourceLocation texturePath;
    @Persisted
    protected ResourceLocation animationPath;
    @Persisted
    protected ResourceLocation itemTransformModel = DEFAULT_ITEM_TRANSFORM_MODEL;
    @Configurable(name="geckolib_renderer.scale_width")
    @NumberRange(range={0.0, 10000.0}, wheel=0.10000000149011612)
    protected float scaleWidth = 1.0f;
    @Configurable(name="geckolib_renderer.scale_height")
    @NumberRange(range={0.0, 10000.0}, wheel=0.10000000149011612)
    protected float scaleHeight = 1.0f;
    @Configurable(name="geckolib_renderer.use_glowing_layer", tips={"geckolib_renderer.use_glowing_layer.tips.0", "geckolib_renderer.use_glowing_layer.tips.1"})
    protected boolean useGlowingLayer = false;
    @Configurable(name="geckolib_renderer.use_translucent", tips={"geckolib_renderer.use_translucent.tips"})
    protected boolean useTranslucent = false;
    @Configurable(name="geckolib_renderer.use_entity_gui_lighting", tips={"geckolib_renderer.use_entity_gui_lighting.tips"})
    protected boolean useEntityGuiLighting = false;
    @Configurable(name="geckolib_renderer.schedule_state_anim", tips={"geckolib_renderer.schedule_state_anim.tips.0", "geckolib_renderer.schedule_state_anim.tips.1", "geckolib_renderer.schedule_state_anim.tips.2"})
    protected boolean scheduleStateAnimation = false;
    protected List<Animation> animations = new ArrayList<Animation>();
    protected final GeoRenderLayersContainer<GeoAnimatable> renderLayers = new GeoRenderLayersContainer((GeoRenderer)this);
    @Nullable
    private ResourceLocation particleTexture;
    private final StaticAnimatable staticAnimatable = new StaticAnimatable();
    private final GeckolibRendererModel model = new GeckolibRendererModel(this);
    protected ItemStack currentItemStack;
    protected ItemDisplayContext renderPerspective;
    protected GeoAnimatable animatable;
    protected Matrix4f blockRenderTranslations = new Matrix4f();
    protected Matrix4f modelRenderTranslations = new Matrix4f();
    protected BakedModel itemModel;
    protected Map<String, RawAnimation> animationCache = new HashMap<String, RawAnimation>();

    public GeckolibRenderer() {
        this(DEFAULT_MODEL_PATH, DEFAULT_TEXTURE_PATH, DEFAULT_ANIMATION_PATH);
    }

    public GeckolibRenderer(ResourceLocation modelPath, ResourceLocation texturePath, ResourceLocation animationPath) {
        this.renderLayers.addLayer((GeoRenderLayer)new AutoGlowingGeoLayer((GeoRenderer)this));
        this.modelPath = modelPath;
        this.texturePath = texturePath;
        this.animationPath = animationPath;
    }

    public void initRenderer() {
        if (LDLib.isClient()) {
            this.registerEvent();
        }
    }

    public void setItemTransformModel(ResourceLocation itemTransformModel) {
        this.itemTransformModel = itemTransformModel;
        this.itemModel = null;
    }

    public boolean hasTESR(BlockEntity blockEntity) {
        return true;
    }

    public void onPrepareTextureAtlas(ResourceLocation atlasName, Consumer<ResourceLocation> register) {
        if (atlasName.equals((Object)TextureAtlas.f_118259_)) {
            this.particleTexture = this.getTexturePath();
            this.particleTexture = new ResourceLocation(this.particleTexture.m_135827_(), this.particleTexture.m_135815_().replace("textures/", "").replace(".png", ""));
            register.accept(this.particleTexture);
        }
    }

    @NotNull
    public TextureAtlasSprite getParticleTexture() {
        return this.particleTexture == null ? IRenderer.EMPTY.getParticleTexture() : (TextureAtlasSprite)Minecraft.m_91087_().m_91258_(TextureAtlas.f_118259_).apply(this.particleTexture);
    }

    protected BakedModel getItemTransformModel() {
        if (this.itemModel == null) {
            this.itemModel = ModelFactory.getUnBakedModel((ResourceLocation)this.itemTransformModel).m_7611_(ModelFactory.getModeBaker(), Material::m_119204_, (ModelState)BlockModelRotation.X0_Y0, this.itemTransformModel);
        }
        return this.itemModel;
    }

    public void renderItem(ItemStack stack, ItemDisplayContext transformType, boolean leftHand, PoseStack poseStack, MultiBufferSource bufferSource, int packedLight, int packedOverlay, BakedModel model) {
        IItemRendererProvider.disabled.set(true);
        this.animatable = this.staticAnimatable;
        this.currentItemStack = stack;
        this.renderPerspective = transformType;
        poseStack.m_85836_();
        poseStack.m_85837_(0.0, -0.25, 0.0);
        ForgeHooksClient.handleCameraTransforms((PoseStack)poseStack, (BakedModel)this.getItemTransformModel(), (ItemDisplayContext)transformType, (boolean)leftHand);
        if (transformType == ItemDisplayContext.GUI) {
            this.renderInGui(transformType, poseStack, bufferSource, packedLight, packedOverlay);
        } else {
            RenderType renderType = this.getRenderType(this.animatable, this.getTextureLocation(this.animatable), bufferSource, Minecraft.m_91087_().m_91296_());
            VertexConsumer buffer = ItemRenderer.m_115222_((MultiBufferSource)bufferSource, (RenderType)renderType, (boolean)false, (this.currentItemStack != null && this.currentItemStack.m_41790_() ? 1 : 0) != 0);
            this.defaultRender(poseStack, this.animatable, bufferSource, renderType, buffer, 0.0f, Minecraft.m_91087_().m_91296_(), packedLight);
        }
        poseStack.m_85849_();
        IItemRendererProvider.disabled.set(false);
        this.currentItemStack = null;
    }

    public GeoAnimatable getAnimatableFromMachine(MBDMachine machine) {
        GeoAnimatable animatable;
        Object object = machine.getAnimatableMachine().get(this);
        if (object instanceof GeoAnimatable) {
            GeoAnimatable geoAnimatable;
            animatable = geoAnimatable = (GeoAnimatable)object;
        } else {
            AnimatableMachine animatableMachine = new AnimatableMachine(machine, this);
            machine.getAnimatableMachine().put((IRenderer)this, animatableMachine);
            animatable = animatableMachine;
        }
        return animatable;
    }

    public void render(BlockEntity blockEntity, float partialTicks, PoseStack poseStack, MultiBufferSource bufferSource, int packedLight, int combinedOverlay) {
        if (!(this.checkModelAvailable() && this.checkTextureAvailable() && this.checkAnimationAvailable())) {
            return;
        }
        Object var8_7 = IMachine.ofMachine(blockEntity).orElse(null);
        if (var8_7 instanceof MBDMachine) {
            MBDMachine machine = var8_7;
            this.animatable = this.getAnimatableFromMachine(machine);
        } else {
            this.animatable = this.staticAnimatable;
        }
        RenderSystem.enableDepthTest();
        RenderSystem.depthMask((boolean)true);
        this.defaultRender(poseStack, this.animatable, bufferSource, null, null, 0.0f, partialTicks, packedLight);
    }

    public CompoundTag serializeNBT() {
        CompoundTag tag = super.serializeNBT();
        ListTag animations = new ListTag();
        this.animations.forEach(animation -> animations.add((Object)animation.serializeNBT()));
        tag.m_128365_("animations", (Tag)animations);
        return tag;
    }

    public void deserializeNBT(CompoundTag tag) {
        super.deserializeNBT(tag);
        this.animations.clear();
        ListTag animations = tag.m_128437_("animations", 10);
        animations.forEach(nbt -> {
            Animation animation = new Animation();
            animation.deserializeNBT((CompoundTag)nbt);
            this.animations.add(animation);
        });
    }

    public boolean hasAnimation(String name) {
        return this.getRawAnimation(name) != null;
    }

    @Nullable
    public RawAnimation getRawAnimation(String name) {
        if (!this.animationCache.containsKey(name)) {
            this.animations.stream().filter(animation -> animation.getName().equals(name)).findFirst().ifPresent(animation -> this.animationCache.put(name, animation.toRawAnimation()));
            if (!this.animationCache.containsKey(name)) {
                this.animationCache.put(name, null);
            }
        }
        return this.animationCache.get(name);
    }

    public boolean checkModelAvailable() {
        return GeckoLibCache.getBakedModels().containsKey(this.getModelPath());
    }

    public boolean checkTextureAvailable() {
        return ResourceHelper.isResourceExist((ResourceLocation)this.getTexturePath()) || ResourceHelper.isResourceExistRaw((ResourceLocation)this.getTexturePath());
    }

    public boolean checkAnimationAvailable() {
        return GeckoLibCache.getBakedAnimations().containsKey(this.getAnimationPath());
    }

    public GeoModel<GeoAnimatable> getGeoModel() {
        return this.model;
    }

    public long getInstanceId(GeoAnimatable animatable) {
        if (animatable instanceof AnimatableMachine) {
            AnimatableMachine machine = (AnimatableMachine)animatable;
            return (long)machine.getRenderer().hashCode() << 32 | (long)machine.getMachine().getPos().hashCode();
        }
        if (this.currentItemStack != null) {
            return GeoItem.getId((ItemStack)this.currentItemStack);
        }
        return super.getInstanceId(animatable);
    }

    public void preRender(PoseStack poseStack, GeoAnimatable animatable, BakedGeoModel model, MultiBufferSource bufferSource, VertexConsumer buffer, boolean isReRender, float partialTick, int packedLight, int packedOverlay, float red, float green, float blue, float alpha) {
        this.blockRenderTranslations = new Matrix4f((Matrix4fc)poseStack.m_85850_().m_252922_());
        this.scaleModelForRender(this.scaleWidth, this.scaleHeight, poseStack, animatable, model, isReRender, partialTick, packedLight, packedOverlay);
    }

    public void actuallyRender(PoseStack poseStack, GeoAnimatable animatable, BakedGeoModel model, RenderType renderType, MultiBufferSource bufferSource, VertexConsumer buffer, boolean isReRender, float partialTick, int packedLight, int packedOverlay, float red, float green, float blue, float alpha) {
        if (!isReRender) {
            AnimationState animationState = new AnimationState(animatable, 0.0f, 0.0f, partialTick, false);
            long instanceId = this.getInstanceId(animatable);
            GeoModel<GeoAnimatable> currentModel = this.getGeoModel();
            animationState.setData(DataTickets.TICK, (Object)animatable.getTick((Object)animatable));
            if (this.currentItemStack == null) {
                poseStack.m_85837_(0.5, 0.0, 0.5);
                this.rotateBlock(this.getFacing(animatable), poseStack);
            } else {
                poseStack.m_252880_(0.0f, 0.01f, 0.0f);
            }
            currentModel.addAdditionalStateData(animatable, instanceId, (arg_0, arg_1) -> ((AnimationState)animationState).setData(arg_0, arg_1));
            currentModel.handleAnimations(animatable, instanceId, animationState);
        }
        this.modelRenderTranslations = new Matrix4f((Matrix4fc)poseStack.m_85850_().m_252922_());
        super.actuallyRender(poseStack, animatable, model, renderType, bufferSource, buffer, isReRender, partialTick, packedLight, packedOverlay, red, green, blue, alpha);
    }

    protected void rotateBlock(Direction facing, PoseStack poseStack) {
        switch (facing) {
            case SOUTH: {
                poseStack.m_252781_(Axis.f_252436_.m_252977_(180.0f));
                break;
            }
            case WEST: {
                poseStack.m_252781_(Axis.f_252436_.m_252977_(90.0f));
                break;
            }
            case NORTH: {
                poseStack.m_252781_(Axis.f_252436_.m_252977_(0.0f));
                break;
            }
            case EAST: {
                poseStack.m_252781_(Axis.f_252436_.m_252977_(270.0f));
                break;
            }
            case UP: {
                poseStack.m_252781_(Axis.f_252529_.m_252977_(90.0f));
                break;
            }
            case DOWN: {
                poseStack.m_252781_(Axis.f_252495_.m_252977_(90.0f));
            }
        }
    }

    protected Direction getFacing(GeoAnimatable animatable) {
        if (animatable instanceof AnimatableMachine) {
            AnimatableMachine machine = (AnimatableMachine)animatable;
            return machine.getMachine().getFrontFacing().orElse(Direction.NORTH);
        }
        return Direction.NORTH;
    }

    public void renderRecursively(PoseStack poseStack, GeoAnimatable animatable, GeoBone bone, RenderType renderType, MultiBufferSource bufferSource, VertexConsumer buffer, boolean isReRender, float partialTick, int packedLight, int packedOverlay, float red, float green, float blue, float alpha) {
        if (bone.isTrackingMatrices()) {
            Matrix4f poseState = new Matrix4f((Matrix4fc)poseStack.m_85850_().m_252922_());
            Matrix4f localMatrix = RenderUtils.invertAndMultiplyMatrices((Matrix4f)poseState, (Matrix4f)this.blockRenderTranslations);
            bone.setModelSpaceMatrix(RenderUtils.invertAndMultiplyMatrices((Matrix4f)poseState, (Matrix4f)this.modelRenderTranslations));
            bone.setLocalSpaceMatrix(localMatrix);
            GeoAnimatable geoAnimatable = this.animatable;
            if (geoAnimatable instanceof AnimatableMachine) {
                AnimatableMachine machine = (AnimatableMachine)geoAnimatable;
                Matrix4f worldState = new Matrix4f((Matrix4fc)localMatrix);
                BlockPos pos = machine.getMachine().getPos();
                bone.setWorldSpaceMatrix(worldState.translate((Vector3fc)new Vector3f((float)pos.m_123341_(), (float)pos.m_123342_(), (float)pos.m_123343_())));
            } else {
                bone.setWorldSpaceMatrix(new Matrix4f().identity());
            }
        }
        super.renderRecursively(poseStack, animatable, bone, renderType, bufferSource, buffer, isReRender, partialTick, packedLight, packedOverlay, red, green, blue, alpha);
    }

    protected void setupLightingForGuiRender() {
        if (this.useEntityGuiLighting) {
            Lighting.m_166384_();
        } else {
            Lighting.m_84930_();
        }
    }

    protected void renderInGui(ItemDisplayContext transformType, PoseStack poseStack, MultiBufferSource bufferSource, int packedLight, int packedOverlay) {
        MultiBufferSource.BufferSource bufferSource2;
        this.setupLightingForGuiRender();
        MultiBufferSource.BufferSource defaultBufferSource = bufferSource instanceof MultiBufferSource.BufferSource ? (bufferSource2 = (MultiBufferSource.BufferSource)bufferSource) : ((LevelRendererAccessor)Minecraft.m_91087_().f_91060_).getRenderBuffers().m_110104_();
        RenderType renderType = this.getRenderType(this.animatable, this.getTextureLocation(this.animatable), (MultiBufferSource)defaultBufferSource, Minecraft.m_91087_().m_91296_());
        VertexConsumer buffer = ItemRenderer.m_115222_((MultiBufferSource)bufferSource, (RenderType)renderType, (boolean)true, (this.currentItemStack != null && this.currentItemStack.m_41790_() ? 1 : 0) != 0);
        poseStack.m_85836_();
        this.defaultRender(poseStack, this.animatable, (MultiBufferSource)defaultBufferSource, renderType, buffer, 0.0f, Minecraft.m_91087_().m_91296_(), packedLight);
        defaultBufferSource.m_109911_();
        RenderSystem.enableDepthTest();
        Lighting.m_84931_();
        poseStack.m_85849_();
    }

    public void updateAnimatedTextureFrame(GeoAnimatable animatable) {
        AnimatableTexture.setAndUpdate((ResourceLocation)this.getTextureLocation(animatable));
    }

    public void doPostRenderCleanup() {
        this.animatable = null;
        this.currentItemStack = null;
        this.renderPerspective = null;
    }

    public List<GeoRenderLayer<GeoAnimatable>> getRenderLayers() {
        if (this.useGlowingLayer) {
            return this.renderLayers.getRenderLayers();
        }
        return List.of();
    }

    public void fireCompileRenderLayersEvent() {
    }

    public boolean firePreRenderEvent(PoseStack poseStack, BakedGeoModel model, MultiBufferSource bufferSource, float partialTick, int packedLight) {
        return true;
    }

    public void firePostRenderEvent(PoseStack poseStack, BakedGeoModel model, MultiBufferSource bufferSource, float partialTick, int packedLight) {
    }

    public void buildConfigurator(ConfiguratorGroup father) {
        this.createPreview(father);
        this.prepareResourceConfigurator(father);
        ConfiguratorParser.createConfigurators((ConfiguratorGroup)father, new HashMap(), this.getClass(), (Object)this);
        ArrayConfiguratorGroup animationGroup = new ArrayConfiguratorGroup("geckolib_renderer.animation_group", false, () -> new ArrayList<Animation>(this.animations), (getter, setter) -> {
            Animation value = (Animation)getter.get();
            ConfiguratorGroup group = new ConfiguratorGroup("geckolib_renderer.raw_animation", false);
            value.buildConfigurator(group);
            return group;
        }, true);
        animationGroup.setAddDefault(Animation::new);
        animationGroup.setOnAdd(newAnimation -> {
            this.animations.add((Animation)newAnimation);
            this.animationCache.clear();
        });
        animationGroup.setOnRemove(removedAnimation -> {
            this.animations.remove(removedAnimation);
            this.animationCache.clear();
        });
        animationGroup.setOnUpdate(list -> {
            this.animations.clear();
            this.animations.addAll((Collection<Animation>)list);
            this.animationCache.clear();
        });
        father.addConfigurators(new Configurator[]{animationGroup});
    }

    protected void prepareResourceConfigurator(ConfiguratorGroup father) {
        GuiTextureGroup selectTexture = new GuiTextureGroup(new IGuiTexture[]{ColorPattern.T_GRAY.rectTexture().setRadius(5.0f), new TextTexture("editor.select_from_file")});
        ColorBorderTexture selectTextureHover = ColorPattern.WHITE.borderTexture(1).setRadius(5.0f);
        ConfiguratorGroup modelPathGroup = new ConfiguratorGroup("geckolib_renderer.model_path", false);
        modelPathGroup.setCanCollapse(false);
        StringConfigurator modelConfigurator = new StringConfigurator("", () -> this.modelPath.toString(), s -> {
            this.modelPath = new ResourceLocation(s);
        }, DEFAULT_MODEL_PATH.toString(), false);
        modelPathGroup.addConfigurators(new Configurator[]{modelConfigurator, new WrapperConfigurator((Widget)new WidgetGroup(0, 0, 100, 15).addWidget((Widget)new ButtonWidget(0, 2, 100, 10, (IGuiTexture)selectTexture, cd -> DialogWidget.showFileDialog((WidgetGroup)Editor.INSTANCE, (String)"geckolib_renderer.model_path", (File)new File(Editor.INSTANCE.getWorkSpace(), "geo"), (boolean)true, (Predicate)DialogWidget.suffixFilter((String[])new String[]{".geo.json"}), s -> {
            if (s != null && s.isFile()) {
                ResourceLocation location = GeckolibRenderer.getResourceFromFile(Editor.INSTANCE.getWorkSpace(), s);
                modelConfigurator.setValue((Object)location.toString());
                this.setModelPath(location);
                if (!this.checkModelAvailable()) {
                    Minecraft.m_91087_().m_91391_();
                }
            }
        })).setHoverTexture(new IGuiTexture[]{selectTextureHover})))});
        ConfiguratorGroup animationPathGroup = new ConfiguratorGroup("geckolib_renderer.animation_path", false);
        animationPathGroup.setCanCollapse(false);
        StringConfigurator animationConfigurator = new StringConfigurator("", () -> this.animationPath.toString(), s -> {
            this.animationPath = new ResourceLocation(s);
        }, DEFAULT_ANIMATION_PATH.toString(), false);
        animationPathGroup.addConfigurators(new Configurator[]{animationConfigurator, new WrapperConfigurator((Widget)new WidgetGroup(0, 0, 100, 15).addWidget((Widget)new ButtonWidget(0, 2, 100, 10, (IGuiTexture)selectTexture, cd -> DialogWidget.showFileDialog((WidgetGroup)Editor.INSTANCE, (String)"geckolib_renderer.animation_path", (File)new File(Editor.INSTANCE.getWorkSpace(), "animations"), (boolean)true, (Predicate)DialogWidget.suffixFilter((String[])new String[]{".animation.json"}), s -> {
            if (s != null && s.isFile()) {
                ResourceLocation location = GeckolibRenderer.getResourceFromFile(Editor.INSTANCE.getWorkSpace(), s);
                animationConfigurator.setValue((Object)location.toString());
                this.setAnimationPath(location);
                if (!this.checkAnimationAvailable()) {
                    Minecraft.m_91087_().m_91391_();
                }
            }
        })).setHoverTexture(new IGuiTexture[]{selectTextureHover})))});
        ConfiguratorGroup texturePathGroup = new ConfiguratorGroup("geckolib_renderer.texture_path", false);
        texturePathGroup.setCanCollapse(false);
        StringConfigurator textureConfigurator = new StringConfigurator("", () -> this.texturePath.toString(), s -> {
            this.texturePath = new ResourceLocation(s);
        }, DEFAULT_TEXTURE_PATH.toString(), false);
        texturePathGroup.addConfigurators(new Configurator[]{textureConfigurator, new WrapperConfigurator((Widget)new WidgetGroup(0, 0, 100, 15).addWidget((Widget)new ButtonWidget(0, 2, 100, 10, (IGuiTexture)selectTexture, cd -> DialogWidget.showFileDialog((WidgetGroup)Editor.INSTANCE, (String)"geckolib_renderer.texture_path", (File)new File(Editor.INSTANCE.getWorkSpace(), "textures"), (boolean)true, (Predicate)DialogWidget.suffixFilter((String[])new String[]{".png"}), s -> {
            if (s != null && s.isFile()) {
                ResourceLocation location = GeckolibRenderer.getResourceFromFile(Editor.INSTANCE.getWorkSpace(), s);
                textureConfigurator.setValue((Object)location.toString());
                this.setTexturePath(location);
            }
        })).setHoverTexture(new IGuiTexture[]{selectTextureHover})))});
        ConfiguratorGroup itemTransformModelGroup = new ConfiguratorGroup("geckolib_renderer.item_transform_model", false);
        itemTransformModelGroup.setCanCollapse(false);
        itemTransformModelGroup.setTips(new String[]{"geckolib_renderer.item_transform_model.tips"});
        StringConfigurator itemTransformModelConfigurator = new StringConfigurator("", () -> this.itemTransformModel.toString(), s -> {
            this.itemTransformModel = new ResourceLocation(s);
        }, DEFAULT_ITEM_TRANSFORM_MODEL.toString(), false);
        itemTransformModelGroup.addConfigurators(new Configurator[]{itemTransformModelConfigurator, new WrapperConfigurator((Widget)new WidgetGroup(0, 0, 100, 15).addWidget((Widget)new ButtonWidget(0, 2, 100, 10, (IGuiTexture)selectTexture, cd -> DialogWidget.showFileDialog((WidgetGroup)Editor.INSTANCE, (String)"geckolib_renderer.item_transform_model", (File)new File(Editor.INSTANCE.getWorkSpace(), "models/item"), (boolean)true, (Predicate)DialogWidget.suffixFilter((String[])new String[]{".json"}), s -> {
            if (s != null && s.isFile()) {
                ResourceLocation location = GeckolibRenderer.getResourceFromFile(new File(Editor.INSTANCE.getWorkSpace(), "models"), s);
                location = new ResourceLocation(location.m_135827_(), location.m_135815_().replace(".json", ""));
                itemTransformModelConfigurator.setValue((Object)location.toString());
                this.setItemTransformModel(location);
            }
        })).setHoverTexture(new IGuiTexture[]{selectTextureHover})))});
        father.addConfigurators(new Configurator[]{modelPathGroup, animationPathGroup, texturePathGroup, itemTransformModelGroup});
    }

    private static ResourceLocation getResourceFromFile(File path, File r) {
        String id = path.getPath().replace('\\', '/').split("assets/")[1].split("/")[0];
        return new ResourceLocation(id, r.getPath().replace(path.getPath(), "").replace('\\', '/').substring(1));
    }

    public ResourceLocation getModelPath() {
        return this.modelPath;
    }

    public ResourceLocation getTexturePath() {
        return this.texturePath;
    }

    public ResourceLocation getAnimationPath() {
        return this.animationPath;
    }

    public float getScaleWidth() {
        return this.scaleWidth;
    }

    public float getScaleHeight() {
        return this.scaleHeight;
    }

    public boolean isUseGlowingLayer() {
        return this.useGlowingLayer;
    }

    public boolean isUseTranslucent() {
        return this.useTranslucent;
    }

    public boolean isUseEntityGuiLighting() {
        return this.useEntityGuiLighting;
    }

    public boolean isScheduleStateAnimation() {
        return this.scheduleStateAnimation;
    }

    public List<Animation> getAnimations() {
        return this.animations;
    }

    public StaticAnimatable getStaticAnimatable() {
        return this.staticAnimatable;
    }

    public GeckolibRendererModel getModel() {
        return this.model;
    }

    public ItemStack getCurrentItemStack() {
        return this.currentItemStack;
    }

    public ItemDisplayContext getRenderPerspective() {
        return this.renderPerspective;
    }

    public GeoAnimatable getAnimatable() {
        return this.animatable;
    }

    public Matrix4f getBlockRenderTranslations() {
        return this.blockRenderTranslations;
    }

    public Matrix4f getModelRenderTranslations() {
        return this.modelRenderTranslations;
    }

    public BakedModel getItemModel() {
        return this.itemModel;
    }

    public Map<String, RawAnimation> getAnimationCache() {
        return this.animationCache;
    }

    public void setModelPath(ResourceLocation modelPath) {
        this.modelPath = modelPath;
    }

    public void setTexturePath(ResourceLocation texturePath) {
        this.texturePath = texturePath;
    }

    public void setAnimationPath(ResourceLocation animationPath) {
        this.animationPath = animationPath;
    }
}

