/*
 * Decompiled with CFR 0.152.
 */
package com.lowdragmc.mbd2.integration.jei;

import com.lowdragmc.lowdraglib.gui.texture.IGuiTexture;
import com.lowdragmc.lowdraglib.gui.widget.Widget;
import com.lowdragmc.lowdraglib.jei.IGui2IDrawable;
import com.lowdragmc.lowdraglib.jei.ModularUIRecipeCategory;
import com.lowdragmc.lowdraglib.jei.ModularWrapper;
import com.lowdragmc.lowdraglib.utils.Size;
import com.lowdragmc.mbd2.api.recipe.MBDRecipe;
import com.lowdragmc.mbd2.api.recipe.MBDRecipeType;
import com.lowdragmc.mbd2.api.registry.MBDRegistries;
import com.lowdragmc.mbd2.common.machine.definition.MBDMachineDefinition;
import java.util.function.Function;
import java.util.stream.Collectors;
import javax.annotation.Nullable;
import javax.annotation.ParametersAreNonnullByDefault;
import mezz.jei.api.gui.drawable.IDrawable;
import mezz.jei.api.helpers.IGuiHelper;
import mezz.jei.api.helpers.IJeiHelpers;
import mezz.jei.api.recipe.RecipeType;
import mezz.jei.api.registration.IRecipeCatalystRegistration;
import mezz.jei.api.registration.IRecipeRegistration;
import net.minecraft.MethodsReturnNonnullByDefault;
import net.minecraft.Util;
import net.minecraft.client.Minecraft;
import net.minecraft.network.chat.Component;
import net.minecraft.resources.ResourceLocation;

@MethodsReturnNonnullByDefault
@ParametersAreNonnullByDefault
public class MBDRecipeTypeFuelCategory
extends ModularUIRecipeCategory<RecipeWrapper> {
    public static final Function<MBDRecipeType, RecipeType<RecipeWrapper>> TYPES = Util.m_143827_(recipeMap -> new RecipeType(recipeMap.getFuelRegistryName(), RecipeWrapper.class));
    private final MBDRecipeType recipeType;
    private final IDrawable background;
    private final IDrawable icon;

    public MBDRecipeTypeFuelCategory(IJeiHelpers helpers, MBDRecipeType recipeType) {
        this.recipeType = recipeType;
        IGuiHelper guiHelper = helpers.getGuiHelper();
        Size size = recipeType.getFuelUISize();
        this.background = guiHelper.createBlankDrawable(size.width, size.height);
        this.icon = IGui2IDrawable.toDrawable((IGuiTexture)recipeType.getFuelIcon(), (int)16, (int)16);
    }

    public RecipeType<RecipeWrapper> getRecipeType() {
        return TYPES.apply(this.recipeType);
    }

    public Component getTitle() {
        return Component.m_237110_((String)"recipe_type.fuel", (Object[])new Object[]{Component.m_237115_((String)this.recipeType.getRegistryName().m_214298_())});
    }

    public static void registerRecipes(IRecipeRegistration registration) {
        for (MBDRecipeType recipeType : MBDRegistries.RECIPE_TYPES) {
            if (!recipeType.isXEIVisible() || !recipeType.isRequireFuelForWorking()) continue;
            registration.addRecipes(TYPES.apply(recipeType), Minecraft.m_91087_().m_91403_().m_105141_().m_44013_((net.minecraft.world.item.crafting.RecipeType)recipeType).stream().filter(recipe -> recipe.isFuel && !recipe.isXEIHidden).map(RecipeWrapper::new).collect(Collectors.toList()));
        }
    }

    public static void registerRecipeCatalysts(IRecipeCatalystRegistration registration) {
        for (MBDRecipeType mbdRecipeType : MBDRegistries.RECIPE_TYPES) {
            if (!mbdRecipeType.isXEIVisible() || !mbdRecipeType.isRequireFuelForWorking()) continue;
            for (MBDMachineDefinition definition : MBDRegistries.MACHINE_DEFINITIONS) {
                MBDRecipeType recipeType = definition.recipeLogicSettings().getRecipeType();
                if (recipeType != mbdRecipeType) continue;
                registration.addRecipeCatalyst(definition.item().m_7968_(), new RecipeType[]{TYPES.apply(mbdRecipeType)});
            }
        }
    }

    @Nullable
    public ResourceLocation getRegistryName(RecipeWrapper wrapper) {
        return wrapper.recipe.id;
    }

    public IDrawable getBackground() {
        return this.background;
    }

    public IDrawable getIcon() {
        return this.icon;
    }

    public static class RecipeWrapper
    extends ModularWrapper<Widget> {
        public final MBDRecipe recipe;

        public RecipeWrapper(MBDRecipe recipe) {
            super((Widget)recipe.recipeType.createFuelUI(recipe));
            this.recipe = recipe;
        }
    }
}

