/*
 * Decompiled with CFR 0.152.
 */
package com.lowdragmc.mbd2.integration.kubejs.events;

import com.lowdragmc.mbd2.api.registry.MBDRegistries;
import com.lowdragmc.mbd2.common.machine.definition.MBDMachineDefinition;
import dev.latvian.mods.kubejs.event.EventResult;
import dev.latvian.mods.kubejs.event.StartupEventJS;
import java.util.HashMap;
import java.util.Map;
import java.util.function.Supplier;
import javax.annotation.Nullable;
import net.minecraft.resources.ResourceLocation;

public class MBDMachineRegistryEventJS
extends StartupEventJS {
    public static final Map<String, Supplier<? extends MBDMachineDefinition.Builder>> BUILDERS = new HashMap<String, Supplier<? extends MBDMachineDefinition.Builder>>();
    private final Map<ResourceLocation, MBDMachineDefinition.Builder> machineBuilders = new HashMap<ResourceLocation, MBDMachineDefinition.Builder>();

    public MBDMachineDefinition.Builder create(String machineType, ResourceLocation machineID) {
        Supplier<? extends MBDMachineDefinition.Builder> builderCreator = BUILDERS.get(machineType);
        if (builderCreator == null) {
            throw new IllegalArgumentException("Unknown machine type: " + machineType);
        }
        MBDMachineDefinition.Builder builder = builderCreator.get();
        builder.id(machineID);
        this.machineBuilders.put(machineID, builder);
        return builder;
    }

    public void removeMachine(ResourceLocation id) {
        this.machineBuilders.remove(id);
        MBDRegistries.MACHINE_DEFINITIONS.remove(id);
    }

    @Nullable
    public MBDMachineDefinition getMachine(ResourceLocation id) {
        return (MBDMachineDefinition)MBDRegistries.MACHINE_DEFINITIONS.get(id);
    }

    protected void afterPosted(EventResult result) {
        this.machineBuilders.forEach((id, builder) -> MBDRegistries.MACHINE_DEFINITIONS.register(id, builder.build()));
    }
}

