/*
 * Decompiled with CFR 0.152.
 */
package com.lowdragmc.mbd2.api.pattern.util;

import java.util.function.Function;
import net.minecraft.core.Direction;

public enum RelativeDirection {
    UP(f -> Direction.UP, Direction.Axis.Y),
    DOWN(f -> Direction.DOWN, Direction.Axis.Y),
    LEFT(Direction::m_122428_, Direction.Axis.X),
    RIGHT(Direction::m_122427_, Direction.Axis.X),
    FRONT(Function.identity(), Direction.Axis.Z),
    BACK(Direction::m_122424_, Direction.Axis.Z);

    final Function<Direction, Direction> actualFacing;
    public final Direction.Axis axis;

    private RelativeDirection(Function<Direction, Direction> actualFacing, Direction.Axis axis) {
        this.actualFacing = actualFacing;
        this.axis = axis;
    }

    public static RelativeDirection getAisleDirection(Direction.Axis layerAxis, Direction controllerFace) {
        return switch (controllerFace) {
            case Direction.NORTH -> {
                switch (layerAxis) {
                    default: {
                        throw new IncompatibleClassChangeError();
                    }
                    case X: {
                        yield RIGHT;
                    }
                    case Y: {
                        yield UP;
                    }
                    case Z: 
                }
                yield BACK;
            }
            case Direction.SOUTH -> {
                switch (layerAxis) {
                    default: {
                        throw new IncompatibleClassChangeError();
                    }
                    case X: {
                        yield LEFT;
                    }
                    case Y: {
                        yield UP;
                    }
                    case Z: 
                }
                yield FRONT;
            }
            case Direction.WEST -> {
                switch (layerAxis) {
                    default: {
                        throw new IncompatibleClassChangeError();
                    }
                    case X: {
                        yield BACK;
                    }
                    case Y: {
                        yield UP;
                    }
                    case Z: 
                }
                yield LEFT;
            }
            case Direction.EAST -> {
                switch (layerAxis) {
                    default: {
                        throw new IncompatibleClassChangeError();
                    }
                    case X: {
                        yield FRONT;
                    }
                    case Y: {
                        yield UP;
                    }
                    case Z: 
                }
                yield RIGHT;
            }
            default -> throw new IllegalArgumentException("Invalid controller face: " + String.valueOf(controllerFace));
        };
    }

    public static RelativeDirection getSliceXDirection(Direction.Axis layerAxis, Direction controllerFace) {
        return switch (controllerFace) {
            case Direction.NORTH -> {
                switch (layerAxis) {
                    default: {
                        throw new IncompatibleClassChangeError();
                    }
                    case X: {
                        yield UP;
                    }
                    case Y: {
                        yield RIGHT;
                    }
                    case Z: 
                }
                yield RIGHT;
            }
            case Direction.SOUTH -> {
                switch (layerAxis) {
                    default: {
                        throw new IncompatibleClassChangeError();
                    }
                    case X: {
                        yield UP;
                    }
                    case Y: {
                        yield LEFT;
                    }
                    case Z: 
                }
                yield LEFT;
            }
            case Direction.WEST -> {
                switch (layerAxis) {
                    default: {
                        throw new IncompatibleClassChangeError();
                    }
                    case X: {
                        yield UP;
                    }
                    case Y: {
                        yield BACK;
                    }
                    case Z: 
                }
                yield BACK;
            }
            case Direction.EAST -> {
                switch (layerAxis) {
                    default: {
                        throw new IncompatibleClassChangeError();
                    }
                    case X: {
                        yield UP;
                    }
                    case Y: {
                        yield FRONT;
                    }
                    case Z: 
                }
                yield FRONT;
            }
            default -> throw new IllegalArgumentException("Invalid controller face: " + String.valueOf(controllerFace));
        };
    }

    public static RelativeDirection getSliceYDirection(Direction.Axis layerAxis, Direction controllerFace) {
        return switch (controllerFace) {
            case Direction.NORTH -> {
                switch (layerAxis) {
                    default: {
                        throw new IncompatibleClassChangeError();
                    }
                    case X: {
                        yield BACK;
                    }
                    case Y: {
                        yield BACK;
                    }
                    case Z: 
                }
                yield UP;
            }
            case Direction.SOUTH -> {
                switch (layerAxis) {
                    default: {
                        throw new IncompatibleClassChangeError();
                    }
                    case X: {
                        yield FRONT;
                    }
                    case Y: {
                        yield FRONT;
                    }
                    case Z: 
                }
                yield UP;
            }
            case Direction.WEST -> {
                switch (layerAxis) {
                    default: {
                        throw new IncompatibleClassChangeError();
                    }
                    case X: {
                        yield LEFT;
                    }
                    case Y: {
                        yield LEFT;
                    }
                    case Z: 
                }
                yield UP;
            }
            case Direction.EAST -> {
                switch (layerAxis) {
                    default: {
                        throw new IncompatibleClassChangeError();
                    }
                    case X: {
                        yield RIGHT;
                    }
                    case Y: {
                        yield RIGHT;
                    }
                    case Z: 
                }
                yield UP;
            }
            default -> throw new IllegalArgumentException("Invalid controller face: " + String.valueOf(controllerFace));
        };
    }

    public Direction getActualFacing(Direction facing) {
        return this.actualFacing.apply(facing);
    }

    public boolean isSameAxis(RelativeDirection dir) {
        return this.axis == dir.axis;
    }
}

