/*
 * Decompiled with CFR 0.152.
 */
package com.lowdragmc.mbd2.api.recipe.content;

import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import com.lowdragmc.lowdraglib.LDLib;
import com.lowdragmc.lowdraglib.utils.NBTToJsonConverter;
import com.lowdragmc.mbd2.api.recipe.content.Content;
import com.lowdragmc.mbd2.api.recipe.content.ContentModifier;
import io.netty.buffer.Unpooled;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.Tag;
import net.minecraft.network.FriendlyByteBuf;
import net.minecraftforge.common.crafting.CraftingHelper;

public interface IContentSerializer<T> {
    default public void toNetwork(FriendlyByteBuf buf, T content) {
        buf.m_130070_(LDLib.GSON.toJson(this.toJson(content)));
    }

    default public T fromNetwork(FriendlyByteBuf buf) {
        return this.fromJson((JsonElement)LDLib.GSON.fromJson(buf.m_130277_(), JsonElement.class));
    }

    default public Tag toNBT(T content) {
        return CraftingHelper.getNBT((JsonElement)this.toJson(content));
    }

    default public T fromNBT(Tag nbt) {
        return this.fromJson(NBTToJsonConverter.getObject((Tag)nbt));
    }

    public T fromJson(JsonElement var1);

    public JsonElement toJson(T var1);

    public T of(Object var1);

    public T copyWithModifier(T var1, ContentModifier var2);

    public T copyInner(T var1);

    default public T deepCopyInner(T content) {
        FriendlyByteBuf buf = new FriendlyByteBuf(Unpooled.buffer());
        this.toNetwork(buf, content);
        return this.fromNetwork(buf);
    }

    default public void toNetworkContent(FriendlyByteBuf buf, Content content) {
        Object inner = content.getContent();
        this.toNetwork(buf, inner);
        buf.writeBoolean(content.perTick);
        buf.writeFloat(content.chance);
        buf.writeFloat(content.tierChanceBoost);
        buf.writeBoolean(!content.slotName.isEmpty());
        if (!content.slotName.isEmpty()) {
            buf.m_130070_(content.slotName);
        }
        buf.writeBoolean(!content.uiName.isEmpty());
        if (!content.uiName.isEmpty()) {
            buf.m_130070_(content.uiName);
        }
    }

    default public Content fromNetworkContent(FriendlyByteBuf buf) {
        T inner = this.fromNetwork(buf);
        boolean perTick = buf.readBoolean();
        float chance = buf.readFloat();
        float tierChanceBoost = buf.readFloat();
        String slotName = null;
        if (buf.readBoolean()) {
            slotName = buf.m_130277_();
        }
        String uiName = null;
        if (buf.readBoolean()) {
            uiName = buf.m_130277_();
        }
        return new Content(inner, perTick, chance, tierChanceBoost, slotName, uiName);
    }

    default public JsonElement toJsonContent(Content content) {
        JsonObject json = new JsonObject();
        json.add("content", this.toJson(content.getContent()));
        json.addProperty("perTick", Boolean.valueOf(content.perTick));
        json.addProperty("chance", (Number)Float.valueOf(content.chance));
        json.addProperty("tierChanceBoost", (Number)Float.valueOf(content.tierChanceBoost));
        if (!content.slotName.isEmpty()) {
            json.addProperty("slotName", content.slotName);
        }
        if (!content.uiName.isEmpty()) {
            json.addProperty("uiName", content.uiName);
        }
        return json;
    }

    default public Content fromJsonContent(JsonElement json) {
        JsonObject jsonObject = json.getAsJsonObject();
        T inner = this.fromJson(jsonObject.get("content"));
        boolean perTick = jsonObject.has("perTick") && jsonObject.get("perTick").getAsBoolean();
        float chance = jsonObject.has("chance") ? jsonObject.get("chance").getAsFloat() : 1.0f;
        float tierChanceBoost = jsonObject.has("tierChanceBoost") ? jsonObject.get("tierChanceBoost").getAsFloat() : 0.0f;
        String slotName = jsonObject.has("slotName") ? jsonObject.get("slotName").getAsString() : null;
        String uiName = jsonObject.has("uiName") ? jsonObject.get("uiName").getAsString() : null;
        return new Content(inner, perTick, chance, tierChanceBoost, slotName, uiName);
    }

    default public Content fromNBT(CompoundTag tag) {
        T content = this.fromNBT(tag.m_128423_("content"));
        boolean perTick = tag.m_128471_("per_tick");
        float chance = tag.m_128457_("chance");
        float tierChanceBoost = tag.m_128457_("tier_chance_boost");
        String slotName = tag.m_128461_("slot_name");
        String uiName = tag.m_128461_("ui_name");
        return new Content(content, perTick, chance, tierChanceBoost, slotName, uiName);
    }

    default public CompoundTag toNBT(Content content) {
        CompoundTag tag = new CompoundTag();
        tag.m_128365_("content", this.toNBT(this.of(content.content)));
        tag.m_128379_("per_tick", content.perTick);
        tag.m_128350_("chance", content.chance);
        tag.m_128350_("tier_chance_boost", content.tierChanceBoost);
        tag.m_128359_("slot_name", content.slotName);
        tag.m_128359_("ui_name", content.uiName);
        return tag;
    }
}

