/*
 * Decompiled with CFR 0.152.
 */
package com.lowdragmc.mbd2.common.gui.editor.machine.widget;

import com.lowdragmc.lowdraglib.gui.editor.ColorPattern;
import com.lowdragmc.lowdraglib.gui.editor.Icons;
import com.lowdragmc.lowdraglib.gui.editor.annotation.LDLRegister;
import com.lowdragmc.lowdraglib.gui.editor.configurator.IConfigurable;
import com.lowdragmc.lowdraglib.gui.editor.data.IProject;
import com.lowdragmc.lowdraglib.gui.editor.runtime.AnnotationDetector;
import com.lowdragmc.lowdraglib.gui.texture.IGuiTexture;
import com.lowdragmc.lowdraglib.gui.texture.TextTexture;
import com.lowdragmc.lowdraglib.gui.util.TreeBuilder;
import com.lowdragmc.lowdraglib.gui.widget.DialogWidget;
import com.lowdragmc.lowdraglib.gui.widget.DraggableScrollableWidgetGroup;
import com.lowdragmc.lowdraglib.gui.widget.ImageWidget;
import com.lowdragmc.lowdraglib.gui.widget.SelectableWidgetGroup;
import com.lowdragmc.lowdraglib.gui.widget.Widget;
import com.lowdragmc.lowdraglib.gui.widget.WidgetGroup;
import com.lowdragmc.lowdraglib.utils.Size;
import com.lowdragmc.mbd2.api.registry.MBDRegistries;
import com.lowdragmc.mbd2.common.gui.editor.MachineEditor;
import com.lowdragmc.mbd2.common.gui.editor.MachineProject;
import com.lowdragmc.mbd2.common.gui.editor.machine.MachineScenePanel;
import com.lowdragmc.mbd2.common.trait.TraitDefinition;
import javax.annotation.Nullable;
import net.minecraft.nbt.CompoundTag;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;

public class TraitList
extends DraggableScrollableWidgetGroup {
    private final MachineEditor editor;
    @Nullable
    private TraitDefinition selected;

    public TraitList(MachineEditor editor, Size size) {
        super(0, 0, size.width, size.height);
        this.editor = editor;
        this.setYScrollBarWidth(4).setYBarStyle(null, (IGuiTexture)ColorPattern.T_WHITE.rectTexture().setRadius(2.0f).transform(-0.5f, 0.0f));
        IProject iProject = editor.getCurrentProject();
        if (iProject instanceof MachineProject) {
            MachineProject project = (MachineProject)iProject;
            project.getDefinition().machineSettings().traitDefinitions().forEach(this::addDefinition);
        }
    }

    public void addDefinition(TraitDefinition definition) {
        int yOffset = 3 + this.widgets.size() * 20;
        SelectableWidgetGroup selectableWidgetGroup = new SelectableWidgetGroup(0, yOffset, this.getSizeWidth() - 2, 18);
        selectableWidgetGroup.addWidget((Widget)new ImageWidget(1, 0, 18, 18, definition.getIcon()));
        selectableWidgetGroup.addWidget((Widget)new ImageWidget(20, 0, this.getSizeWidth() - 20, 18, (IGuiTexture)new TextTexture().setSupplier(definition::getTranslateKey).setType(TextTexture.TextType.HIDE).setWidth(this.getSizeWidth() - 20)));
        selectableWidgetGroup.setSelectedTexture((IGuiTexture)ColorPattern.T_GRAY.rectTexture());
        selectableWidgetGroup.setOnSelected(group -> {
            this.editor.getConfigPanel().openConfigurator(MachineEditor.BASIC, (IConfigurable)definition);
            this.selected = definition;
        });
        this.addWidget((Widget)selectableWidgetGroup);
    }

    public void removeDefinition(TraitDefinition definition) {
        IProject iProject = this.editor.getCurrentProject();
        if (!(iProject instanceof MachineProject)) {
            return;
        }
        MachineProject project = (MachineProject)iProject;
        int index = project.getDefinition().machineSettings().traitDefinitions().indexOf(definition);
        if (index >= 0) {
            project.getDefinition().machineSettings().removeTraitDefinition(definition);
            for (int i = index + 1; i < this.widgets.size(); ++i) {
                ((Widget)this.widgets.get(i)).addSelfPosition(0, -15);
            }
            this.widgets.remove(index);
            this.computeMax();
        }
        if (this.selected == definition) {
            this.selected = null;
            this.editor.getConfigPanel().clearAllConfigurators(MachineEditor.BASIC);
        }
    }

    public void updateScenePreviewMachine() {
        for (WidgetGroup panel : this.editor.getTabPages().tabs.values()) {
            if (!(panel instanceof MachineScenePanel)) continue;
            MachineScenePanel scenePanel = (MachineScenePanel)panel;
            scenePanel.reloadAdditionalTraits();
        }
    }

    @OnlyIn(value=Dist.CLIENT)
    public boolean mouseClicked(double mouseX, double mouseY, int button) {
        IProject iProject;
        if (this.isMouseOverElement(mouseX, mouseY) && button == 1 && (iProject = this.editor.getCurrentProject()) instanceof MachineProject) {
            MachineProject project = (MachineProject)iProject;
            TreeBuilder.Menu menu = TreeBuilder.Menu.start().branch((IGuiTexture)Icons.ADD_FILE, "editor.machine.machine_traits.add_trait", m -> {
                for (AnnotationDetector.Wrapper wrapper : MBDRegistries.TRAIT_DEFINITION_TYPES.values()) {
                    m.leaf(((TraitDefinition)wrapper.creator().get()).getIcon(), "config.definition.trait.%s.name".formatted(((LDLRegister)wrapper.annotation()).name()), () -> {
                        TraitDefinition traitDefinition = (TraitDefinition)wrapper.creator().get();
                        if (!traitDefinition.allowMultiple()) {
                            for (TraitDefinition existed : project.getDefinition().machineSettings().traitDefinitions()) {
                                if (existed.getClass() != traitDefinition.getClass()) continue;
                                DialogWidget.showNotification((WidgetGroup)this.editor, (String)"editor.machine.machine_traits.add_trait.error", (String)"editor.machine.machine_traits.add_trait.error.allow_multiple");
                                return;
                            }
                        }
                        String name = traitDefinition.getName();
                        int index = 0;
                        while (project.getDefinition().machineSettings().traitDefinitions().stream().anyMatch(e -> e.getName().equals(traitDefinition.getName()))) {
                            traitDefinition.setName(name + "_%d".formatted(index));
                            ++index;
                        }
                        project.getDefinition().machineSettings().addTraitDefinition(traitDefinition);
                        this.addDefinition(traitDefinition);
                        this.updateScenePreviewMachine();
                    });
                }
            });
            if (this.selected != null) {
                menu.crossLine();
                if (this.selected.allowMultiple()) {
                    menu.leaf((IGuiTexture)Icons.COPY, "ldlib.gui.editor.menu.copy", () -> {
                        String name = this.selected.getName();
                        CompoundTag tag = this.selected.serializeNBT();
                        TraitDefinition definition = TraitDefinition.deserializeDefinition(tag);
                        if (definition != null) {
                            int index = 0;
                            while (project.getDefinition().machineSettings().traitDefinitions().stream().anyMatch(e -> e.getName().equals(definition.getName()))) {
                                definition.setName(name + "_copied_%d".formatted(index));
                                ++index;
                            }
                            project.getDefinition().machineSettings().addTraitDefinition(definition);
                            this.addDefinition(definition);
                            this.updateScenePreviewMachine();
                        }
                    });
                }
                menu.leaf((IGuiTexture)Icons.REMOVE_FILE, "editor.machine.machine_traits.remove_trait", () -> this.removeDefinition(this.selected));
            }
            this.editor.openMenu(mouseX, mouseY, menu);
            return true;
        }
        return super.mouseClicked(mouseX, mouseY, button);
    }

    @Nullable
    public TraitDefinition getSelected() {
        return this.selected;
    }
}

