/*
 * Decompiled with CFR 0.152.
 */
package com.lowdragmc.mbd2.common.gui.editor.multiblock;

import com.lowdragmc.lowdraglib.client.utils.RenderBufferUtils;
import com.lowdragmc.lowdraglib.gui.editor.ColorPattern;
import com.lowdragmc.lowdraglib.gui.editor.annotation.ConfigSelector;
import com.lowdragmc.lowdraglib.gui.editor.annotation.ConfigSetter;
import com.lowdragmc.lowdraglib.gui.editor.annotation.Configurable;
import com.lowdragmc.lowdraglib.gui.editor.annotation.NumberRange;
import com.lowdragmc.lowdraglib.gui.editor.configurator.Configurator;
import com.lowdragmc.lowdraglib.gui.editor.configurator.ConfiguratorGroup;
import com.lowdragmc.lowdraglib.gui.editor.configurator.IConfigurable;
import com.lowdragmc.lowdraglib.gui.editor.configurator.WrapperConfigurator;
import com.lowdragmc.lowdraglib.gui.editor.ui.Editor;
import com.lowdragmc.lowdraglib.gui.editor.ui.sceneeditor.SceneEditorWidget;
import com.lowdragmc.lowdraglib.gui.texture.GuiTextureGroup;
import com.lowdragmc.lowdraglib.gui.texture.IGuiTexture;
import com.lowdragmc.lowdraglib.gui.texture.TextTexture;
import com.lowdragmc.lowdraglib.gui.widget.ButtonWidget;
import com.lowdragmc.lowdraglib.gui.widget.DialogWidget;
import com.lowdragmc.lowdraglib.gui.widget.ImageWidget;
import com.lowdragmc.lowdraglib.gui.widget.SceneWidget;
import com.lowdragmc.lowdraglib.gui.widget.Widget;
import com.lowdragmc.lowdraglib.gui.widget.WidgetGroup;
import com.lowdragmc.lowdraglib.utils.BlockInfo;
import com.lowdragmc.lowdraglib.utils.BlockPosFace;
import com.lowdragmc.lowdraglib.utils.ColorUtils;
import com.lowdragmc.lowdraglib.utils.Position;
import com.lowdragmc.lowdraglib.utils.Size;
import com.lowdragmc.mbd2.api.pattern.MultiblockShapeInfo;
import com.lowdragmc.mbd2.api.pattern.predicates.PredicateBlocks;
import com.lowdragmc.mbd2.api.pattern.predicates.PredicateFluids;
import com.lowdragmc.mbd2.common.gui.editor.MachineEditor;
import com.lowdragmc.mbd2.common.gui.editor.MultiblockMachineProject;
import com.lowdragmc.mbd2.common.gui.editor.PredicateResource;
import com.lowdragmc.mbd2.common.gui.editor.multiblock.BlockPlaceholder;
import com.lowdragmc.mbd2.common.gui.editor.multiblock.MultiblockPatternPanel;
import com.lowdragmc.mbd2.utils.ControllerBlockInfo;
import com.mojang.blaze3d.systems.RenderSystem;
import com.mojang.blaze3d.vertex.BufferBuilder;
import com.mojang.blaze3d.vertex.DefaultVertexFormat;
import com.mojang.blaze3d.vertex.PoseStack;
import com.mojang.blaze3d.vertex.Tesselator;
import com.mojang.blaze3d.vertex.VertexConsumer;
import com.mojang.blaze3d.vertex.VertexFormat;
import com.mojang.datafixers.util.Either;
import java.util.HashSet;
import java.util.Optional;
import net.minecraft.client.Minecraft;
import net.minecraft.client.multiplayer.ClientLevel;
import net.minecraft.client.renderer.GameRenderer;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.util.Mth;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.LiquidBlock;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.material.Fluid;
import net.minecraftforge.registries.ForgeRegistries;
import org.joml.Vector3i;

public class MultiblockAreaPanel
extends WidgetGroup {
    protected final MultiblockMachineProject project;
    protected final SceneEditorWidget scene;
    protected final MultiblockPatternPanel patternPanel;
    protected final WidgetGroup buttonGroup;
    private final Runtime runtime = new Runtime();

    public MultiblockAreaPanel(MultiblockMachineProject project, MultiblockPatternPanel patternPanel) {
        super(0, 32, Editor.INSTANCE.getSize().getWidth() - 252, Editor.INSTANCE.getSize().height - 16 - 16);
        this.project = project;
        this.patternPanel = patternPanel;
        this.scene = new SceneEditorWidget(0, 0, this.getSize().width, this.getSize().height, null);
        this.addWidget((Widget)this.scene);
        this.buttonGroup = new WidgetGroup(0, 0, this.getSize().width, this.getSize().height);
        this.addWidget((Widget)this.buttonGroup);
        this.scene.disableTransformGizmo();
        this.scene.setRenderFacing(false);
        this.scene.setRenderSelect(false);
        this.scene.createScene((Level)Minecraft.m_91087_().f_91073_);
        this.scene.setAfterWorldRender(this::renderAfterWorld);
        this.scene.useCacheBuffer();
        this.reloadScene();
        this.prepareButtonGroup();
        this.buttonGroup.setSize(new Size(Math.max(0, this.buttonGroup.widgets.size() * 25 - 5), 20));
        this.buttonGroup.setSelfPosition(new Position(this.getSize().width - this.buttonGroup.getSize().width - 25, 25));
    }

    public void reloadScene() {
        BlockPos pos = Minecraft.m_91087_().f_91074_.m_20097_();
        ClientLevel level = Minecraft.m_91087_().f_91073_;
        HashSet<BlockPos> blocks = new HashSet<BlockPos>();
        int radius = this.runtime.sceneRadius;
        for (int x = -radius; x <= radius; ++x) {
            for (int y = -radius; y <= radius; ++y) {
                for (int z = -radius; z <= radius; ++z) {
                    BlockPos blockPos = pos.m_7918_(x, y, z).m_7949_();
                    if (!level.m_46749_(blockPos)) continue;
                    blocks.add(pos.m_7918_(x, y, z).m_7949_());
                }
            }
        }
        this.scene.setRenderedCore(blocks);
    }

    public void generateShapeInfo() {
        int minX = Math.min(this.runtime.area.from.m_123341_(), this.runtime.area.to.m_123341_());
        int minY = Math.min(this.runtime.area.from.m_123342_(), this.runtime.area.to.m_123342_());
        int minZ = Math.min(this.runtime.area.from.m_123343_(), this.runtime.area.to.m_123343_());
        int maxX = Math.max(this.runtime.area.from.m_123341_(), this.runtime.area.to.m_123341_());
        int maxY = Math.max(this.runtime.area.from.m_123342_(), this.runtime.area.to.m_123342_());
        int maxZ = Math.max(this.runtime.area.from.m_123343_(), this.runtime.area.to.m_123343_());
        BlockPos controllerPos = new BlockPos(this.runtime.controllerOffset.x + minX, this.runtime.controllerOffset.y + minY, this.runtime.controllerOffset.z + minZ);
        Direction controllerFace = this.runtime.controllerFace;
        BlockInfo[][][] blockInfos = new BlockInfo[maxX - minX + 1][maxY - minY + 1][maxZ - minZ + 1];
        ClientLevel level = Minecraft.m_91087_().f_91073_;
        assert (level != null);
        for (int x = minX; x <= maxX; ++x) {
            for (int y = minY; y <= maxY; ++y) {
                for (int z = minZ; z <= maxZ; ++z) {
                    BlockPos pos = new BlockPos(x, y, z);
                    BlockInfo blockInfo = BlockInfo.fromBlockState((BlockState)level.m_8055_(pos));
                    if (pos.equals((Object)controllerPos)) {
                        blockInfo = new ControllerBlockInfo(controllerFace);
                    }
                    blockInfos[x - minX][y - minY][z - minZ] = blockInfo;
                }
            }
        }
        this.project.getMultiblockShapeInfos().add(new MultiblockShapeInfo(blockInfos));
    }

    public void generatePattern() {
        int minX = Math.min(this.runtime.area.from.m_123341_(), this.runtime.area.to.m_123341_());
        int minY = Math.min(this.runtime.area.from.m_123342_(), this.runtime.area.to.m_123342_());
        int minZ = Math.min(this.runtime.area.from.m_123343_(), this.runtime.area.to.m_123343_());
        int maxX = Math.max(this.runtime.area.from.m_123341_(), this.runtime.area.to.m_123341_());
        int maxY = Math.max(this.runtime.area.from.m_123342_(), this.runtime.area.to.m_123342_());
        int maxZ = Math.max(this.runtime.area.from.m_123343_(), this.runtime.area.to.m_123343_());
        BlockPos controllerPos = new BlockPos(this.runtime.controllerOffset.x + minX, this.runtime.controllerOffset.y + minY, this.runtime.controllerOffset.z + minZ);
        Direction controllerFace = this.runtime.controllerFace;
        BlockPlaceholder[][][] blockPlaceholders = new BlockPlaceholder[maxX - minX + 1][maxY - minY + 1][maxZ - minZ + 1];
        boolean addNewResource = false;
        ClientLevel level = Minecraft.m_91087_().f_91073_;
        for (int x = minX; x <= maxX; ++x) {
            for (int y = minY; y <= maxY; ++y) {
                for (int z = minZ; z <= maxZ; ++z) {
                    BlockPlaceholder holder;
                    BlockPos blockPos = new BlockPos(x, y, z);
                    PredicateResource predicateResource = this.project.getPredicateResource();
                    if (blockPos.equals((Object)controllerPos)) {
                        holder = BlockPlaceholder.controller(predicateResource, new Either[0]).setFacing(controllerFace);
                    } else {
                        String id;
                        Block block = level.m_8055_(blockPos).m_60734_();
                        if (block instanceof LiquidBlock) {
                            LiquidBlock liquidBlock = (LiquidBlock)block;
                            Fluid fluid = liquidBlock.getFluid().m_5613_();
                            id = Optional.ofNullable(ForgeRegistries.FLUIDS.getKey((Object)fluid)).map(ResourceLocation::toString).orElse("any");
                            if (!predicateResource.hasBuiltinResource(id)) {
                                predicateResource.addBuiltinResource(id, new PredicateFluids(fluid));
                                addNewResource = true;
                            }
                        } else {
                            String string = id = block == Blocks.f_50016_ ? "any" : Optional.ofNullable(ForgeRegistries.BLOCKS.getKey((Object)block)).map(ResourceLocation::toString).orElse("any");
                            if (!predicateResource.hasBuiltinResource(id)) {
                                predicateResource.addBuiltinResource(id, new PredicateBlocks(block));
                                addNewResource = true;
                            }
                        }
                        holder = BlockPlaceholder.create(predicateResource, Either.left((Object)id));
                    }
                    blockPlaceholders[x - minX][y - minY][z - minZ] = holder;
                }
            }
        }
        if (addNewResource) {
            Editor.INSTANCE.getResourcePanel().rebuildResource(this.project.getPredicateResource().name());
        }
        this.project.setBlockPlaceholders(blockPlaceholders);
        this.patternPanel.onBlockPlaceholdersChanged();
    }

    protected void prepareButtonGroup() {
    }

    public void onPanelSelected() {
        Editor.INSTANCE.getConfigPanel().openConfigurator(MachineEditor.BASIC, (IConfigurable)this.runtime);
    }

    public void onPanelDeselected() {
        Editor.INSTANCE.getConfigPanel().clearAllConfigurators();
    }

    public boolean mouseReleased(double mouseX, double mouseY, int button) {
        if (this.isMouseOverElement(mouseX, mouseY)) {
            BlockPosFace hoverPosFace = this.scene.getHoverPosFace();
            BlockPosFace clickPosFace = this.scene.getClickPosFace();
            if (MultiblockAreaPanel.isShiftDown() && hoverPosFace != null && hoverPosFace.equals((Object)clickPosFace)) {
                BlockPos pos = hoverPosFace.pos;
                if (this.runtime.isFromClicked) {
                    this.runtime.setFrom(pos);
                } else {
                    this.runtime.setTo(pos);
                }
                this.runtime.isFromClicked = !this.runtime.isFromClicked;
            }
        }
        return super.mouseReleased(mouseX, mouseY, button);
    }

    private void renderAfterWorld(SceneWidget sceneWidget) {
        PoseStack poseStack = new PoseStack();
        RenderSystem.enableBlend();
        RenderSystem.disableDepthTest();
        RenderSystem.blendFunc((int)770, (int)771);
        Tesselator tessellator = Tesselator.m_85913_();
        BufferBuilder buffer = tessellator.m_85915_();
        RenderSystem.disableCull();
        int minX = Math.min(this.runtime.area.from.m_123341_(), this.runtime.area.to.m_123341_());
        int minY = Math.min(this.runtime.area.from.m_123342_(), this.runtime.area.to.m_123342_());
        int minZ = Math.min(this.runtime.area.from.m_123343_(), this.runtime.area.to.m_123343_());
        int maxX = Math.max(this.runtime.area.from.m_123341_(), this.runtime.area.to.m_123341_()) + 1;
        int maxY = Math.max(this.runtime.area.from.m_123342_(), this.runtime.area.to.m_123342_()) + 1;
        int maxZ = Math.max(this.runtime.area.from.m_123343_(), this.runtime.area.to.m_123343_()) + 1;
        RenderSystem.setShader(GameRenderer::m_172811_);
        buffer.m_166779_(VertexFormat.Mode.TRIANGLES, DefaultVertexFormat.f_85815_);
        int fromColor = -1895760128;
        int toColor = -1879113728;
        RenderBufferUtils.drawCubeFace((PoseStack)poseStack, (VertexConsumer)buffer, (float)minX, (float)minY, (float)minZ, (float)(minX + 1), (float)(minY + 1), (float)(minZ + 1), (float)ColorUtils.red((int)fromColor), (float)ColorUtils.green((int)fromColor), (float)ColorUtils.blue((int)fromColor), (float)0.2f, (boolean)false);
        RenderBufferUtils.drawCubeFace((PoseStack)poseStack, (VertexConsumer)buffer, (float)(maxX - 1), (float)(maxY - 1), (float)(maxZ - 1), (float)maxX, (float)maxY, (float)maxZ, (float)ColorUtils.red((int)toColor), (float)ColorUtils.green((int)toColor), (float)ColorUtils.blue((int)toColor), (float)0.2f, (boolean)false);
        int color = 0x2F0000FF;
        float r = ColorUtils.red((int)color);
        float g = ColorUtils.green((int)color);
        float b = ColorUtils.blue((int)color);
        float a = ColorUtils.alpha((int)color);
        BlockPos controllerPos = new BlockPos(this.runtime.controllerOffset.x + minX, this.runtime.controllerOffset.y + minY, this.runtime.controllerOffset.z + minZ);
        switch (this.runtime.controllerFace) {
            case UP: {
                RenderBufferUtils.drawCubeFace((PoseStack)poseStack, (VertexConsumer)buffer, (float)controllerPos.m_123341_(), (float)(controllerPos.m_123342_() + 1), (float)controllerPos.m_123343_(), (float)(controllerPos.m_123341_() + 1), (float)(controllerPos.m_123342_() + 1), (float)(controllerPos.m_123343_() + 1), (float)r, (float)g, (float)b, (float)a, (boolean)false);
                break;
            }
            case DOWN: {
                RenderBufferUtils.drawCubeFace((PoseStack)poseStack, (VertexConsumer)buffer, (float)controllerPos.m_123341_(), (float)controllerPos.m_123342_(), (float)controllerPos.m_123343_(), (float)(controllerPos.m_123341_() + 1), (float)controllerPos.m_123342_(), (float)(controllerPos.m_123343_() + 1), (float)r, (float)g, (float)b, (float)a, (boolean)false);
                break;
            }
            case NORTH: {
                RenderBufferUtils.drawCubeFace((PoseStack)poseStack, (VertexConsumer)buffer, (float)controllerPos.m_123341_(), (float)controllerPos.m_123342_(), (float)controllerPos.m_123343_(), (float)(controllerPos.m_123341_() + 1), (float)(controllerPos.m_123342_() + 1), (float)controllerPos.m_123343_(), (float)r, (float)g, (float)b, (float)a, (boolean)false);
                break;
            }
            case SOUTH: {
                RenderBufferUtils.drawCubeFace((PoseStack)poseStack, (VertexConsumer)buffer, (float)controllerPos.m_123341_(), (float)controllerPos.m_123342_(), (float)(controllerPos.m_123343_() + 1), (float)(controllerPos.m_123341_() + 1), (float)(controllerPos.m_123342_() + 1), (float)(controllerPos.m_123343_() + 1), (float)r, (float)g, (float)b, (float)a, (boolean)false);
                break;
            }
            case WEST: {
                RenderBufferUtils.drawCubeFace((PoseStack)poseStack, (VertexConsumer)buffer, (float)controllerPos.m_123341_(), (float)controllerPos.m_123342_(), (float)controllerPos.m_123343_(), (float)controllerPos.m_123341_(), (float)(controllerPos.m_123342_() + 1), (float)(controllerPos.m_123343_() + 1), (float)r, (float)g, (float)b, (float)a, (boolean)false);
                break;
            }
            case EAST: {
                RenderBufferUtils.drawCubeFace((PoseStack)poseStack, (VertexConsumer)buffer, (float)(controllerPos.m_123341_() + 1), (float)controllerPos.m_123342_(), (float)controllerPos.m_123343_(), (float)(controllerPos.m_123341_() + 1), (float)(controllerPos.m_123342_() + 1), (float)(controllerPos.m_123343_() + 1), (float)r, (float)g, (float)b, (float)a, (boolean)false);
            }
        }
        tessellator.m_85914_();
        RenderSystem.setShader(GameRenderer::m_172757_);
        buffer.m_166779_(VertexFormat.Mode.LINES, DefaultVertexFormat.f_166851_);
        RenderSystem.lineWidth((float)10.0f);
        color = -1;
        RenderBufferUtils.drawCubeFrame((PoseStack)poseStack, (VertexConsumer)buffer, (float)minX, (float)minY, (float)minZ, (float)maxX, (float)maxY, (float)maxZ, (float)ColorUtils.red((int)color), (float)ColorUtils.green((int)color), (float)ColorUtils.blue((int)color), (float)ColorUtils.alpha((int)color));
        color = -16733526;
        RenderBufferUtils.drawCubeFrame((PoseStack)poseStack, (VertexConsumer)buffer, (float)controllerPos.m_123341_(), (float)controllerPos.m_123342_(), (float)controllerPos.m_123343_(), (float)(controllerPos.m_123341_() + 1), (float)(controllerPos.m_123342_() + 1), (float)(controllerPos.m_123343_() + 1), (float)ColorUtils.red((int)color), (float)ColorUtils.green((int)color), (float)ColorUtils.blue((int)color), (float)ColorUtils.alpha((int)color));
        tessellator.m_85914_();
        RenderSystem.enableDepthTest();
        RenderSystem.enableCull();
    }

    public MultiblockMachineProject getProject() {
        return this.project;
    }

    public SceneEditorWidget getScene() {
        return this.scene;
    }

    public MultiblockPatternPanel getPatternPanel() {
        return this.patternPanel;
    }

    public class Runtime
    implements IConfigurable {
        @Configurable(name="editor.machine.multiblock.area_panel.sceneRadius", tips={"editor.machine.multiblock.area_panel.sceneRadius.tips"})
        @NumberRange(range={1.0, 50.0})
        private int sceneRadius = 5;
        @Configurable(name="editor.machine.multiblock.area_panel.area", tips={"editor.machine.multiblock.area_panel.area.tips"}, subConfigurable=true, canCollapse=false, collapse=false)
        private final Area area = new Area();
        @Configurable(name="editor.machine.multiblock.area_panel.controllerOffset", tips={"editor.machine.multiblock.area_panel.controllerOffset.tips"})
        @NumberRange(range={0.0, 2.147483647E9}, wheel=1.0)
        private Vector3i controllerOffset = new Vector3i(0, 0, 0);
        @Configurable(name="editor.machine.multiblock.area_panel.controllerFace", tips={"editor.machine.multiblock.area_panel.controllerFace.tips"})
        @ConfigSelector(candidate={"north", "south", "west", "east"})
        private Direction controllerFace = Direction.NORTH;
        private boolean isFromClicked = false;

        @ConfigSetter(field="sceneRadius")
        public void setSceneRadius(int radius) {
            this.sceneRadius = radius;
            MultiblockAreaPanel.this.reloadScene();
        }

        @ConfigSetter(field="controllerOffset")
        public void setControllerOffset(Vector3i offset) {
            int minX = Math.min(MultiblockAreaPanel.this.runtime.area.from.m_123341_(), MultiblockAreaPanel.this.runtime.area.to.m_123341_());
            int minY = Math.min(MultiblockAreaPanel.this.runtime.area.from.m_123342_(), MultiblockAreaPanel.this.runtime.area.to.m_123342_());
            int minZ = Math.min(MultiblockAreaPanel.this.runtime.area.from.m_123343_(), MultiblockAreaPanel.this.runtime.area.to.m_123343_());
            int maxX = Math.max(MultiblockAreaPanel.this.runtime.area.from.m_123341_(), MultiblockAreaPanel.this.runtime.area.to.m_123341_());
            int maxY = Math.max(MultiblockAreaPanel.this.runtime.area.from.m_123342_(), MultiblockAreaPanel.this.runtime.area.to.m_123342_());
            int maxZ = Math.max(MultiblockAreaPanel.this.runtime.area.from.m_123343_(), MultiblockAreaPanel.this.runtime.area.to.m_123343_());
            this.controllerOffset = new Vector3i(Mth.m_14045_((int)offset.x, (int)0, (int)(maxX - minX)), Mth.m_14045_((int)offset.y, (int)0, (int)(maxY - minY)), Mth.m_14045_((int)offset.z, (int)0, (int)(maxZ - minZ)));
        }

        @ConfigSetter(field="from")
        public void setFrom(BlockPos from) {
            this.area.from = from;
            this.setControllerOffset(this.controllerOffset);
        }

        @ConfigSetter(field="to")
        public void setTo(BlockPos to) {
            this.area.to = to;
            this.setControllerOffset(this.controllerOffset);
        }

        public void buildConfigurator(ConfiguratorGroup father) {
            super.buildConfigurator(father);
            WidgetGroup buttonGroup = new WidgetGroup(0, 0, 100, 22);
            buttonGroup.addWidget((Widget)new ButtonWidget(0, 0, 100, 10, (IGuiTexture)new GuiTextureGroup(new IGuiTexture[]{ColorPattern.T_GRAY.rectTexture().setRadius(5.0f), new TextTexture("editor.machine.multiblock.area_panel.generatePattern.button.0")}), cd -> {
                DialogWidget.showNotification((WidgetGroup)Editor.INSTANCE, (String)"editor.machine.multiblock.area_panel.generatePattern.button.0.title", (String)"editor.machine.multiblock.area_panel.generatePattern.button.0.info");
                MultiblockAreaPanel.this.generatePattern();
            }).setHoverTexture(new IGuiTexture[]{ColorPattern.WHITE.borderTexture(1).setRadius(5.0f), new TextTexture("editor.machine.multiblock.area_panel.generatePattern.button.0")}));
            buttonGroup.addWidget((Widget)new ButtonWidget(0, 12, 100, 10, (IGuiTexture)new GuiTextureGroup(new IGuiTexture[]{ColorPattern.T_GRAY.rectTexture().setRadius(5.0f), new TextTexture("editor.machine.multiblock.area_panel.generatePattern.button.1")}), cd -> {
                DialogWidget.showNotification((WidgetGroup)Editor.INSTANCE, (String)"editor.machine.multiblock.area_panel.generatePattern.button.1.title", (String)"editor.machine.multiblock.area_panel.generatePattern.button.1.info");
                MultiblockAreaPanel.this.generateShapeInfo();
            }).setHoverTexture(new IGuiTexture[]{ColorPattern.WHITE.borderTexture(1).setRadius(5.0f), new TextTexture("editor.machine.multiblock.area_panel.generatePattern.button.1")}));
            WrapperConfigurator wrapper = new WrapperConfigurator("editor.machine.multiblock.area_panel.generatePattern", (Widget)buttonGroup);
            wrapper.setTips(new String[]{"editor.machine.multiblock.area_panel.generatePattern.tips"});
            father.addConfigurators(new Configurator[]{wrapper});
        }

        public class Area
        implements IConfigurable {
            @Configurable(name="editor.machine.multiblock.area_panel.from", tips={"editor.machine.multiblock.area_panel.from.tips"})
            @NumberRange(range={-2.147483648E9, 2.147483647E9}, wheel=1.0)
            private BlockPos from;
            @Configurable(name="editor.machine.multiblock.area_panel.to", tips={"editor.machine.multiblock.area_panel.to.tips"})
            @NumberRange(range={-2.147483648E9, 2.147483647E9}, wheel=1.0)
            private BlockPos to;

            public Area() {
                this.from = Minecraft.m_91087_().f_91074_.m_20097_();
                this.to = Minecraft.m_91087_().f_91074_.m_20097_();
            }

            public void buildConfigurator(ConfiguratorGroup father) {
                super.buildConfigurator(father);
                father.addConfigurators(new Configurator[]{new WrapperConfigurator("", (Widget)new WidgetGroup(0, 0, 150, 5).addWidget((Widget)new ImageWidget(0, -10, 150, 10, (IGuiTexture)new TextTexture("editor.machine.multiblock.area_panel.area.tips"))))});
            }
        }
    }
}

