/*
 * Decompiled with CFR 0.152.
 */
package com.lowdragmc.mbd2.common.machine.definition.config;

import com.lowdragmc.lowdraglib.gui.editor.annotation.Configurable;
import com.lowdragmc.lowdraglib.gui.editor.annotation.NumberRange;
import com.lowdragmc.lowdraglib.gui.editor.configurator.IConfigurable;
import com.lowdragmc.lowdraglib.syncdata.IPersistedSerializable;
import com.lowdragmc.mbd2.common.trait.TraitDefinition;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import lombok.NonNull;
import net.minecraft.core.Direction;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.ListTag;
import net.minecraft.nbt.Tag;

public class ConfigMachineSettings
implements IPersistedSerializable,
IConfigurable {
    @Configurable(name="config.machine_settings.machine_level", tips={"config.machine_settings.machine_level.tooltip"})
    @NumberRange(range={0.0, 2.147483647E9})
    private int machineLevel;
    @Configurable(name="config.machine_settings.has_ui", tips={"config.machine_settings.has_ui.tooltip"})
    private boolean hasUI;
    @Configurable(name="config.machine_settings.drop_machine_item", tips={"config.machine_settings.drop_machine_item.tooltip.0", "config.machine_settings.drop_machine_item.tooltip.1", "config.machine_settings.drop_machine_item.tooltip.2"})
    private boolean dropMachineItem;
    @Configurable(name="config.machine_settings.signal_connection", subConfigurable=true, tips={"config.machine_settings.signal_connection.tooltip.0", "config.machine_settings.signal_connection.tooltip.1"})
    private final SignalConnection signalConnection;
    @NonNull
    private List<TraitDefinition> traitDefinitions;

    public CompoundTag serializeNBT() {
        CompoundTag tag = super.serializeNBT();
        ListTag traits = new ListTag();
        for (TraitDefinition definition : this.traitDefinitions) {
            traits.add((Object)TraitDefinition.serializeDefinition(definition));
        }
        tag.m_128365_("traitDefinitions", (Tag)traits);
        return tag;
    }

    public void deserializeNBT(CompoundTag tag) {
        super.deserializeNBT(tag);
        ListTag traits = tag.m_128437_("traitDefinitions", 10);
        this.traitDefinitions = new ArrayList<TraitDefinition>();
        for (int i = 0; i < traits.size(); ++i) {
            CompoundTag trait = traits.m_128728_(i);
            TraitDefinition definition = TraitDefinition.deserializeDefinition(trait);
            if (definition == null) continue;
            this.traitDefinitions.add(definition);
        }
    }

    public void addTraitDefinition(TraitDefinition definition) {
        this.traitDefinitions = new ArrayList<TraitDefinition>(this.traitDefinitions);
        this.traitDefinitions.add(definition);
    }

    public void removeTraitDefinition(TraitDefinition definition) {
        this.traitDefinitions = this.traitDefinitions.stream().filter(s -> s != definition).toList();
    }

    private static int $default$machineLevel() {
        return 0;
    }

    private static boolean $default$hasUI() {
        return true;
    }

    private static boolean $default$dropMachineItem() {
        return true;
    }

    private static SignalConnection $default$signalConnection() {
        return new SignalConnection();
    }

    ConfigMachineSettings(int machineLevel, boolean hasUI, boolean dropMachineItem, SignalConnection signalConnection, @NonNull List<TraitDefinition> traitDefinitions) {
        if (traitDefinitions == null) {
            throw new NullPointerException("traitDefinitions is marked non-null but is null");
        }
        this.machineLevel = machineLevel;
        this.hasUI = hasUI;
        this.dropMachineItem = dropMachineItem;
        this.signalConnection = signalConnection;
        this.traitDefinitions = traitDefinitions;
    }

    public static ConfigMachineSettingsBuilder builder() {
        return new ConfigMachineSettingsBuilder();
    }

    public int machineLevel() {
        return this.machineLevel;
    }

    public boolean hasUI() {
        return this.hasUI;
    }

    public boolean dropMachineItem() {
        return this.dropMachineItem;
    }

    public SignalConnection signalConnection() {
        return this.signalConnection;
    }

    @NonNull
    public List<TraitDefinition> traitDefinitions() {
        return this.traitDefinitions;
    }

    public static class SignalConnection {
        @Configurable(name="config.machine_settings.signal_connection.front")
        private boolean frontConnection = false;
        @Configurable(name="config.machine_settings.signal_connection.back")
        private boolean backConnection = false;
        @Configurable(name="config.machine_settings.signal_connection.left")
        private boolean leftConnection = false;
        @Configurable(name="config.machine_settings.signal_connection.right")
        private boolean rightConnection = false;
        @Configurable(name="config.machine_settings.signal_connection.top")
        private boolean topConnection = false;
        @Configurable(name="config.machine_settings.signal_connection.bottom")
        private boolean bottomConnection = false;

        public boolean getConnection(Direction front, Direction side) {
            if (side == Direction.UP) {
                return this.topConnection;
            }
            if (side == Direction.DOWN) {
                return this.bottomConnection;
            }
            if (side == front) {
                return this.frontConnection;
            }
            if (side == front.m_122424_()) {
                return this.backConnection;
            }
            if (side == front.m_122427_()) {
                return this.rightConnection;
            }
            if (side == front.m_122428_()) {
                return this.leftConnection;
            }
            return false;
        }

        public boolean frontConnection() {
            return this.frontConnection;
        }

        public boolean backConnection() {
            return this.backConnection;
        }

        public boolean leftConnection() {
            return this.leftConnection;
        }

        public boolean rightConnection() {
            return this.rightConnection;
        }

        public boolean topConnection() {
            return this.topConnection;
        }

        public boolean bottomConnection() {
            return this.bottomConnection;
        }

        public SignalConnection frontConnection(boolean frontConnection) {
            this.frontConnection = frontConnection;
            return this;
        }

        public SignalConnection backConnection(boolean backConnection) {
            this.backConnection = backConnection;
            return this;
        }

        public SignalConnection leftConnection(boolean leftConnection) {
            this.leftConnection = leftConnection;
            return this;
        }

        public SignalConnection rightConnection(boolean rightConnection) {
            this.rightConnection = rightConnection;
            return this;
        }

        public SignalConnection topConnection(boolean topConnection) {
            this.topConnection = topConnection;
            return this;
        }

        public SignalConnection bottomConnection(boolean bottomConnection) {
            this.bottomConnection = bottomConnection;
            return this;
        }
    }

    public static class ConfigMachineSettingsBuilder {
        private boolean machineLevel$set;
        private int machineLevel$value;
        private boolean hasUI$set;
        private boolean hasUI$value;
        private boolean dropMachineItem$set;
        private boolean dropMachineItem$value;
        private boolean signalConnection$set;
        private SignalConnection signalConnection$value;
        private ArrayList<TraitDefinition> traitDefinitions;

        ConfigMachineSettingsBuilder() {
        }

        public ConfigMachineSettingsBuilder machineLevel(int machineLevel) {
            this.machineLevel$value = machineLevel;
            this.machineLevel$set = true;
            return this;
        }

        public ConfigMachineSettingsBuilder hasUI(boolean hasUI) {
            this.hasUI$value = hasUI;
            this.hasUI$set = true;
            return this;
        }

        public ConfigMachineSettingsBuilder dropMachineItem(boolean dropMachineItem) {
            this.dropMachineItem$value = dropMachineItem;
            this.dropMachineItem$set = true;
            return this;
        }

        public ConfigMachineSettingsBuilder signalConnection(SignalConnection signalConnection) {
            this.signalConnection$value = signalConnection;
            this.signalConnection$set = true;
            return this;
        }

        public ConfigMachineSettingsBuilder traitDefinition(TraitDefinition traitDefinition) {
            if (this.traitDefinitions == null) {
                this.traitDefinitions = new ArrayList();
            }
            this.traitDefinitions.add(traitDefinition);
            return this;
        }

        public ConfigMachineSettingsBuilder traitDefinitions(Collection<? extends TraitDefinition> traitDefinitions) {
            if (traitDefinitions == null) {
                throw new NullPointerException("traitDefinitions cannot be null");
            }
            if (this.traitDefinitions == null) {
                this.traitDefinitions = new ArrayList();
            }
            this.traitDefinitions.addAll(traitDefinitions);
            return this;
        }

        public ConfigMachineSettingsBuilder clearTraitDefinitions() {
            if (this.traitDefinitions != null) {
                this.traitDefinitions.clear();
            }
            return this;
        }

        public ConfigMachineSettings build() {
            List<TraitDefinition> traitDefinitions = switch (this.traitDefinitions == null ? 0 : this.traitDefinitions.size()) {
                case 0 -> Collections.emptyList();
                case 1 -> Collections.singletonList(this.traitDefinitions.get(0));
                default -> Collections.unmodifiableList(new ArrayList<TraitDefinition>(this.traitDefinitions));
            };
            int machineLevel$value = this.machineLevel$value;
            if (!this.machineLevel$set) {
                machineLevel$value = ConfigMachineSettings.$default$machineLevel();
            }
            boolean hasUI$value = this.hasUI$value;
            if (!this.hasUI$set) {
                hasUI$value = ConfigMachineSettings.$default$hasUI();
            }
            boolean dropMachineItem$value = this.dropMachineItem$value;
            if (!this.dropMachineItem$set) {
                dropMachineItem$value = ConfigMachineSettings.$default$dropMachineItem();
            }
            SignalConnection signalConnection$value = this.signalConnection$value;
            if (!this.signalConnection$set) {
                signalConnection$value = ConfigMachineSettings.$default$signalConnection();
            }
            return new ConfigMachineSettings(machineLevel$value, hasUI$value, dropMachineItem$value, signalConnection$value, traitDefinitions);
        }

        public String toString() {
            return "ConfigMachineSettings.ConfigMachineSettingsBuilder(machineLevel$value=" + this.machineLevel$value + ", hasUI$value=" + this.hasUI$value + ", dropMachineItem$value=" + this.dropMachineItem$value + ", signalConnection$value=" + String.valueOf(this.signalConnection$value) + ", traitDefinitions=" + String.valueOf(this.traitDefinitions) + ")";
        }
    }
}

