/*
 * Decompiled with CFR 0.152.
 */
package com.lowdragmc.mbd2.common.machine.definition.config.event;

import com.lowdragmc.lowdraglib.gui.editor.annotation.LDLRegister;
import com.lowdragmc.lowdraglib.gui.graphprocessor.data.parameter.ExposedParameter;
import com.lowdragmc.mbd2.common.graphprocessor.GraphParameterGet;
import com.lowdragmc.mbd2.common.graphprocessor.GraphParameterSet;
import com.lowdragmc.mbd2.common.machine.MBDMachine;
import com.lowdragmc.mbd2.common.machine.definition.config.event.MachineEvent;
import java.util.Map;
import java.util.Optional;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.InteractionResult;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.phys.BlockHitResult;

@LDLRegister(name="MachineRightClickEvent", group="MachineEvent")
public class MachineRightClickEvent
extends MachineEvent {
    @GraphParameterGet
    public final Player player;
    @GraphParameterGet
    public final ItemStack heldItem;
    @GraphParameterGet
    public final InteractionHand hand;
    @GraphParameterGet
    public final BlockHitResult hit;
    @GraphParameterSet(displayName="interaction result", type=Boolean.class)
    public InteractionResult interactionResult;

    public MachineRightClickEvent(MBDMachine machine, Player player, InteractionHand hand, BlockHitResult hit) {
        super(machine);
        this.player = player;
        this.heldItem = player.m_21120_(hand);
        this.hand = hand;
        this.hit = hit;
    }

    @Override
    public void bindParameters(Map<String, ExposedParameter> exposedParameters) {
        super.bindParameters(exposedParameters);
        Optional.ofNullable(exposedParameters.get("player")).ifPresent(p -> p.setValue((Object)this.player));
        Optional.ofNullable(exposedParameters.get("hand")).ifPresent(p -> p.setValue((Object)this.hand));
        Optional.ofNullable(exposedParameters.get("hit")).ifPresent(p -> p.setValue((Object)this.hit));
    }

    @Override
    public void gatherParameters(Map<String, ExposedParameter> exposedParameters) {
        super.gatherParameters(exposedParameters);
        Optional.ofNullable(exposedParameters.get("interactionResult")).ifPresent(p -> {
            Object patt2223$temp = p.getValue();
            if (patt2223$temp instanceof Boolean) {
                Boolean result = (Boolean)patt2223$temp;
                this.interactionResult = result != false ? InteractionResult.SUCCESS : InteractionResult.PASS;
            }
        });
    }

    public Player getPlayer() {
        return this.player;
    }

    public ItemStack getHeldItem() {
        return this.heldItem;
    }

    public InteractionHand getHand() {
        return this.hand;
    }

    public BlockHitResult getHit() {
        return this.hit;
    }

    public InteractionResult getInteractionResult() {
        return this.interactionResult;
    }

    public void setInteractionResult(InteractionResult interactionResult) {
        this.interactionResult = interactionResult;
    }
}

