/*
 * Decompiled with CFR 0.152.
 */
package com.lowdragmc.mbd2.common.trait.entity;

import com.lowdragmc.lowdraglib.syncdata.field.ManagedFieldHolder;
import com.lowdragmc.mbd2.api.capability.recipe.IO;
import com.lowdragmc.mbd2.api.capability.recipe.IRecipeHandlerTrait;
import com.lowdragmc.mbd2.api.recipe.MBDRecipe;
import com.lowdragmc.mbd2.api.recipe.ingredient.EntityIngredient;
import com.lowdragmc.mbd2.common.capability.recipe.EntityRecipeCapability;
import com.lowdragmc.mbd2.common.machine.MBDMachine;
import com.lowdragmc.mbd2.common.trait.RecipeCapabilityTrait;
import com.lowdragmc.mbd2.common.trait.RecipeHandlerTrait;
import com.lowdragmc.mbd2.common.trait.entity.EntityHandlerTraitDefinition;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Set;
import java.util.concurrent.locks.Lock;
import java.util.concurrent.locks.ReentrantLock;
import java.util.stream.Collectors;
import net.minecraft.core.BlockPos;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.MobSpawnType;
import net.minecraft.world.level.Level;
import net.minecraft.world.phys.AABB;
import net.minecraft.world.phys.Vec3;
import org.jetbrains.annotations.Nullable;

public class EntityHandlerTrait
extends RecipeCapabilityTrait {
    public static final ManagedFieldHolder MANAGED_FIELD_HOLDER = new ManagedFieldHolder(EntityHandlerTrait.class);
    private final List<Entity> entities = new ArrayList<Entity>();
    private final Lock entitiesLock = new ReentrantLock();
    private final EntityRecipeHandler handler = new EntityRecipeHandler();

    public ManagedFieldHolder getFieldHolder() {
        return MANAGED_FIELD_HOLDER;
    }

    public EntityHandlerTrait(MBDMachine machine, EntityHandlerTraitDefinition definition) {
        super(machine, definition);
    }

    @Override
    public EntityHandlerTraitDefinition getDefinition() {
        return (EntityHandlerTraitDefinition)super.getDefinition();
    }

    @Override
    public void serverTick() {
        if (this.getHandlerIO() == IO.IN && this.getMachine().getOffsetTimer() % 20L == 0L && this.entitiesLock.tryLock()) {
            AABB area = this.getDefinition().getArea(this.getMachine().getFrontFacing().orElse(null));
            area = area.m_82338_(this.getMachine().getPos());
            List detected = this.getMachine().getLevel().m_6249_((Entity)null, area, Entity::m_6084_);
            if (detected.size() != this.entities.size() || !new HashSet(detected).containsAll(this.entities)) {
                this.entities.clear();
                this.entities.addAll(detected);
                this.notifyListeners();
            }
            this.entitiesLock.unlock();
        }
    }

    @Override
    public List<IRecipeHandlerTrait<?>> getRecipeHandlerTraits() {
        return List.of(this.handler);
    }

    public class EntityRecipeHandler
    extends RecipeHandlerTrait<EntityIngredient> {
        protected EntityRecipeHandler() {
            super(EntityHandlerTrait.this, EntityRecipeCapability.CAP);
        }

        @Override
        public List<EntityIngredient> handleRecipeInner(IO io, MBDRecipe recipe, List<EntityIngredient> left, @Nullable String slotName, boolean simulate) {
            if (!this.compatibleWith(io)) {
                return left;
            }
            if (io == IO.OUT) {
                Level level;
                if (!simulate && (level = EntityHandlerTrait.this.getMachine().getLevel()) instanceof ServerLevel) {
                    ServerLevel serverLevel = (ServerLevel)level;
                    AABB area = EntityHandlerTrait.this.getDefinition().getArea(EntityHandlerTrait.this.getMachine().getFrontFacing().orElse(null));
                    area = area.m_82338_(EntityHandlerTrait.this.getMachine().getPos());
                    for (EntityIngredient entityIngredient : left) {
                        for (EntityType<?> type : entityIngredient.getTypes()) {
                            Vec3 pos = new Vec3(area.f_82288_ + Math.random() * area.m_82362_(), area.f_82289_ + Math.random() * area.m_82376_(), area.f_82290_ + Math.random() * area.m_82385_());
                            Entity entity2 = type.m_262496_(serverLevel, new BlockPos((int)pos.f_82479_, (int)pos.f_82480_, (int)pos.f_82481_), MobSpawnType.SPAWNER);
                            if (entity2 == null) continue;
                            if (entityIngredient.getNbt() != null) {
                                CompoundTag tag = entity2.serializeNBT();
                                tag.m_128391_(entityIngredient.getNbt());
                                entity2.m_20258_(tag);
                            }
                            entity2.m_20219_(pos);
                        }
                    }
                }
                return null;
            }
            if (io == IO.IN) {
                EntityHandlerTrait.this.entitiesLock.lock();
                List<Entity> entityList = simulate ? new ArrayList<Entity>(EntityHandlerTrait.this.entities) : EntityHandlerTrait.this.entities;
                EntityHandlerTrait.this.entitiesLock.unlock();
                Iterator<EntityIngredient> iterator = left.iterator();
                while (iterator.hasNext()) {
                    EntityIngredient ingredient = iterator.next();
                    Set types = Arrays.stream(ingredient.getTypes()).collect(Collectors.toSet());
                    ArrayList<Entity> toKilled = new ArrayList<Entity>();
                    int matchCount = 0;
                    for (Entity entity3 : entityList) {
                        CompoundTag held;
                        CompoundTag nbt;
                        if (matchCount >= ingredient.getCount()) break;
                        if (!entity3.m_6084_() || !types.contains(entity3.m_6095_()) || (nbt = ingredient.getNbt()) != null && !nbt.m_128456_() && !(held = entity3.serializeNBT()).m_6426_().m_128391_(nbt).equals((Object)held)) continue;
                        ++matchCount;
                        toKilled.add(entity3);
                    }
                    ingredient.setCount(ingredient.getCount() - matchCount);
                    if (ingredient.getCount() <= 0) {
                        iterator.remove();
                    }
                    if (!simulate) {
                        toKilled.forEach(entity -> entity.m_142687_(Entity.RemovalReason.DISCARDED));
                    }
                    entityList.removeAll(toKilled);
                }
            }
            return left.isEmpty() ? null : left;
        }
    }
}

