/*
 * Decompiled with CFR 0.152.
 */
package com.lowdragmc.mbd2.common.trait.fluid;

import com.lowdragmc.lowdraglib.gui.editor.annotation.Configurable;
import com.lowdragmc.lowdraglib.gui.editor.annotation.DefaultValue;
import com.lowdragmc.lowdraglib.gui.editor.configurator.IToggleConfigurable;
import com.lowdragmc.lowdraglib.side.fluid.FluidStack;
import com.lowdragmc.lowdraglib.syncdata.annotation.Persisted;
import com.lowdragmc.mbd2.utils.TagUtil;
import java.util.ArrayList;
import java.util.List;
import java.util.function.Predicate;
import net.minecraft.resources.ResourceLocation;
import net.minecraftforge.registries.ForgeRegistries;

public class FluidFilterSettings
implements IToggleConfigurable,
Predicate<FluidStack> {
    @Persisted
    private boolean enable;
    @Configurable(name="config.definition.trait.filter.whitelist")
    private boolean isWhitelist = true;
    @Configurable(name="config.definition.trait.filter.match_nbt")
    private boolean matchNBT = false;
    @Configurable(name="config.definition.trait.filter.fluids")
    private List<FluidStack> filterFluids = new ArrayList<FluidStack>();
    @Configurable(name="config.definition.trait.filter.fluid_tags", forceUpdate=false)
    @DefaultValue(stringValue={"forge:gaseous"})
    private List<ResourceLocation> filterTags = new ArrayList<ResourceLocation>();

    @Override
    public boolean test(FluidStack fluidStack) {
        if (!this.enable) {
            return true;
        }
        for (FluidStack filterFluids : this.filterFluids) {
            if (!(this.matchNBT ? filterFluids.isFluidEqual(fluidStack) : filterFluids.getFluid() == fluidStack.getFluid())) continue;
            return this.isWhitelist;
        }
        for (ResourceLocation filterTag : this.filterTags) {
            if (!fluidStack.getFluid().m_205067_(TagUtil.optionalTag(ForgeRegistries.FLUIDS.getRegistryKey(), filterTag))) continue;
            return this.isWhitelist;
        }
        return !this.isWhitelist;
    }

    public boolean isEnable() {
        return this.enable;
    }

    public void setEnable(boolean enable) {
        this.enable = enable;
    }

    public boolean isWhitelist() {
        return this.isWhitelist;
    }

    public void setWhitelist(boolean isWhitelist) {
        this.isWhitelist = isWhitelist;
    }

    public boolean isMatchNBT() {
        return this.matchNBT;
    }

    public void setMatchNBT(boolean matchNBT) {
        this.matchNBT = matchNBT;
    }

    public List<FluidStack> getFilterFluids() {
        return this.filterFluids;
    }

    public void setFilterFluids(List<FluidStack> filterFluids) {
        this.filterFluids = filterFluids;
    }

    public List<ResourceLocation> getFilterTags() {
        return this.filterTags;
    }

    public void setFilterTags(List<ResourceLocation> filterTags) {
        this.filterTags = filterTags;
    }
}

