/*
 * Decompiled with CFR 0.152.
 */
package com.lowdragmc.mbd2.common.trait.forgeenergy;

import com.lowdragmc.lowdraglib.client.renderer.IRenderer;
import com.lowdragmc.lowdraglib.gui.editor.annotation.Configurable;
import com.lowdragmc.lowdraglib.gui.editor.annotation.LDLRegister;
import com.lowdragmc.lowdraglib.gui.editor.annotation.NumberRange;
import com.lowdragmc.lowdraglib.gui.texture.IGuiTexture;
import com.lowdragmc.lowdraglib.gui.texture.ProgressTexture;
import com.lowdragmc.lowdraglib.gui.texture.ResourceTexture;
import com.lowdragmc.lowdraglib.gui.widget.ProgressWidget;
import com.lowdragmc.lowdraglib.gui.widget.TextTextureWidget;
import com.lowdragmc.lowdraglib.gui.widget.Widget;
import com.lowdragmc.lowdraglib.gui.widget.WidgetGroup;
import com.lowdragmc.lowdraglib.utils.LocalizationUtils;
import com.lowdragmc.mbd2.api.machine.IMachine;
import com.lowdragmc.mbd2.common.capability.recipe.ForgeEnergyRecipeCapability;
import com.lowdragmc.mbd2.common.machine.MBDMachine;
import com.lowdragmc.mbd2.common.trait.ITrait;
import com.lowdragmc.mbd2.common.trait.SimpleCapabilityTrait;
import com.lowdragmc.mbd2.common.trait.SimpleCapabilityTraitDefinition;
import com.lowdragmc.mbd2.common.trait.ToggleAutoIO;
import com.lowdragmc.mbd2.common.trait.forgeenergy.ForgeEnergyCapabilityTrait;
import com.lowdragmc.mbd2.common.trait.forgeenergy.ForgeEnergyFancyRendererSettings;
import com.lowdragmc.mbd2.utils.EnergyFormattingUtil;
import com.lowdragmc.mbd2.utils.WidgetUtils;
import net.minecraft.network.chat.Component;

@LDLRegister(name="forge_energy_storage", group="trait", priority=-100)
public class ForgeEnergyCapabilityTraitDefinition
extends SimpleCapabilityTraitDefinition {
    @Configurable(name="config.definition.trait.forge_energy_storage.capacity")
    @NumberRange(range={1.0, 2.147483647E9})
    private int capacity = 5000;
    @Configurable(name="config.definition.trait.forge_energy_storage.max_receive", tips={"config.definition.trait.forge_energy_storage.max_receive.tooltip"})
    @NumberRange(range={0.0, 2.147483647E9})
    private int maxReceive = 5000;
    @Configurable(name="config.definition.trait.forge_energy_storage.max_extract", tips={"config.definition.trait.forge_energy_storage.max_extract.tooltip"})
    @NumberRange(range={0.0, 2.147483647E9})
    private int maxExtract = 5000;
    @Configurable(name="config.definition.trait.auto_io", subConfigurable=true, tips={"config.definition.trait.forge_energy_storage.auto_io.tooltip"})
    private final ToggleAutoIO autoIO = new ToggleAutoIO();
    @Configurable(name="config.definition.trait.forge_energy_storage.fancy_renderer", subConfigurable=true, tips={"config.definition.trait.forge_energy_storage.fancy_renderer.tooltip"})
    private final ForgeEnergyFancyRendererSettings fancyRendererSettings = new ForgeEnergyFancyRendererSettings(this);

    @Override
    public SimpleCapabilityTrait createTrait(MBDMachine machine) {
        return new ForgeEnergyCapabilityTrait(machine, this);
    }

    @Override
    public IGuiTexture getIcon() {
        return new ResourceTexture("mbd2:textures/gui/forge_energy.png");
    }

    @Override
    public IRenderer getBESRenderer(IMachine machine) {
        return this.fancyRendererSettings.getFancyRenderer(machine);
    }

    @Override
    public void createTraitUITemplate(WidgetGroup ui) {
        String prefix = this.uiPrefixName();
        ProgressWidget energyBar = new ProgressWidget(ProgressWidget.JEIProgress, 0, 0, 100, 14, new ProgressTexture(IGuiTexture.EMPTY, (IGuiTexture)ForgeEnergyRecipeCapability.ENERGY_BAR));
        energyBar.setBackground(new IGuiTexture[]{ForgeEnergyRecipeCapability.ENERGY_BASE});
        energyBar.setId(prefix);
        TextTextureWidget energyBarText = new TextTextureWidget(5, 2, 90, 10).setText("0/0 FE").textureStyle(textTexture -> textTexture.setDropShadow(true));
        energyBarText.setId(prefix + "_text");
        ui.addWidget((Widget)energyBar);
        ui.addWidget((Widget)energyBarText);
    }

    @Override
    public void initTraitUI(ITrait trait, WidgetGroup group) {
        if (trait instanceof ForgeEnergyCapabilityTrait) {
            ForgeEnergyCapabilityTrait forgeEnergyTrait = (ForgeEnergyCapabilityTrait)trait;
            String prefix = this.uiPrefixName();
            WidgetUtils.widgetByIdForEach(group, "^%s$".formatted(prefix), ProgressWidget.class, energyBar -> {
                energyBar.setProgressSupplier(() -> (double)forgeEnergyTrait.storage.getEnergyStored() * 1.0 / (double)forgeEnergyTrait.storage.getMaxEnergyStored());
                energyBar.setDynamicHoverTips(value -> {
                    String stored = EnergyFormattingUtil.formatExtended(Math.round((double)forgeEnergyTrait.storage.getMaxEnergyStored() * value));
                    String maxStored = EnergyFormattingUtil.formatExtended(forgeEnergyTrait.storage.getMaxEnergyStored());
                    return LocalizationUtils.format((String)"config.definition.trait.forge_energy_storage.ui_container_hover", (Object[])new Object[]{stored, maxStored});
                });
            });
            WidgetUtils.widgetByIdForEach(group, "^%s_text$".formatted(prefix), TextTextureWidget.class, energyBarText -> energyBarText.setText(() -> {
                String stored = EnergyFormattingUtil.formatCompact(forgeEnergyTrait.storage.getEnergyStored()) + "FE";
                String maxStored = EnergyFormattingUtil.formatCompact(forgeEnergyTrait.storage.getMaxEnergyStored()) + "FE";
                return Component.m_237113_((String)(stored + "/" + maxStored));
            }));
        }
    }

    public int getCapacity() {
        return this.capacity;
    }

    public void setCapacity(int capacity) {
        this.capacity = capacity;
    }

    public int getMaxReceive() {
        return this.maxReceive;
    }

    public void setMaxReceive(int maxReceive) {
        this.maxReceive = maxReceive;
    }

    public int getMaxExtract() {
        return this.maxExtract;
    }

    public void setMaxExtract(int maxExtract) {
        this.maxExtract = maxExtract;
    }

    public ToggleAutoIO getAutoIO() {
        return this.autoIO;
    }
}

