/*
 * Decompiled with CFR 0.152.
 */
package com.lowdragmc.mbd2.integration.botania.trait;

import java.util.Arrays;
import java.util.Optional;
import net.minecraft.core.BlockPos;
import net.minecraft.world.item.DyeColor;
import net.minecraft.world.level.Level;
import vazkii.botania.api.mana.ManaPool;
import vazkii.botania.api.mana.ManaReceiver;

public record ManaPoolList(ManaPool[] manaPools) implements ManaPool
{
    public Level getManaReceiverLevel() {
        return this.manaPools[0].getManaReceiverLevel();
    }

    public BlockPos getManaReceiverPos() {
        return this.manaPools[0].getManaReceiverPos();
    }

    public int getCurrentMana() {
        return Arrays.stream(this.manaPools).mapToInt(ManaReceiver::getCurrentMana).sum();
    }

    public boolean isFull() {
        return Arrays.stream(this.manaPools).allMatch(ManaReceiver::isFull);
    }

    public void receiveMana(int mana) {
        for (ManaPool receiver : this.manaPools) {
            if (receiver.isFull() || !receiver.canReceiveManaFromBursts()) continue;
            receiver.receiveMana(mana);
            return;
        }
    }

    public boolean canReceiveManaFromBursts() {
        return Arrays.stream(this.manaPools).anyMatch(ManaReceiver::canReceiveManaFromBursts);
    }

    public boolean isOutputtingPower() {
        return false;
    }

    public int getMaxMana() {
        return Arrays.stream(this.manaPools).mapToInt(ManaPool::getMaxMana).sum();
    }

    public Optional<DyeColor> getColor() {
        return Optional.empty();
    }

    public void setColor(Optional<DyeColor> color) {
    }
}

