/*
 * Decompiled with CFR 0.152.
 */
package com.lowdragmc.mbd2.integration.create.machine;

import com.lowdragmc.mbd2.api.block.RotationState;
import com.lowdragmc.mbd2.api.machine.IMachine;
import com.lowdragmc.mbd2.common.block.MBDMachineBlock;
import com.lowdragmc.mbd2.common.machine.MBDMachine;
import com.lowdragmc.mbd2.integration.create.machine.CreateKineticMachineDefinition;
import com.simibubi.create.content.kinetics.base.IRotate;
import com.simibubi.create.content.kinetics.base.KineticBlockEntity;
import com.simibubi.create.content.kinetics.base.RotatedPillarKineticBlock;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.world.item.context.BlockPlaceContext;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.LevelAccessor;
import net.minecraft.world.level.LevelReader;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.entity.BlockEntityTicker;
import net.minecraft.world.level.block.entity.BlockEntityType;
import net.minecraft.world.level.block.state.BlockBehaviour;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.properties.Property;
import org.jetbrains.annotations.Nullable;

public class MBDKineticMachineBlock
extends MBDMachineBlock
implements IRotate {
    public MBDKineticMachineBlock(BlockBehaviour.Properties properties, CreateKineticMachineDefinition definition) {
        super(properties, definition);
    }

    @Override
    public CreateKineticMachineDefinition getDefinition() {
        return (CreateKineticMachineDefinition)super.getDefinition();
    }

    public boolean hasShaftTowards(LevelReader world, BlockPos pos, BlockState state, Direction face) {
        return this.getDefinition().kineticMachineSettings().hasShaftTowards(face, this.getRotationFacing(state));
    }

    public Direction getRotationFacing(BlockState state) {
        return this.getDefinition().kineticMachineSettings().getRotationFacing(this.getFrontFacing(state).orElse(Direction.NORTH));
    }

    public Direction.Axis getRotationAxis(BlockState state) {
        return this.getRotationFacing(state).m_122434_();
    }

    public void m_6807_(BlockState state, Level level, BlockPos pos, BlockState oldState, boolean isMoving) {
        BlockEntity tileEntity = level.m_7702_(pos);
        if (tileEntity instanceof KineticBlockEntity) {
            KineticBlockEntity kineticTileEntity = (KineticBlockEntity)tileEntity;
            kineticTileEntity.preventSpeedUpdate = 0;
            if (oldState.m_60734_() != state.m_60734_()) {
                return;
            }
            if (state.m_155947_() != oldState.m_155947_()) {
                return;
            }
            if (!this.areStatesKineticallyEquivalent(oldState, state)) {
                return;
            }
            kineticTileEntity.preventSpeedUpdate = 2;
        }
    }

    @Override
    @Nullable
    public BlockState m_5573_(BlockPlaceContext context) {
        BlockState state = super.m_5573_(context);
        if (state == null) {
            return null;
        }
        Direction.Axis preferredAxis = RotatedPillarKineticBlock.getPreferredAxis((BlockPlaceContext)context);
        if (!(preferredAxis == null || context.m_43723_() != null && context.m_43723_().m_6144_())) {
            if (preferredAxis == this.getRotationAxis(state)) {
                return state;
            }
            RotationState rotationState = this.getRotationState();
            if (rotationState.property.isPresent()) {
                for (Direction value : Direction.values()) {
                    BlockState newState;
                    if (!rotationState.test(value) || this.getRotationAxis(newState = (BlockState)state.m_61124_((Property)rotationState.property.get(), (Comparable)value)) != preferredAxis) continue;
                    return newState;
                }
            }
        }
        return state;
    }

    public boolean areStatesKineticallyEquivalent(BlockState oldState, BlockState newState) {
        if (oldState.m_60734_() != newState.m_60734_()) {
            return false;
        }
        return this.getRotationAxis(newState) == this.getRotationAxis(oldState);
    }

    public void m_7742_(BlockState stateIn, LevelAccessor worldIn, BlockPos pos, int flags, int count) {
        if (worldIn.m_5776_()) {
            return;
        }
        BlockEntity tileEntity = worldIn.m_7702_(pos);
        if (!(tileEntity instanceof KineticBlockEntity)) {
            return;
        }
        KineticBlockEntity kte = (KineticBlockEntity)tileEntity;
        if (kte.preventSpeedUpdate > 0) {
            return;
        }
        kte.warnOfMovement();
        kte.clearKineticInformation();
        kte.updateSpeed = true;
    }

    @Override
    public <T extends BlockEntity> BlockEntityTicker<T> m_142354_(Level level, BlockState state, BlockEntityType<T> blockEntityType) {
        if (blockEntityType == this.getDefinition().blockEntityType()) {
            return (world, pos, state1, blockEntity) -> {
                IMachine.ofMachine(blockEntity).filter(MBDMachine.class::isInstance).map(MBDMachine.class::cast).ifPresent(machine -> {
                    if (world.f_46443_) {
                        machine.clientTick();
                    } else {
                        machine.serverTick();
                    }
                });
                if (blockEntity instanceof KineticBlockEntity) {
                    KineticBlockEntity kineticBlockEntity = (KineticBlockEntity)blockEntity;
                    kineticBlockEntity.tick();
                }
            };
        }
        return null;
    }
}

