/*
 * Decompiled with CFR 0.152.
 */
package com.lowdragmc.mbd2.integration.geckolib;

import com.lowdragmc.lowdraglib.gui.editor.annotation.Configurable;
import com.lowdragmc.lowdraglib.gui.editor.configurator.ArrayConfiguratorGroup;
import com.lowdragmc.lowdraglib.gui.editor.configurator.Configurator;
import com.lowdragmc.lowdraglib.gui.editor.configurator.ConfiguratorGroup;
import com.lowdragmc.lowdraglib.gui.editor.configurator.IConfigurable;
import com.lowdragmc.lowdraglib.syncdata.ITagSerializable;
import com.lowdragmc.mbd2.integration.geckolib.AnimationStage;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.ListTag;
import net.minecraft.nbt.Tag;
import software.bernie.geckolib.core.animation.RawAnimation;

public class Animation
implements IConfigurable,
ITagSerializable<CompoundTag> {
    @Configurable(name="geckolib_renderer.animation.animation_name", tips={"geckolib_renderer.animation.animation_name.tips"})
    private String name = "";
    private List<AnimationStage> stages = new ArrayList<AnimationStage>();

    public void buildConfigurator(ConfiguratorGroup father) {
        super.buildConfigurator(father);
        ArrayConfiguratorGroup stageConfigurator = new ArrayConfiguratorGroup("geckolib_renderer.animation_stages", false, () -> new ArrayList<AnimationStage>(this.stages), (getter, setter) -> {
            AnimationStage value = (AnimationStage)getter.get();
            ConfiguratorGroup group = new ConfiguratorGroup("geckolib_renderer.animation_stage", false);
            value.buildConfigurator(group);
            return group;
        }, true);
        stageConfigurator.setOnReorder((i, stage) -> {});
        stageConfigurator.setAddDefault(AnimationStage::new);
        stageConfigurator.setOnAdd(newStage -> this.stages.add((AnimationStage)newStage));
        stageConfigurator.setOnRemove(this.stages::remove);
        stageConfigurator.setOnUpdate(list -> {
            this.stages.clear();
            this.stages.addAll((Collection<AnimationStage>)list);
        });
        father.addConfigurators(new Configurator[]{stageConfigurator});
    }

    public RawAnimation toRawAnimation() {
        RawAnimation rawAnimation = RawAnimation.begin();
        for (AnimationStage stage : this.stages) {
            if (stage.isWait()) {
                rawAnimation.thenWait(stage.getAdditionalTicks());
                continue;
            }
            rawAnimation.then(stage.getAnimationName(), stage.getLoopType().type);
        }
        return rawAnimation;
    }

    public CompoundTag serializeNBT() {
        CompoundTag tag = new CompoundTag();
        tag.m_128359_("name", this.name);
        ListTag stages = new ListTag();
        for (AnimationStage stage : this.stages) {
            stages.add((Object)stage.serializeNBT());
        }
        tag.m_128365_("stages", (Tag)stages);
        return tag;
    }

    public void deserializeNBT(CompoundTag nbt) {
        this.name = nbt.m_128461_("name");
        this.stages.clear();
        ListTag stages = nbt.m_128437_("stages", 10);
        for (Tag stage : stages) {
            AnimationStage stageInstance = new AnimationStage();
            stageInstance.deserializeNBT((CompoundTag)stage);
            this.stages.add(stageInstance);
        }
    }

    public String getName() {
        return this.name;
    }

    public List<AnimationStage> getStages() {
        return this.stages;
    }

    public Animation setName(String name) {
        this.name = name;
        return this;
    }

    public Animation setStages(List<AnimationStage> stages) {
        this.stages = stages;
        return this;
    }
}

