/*
 * Decompiled with CFR 0.152.
 */
package com.lowdragmc.mbd2.integration.gtm.trait;

import com.gregtechceu.gtceu.common.data.GTItems;
import com.lowdragmc.lowdraglib.client.renderer.IRenderer;
import com.lowdragmc.lowdraglib.gui.editor.annotation.Configurable;
import com.lowdragmc.lowdraglib.gui.editor.annotation.LDLRegister;
import com.lowdragmc.lowdraglib.gui.editor.annotation.NumberRange;
import com.lowdragmc.lowdraglib.gui.texture.IGuiTexture;
import com.lowdragmc.lowdraglib.gui.texture.ItemStackTexture;
import com.lowdragmc.lowdraglib.gui.texture.ProgressTexture;
import com.lowdragmc.lowdraglib.gui.widget.ProgressWidget;
import com.lowdragmc.lowdraglib.gui.widget.TextTextureWidget;
import com.lowdragmc.lowdraglib.gui.widget.Widget;
import com.lowdragmc.lowdraglib.gui.widget.WidgetGroup;
import com.lowdragmc.lowdraglib.utils.LocalizationUtils;
import com.lowdragmc.mbd2.api.machine.IMachine;
import com.lowdragmc.mbd2.common.machine.MBDMachine;
import com.lowdragmc.mbd2.common.trait.ITrait;
import com.lowdragmc.mbd2.common.trait.SimpleCapabilityTrait;
import com.lowdragmc.mbd2.common.trait.SimpleCapabilityTraitDefinition;
import com.lowdragmc.mbd2.common.trait.ToggleAutoIO;
import com.lowdragmc.mbd2.integration.gtm.GTMEnergyRecipeCapability;
import com.lowdragmc.mbd2.integration.gtm.trait.GTMEnergyCapabilityTrait;
import com.lowdragmc.mbd2.integration.gtm.trait.GTMEnergyFancyRendererSettings;
import com.lowdragmc.mbd2.utils.WidgetUtils;
import net.minecraft.network.chat.Component;
import net.minecraft.world.item.Item;

@LDLRegister(name="gtm_energy_container", group="trait", modID="gtceu")
public class GTMEnergyCapabilityTraitDefinition
extends SimpleCapabilityTraitDefinition {
    @Configurable(name="config.definition.trait.gtm_energy_container.capacity")
    @NumberRange(range={1.0, 9.223372036854776E18})
    private long capacity = 5000L;
    @Configurable(name="config.definition.trait.gtm_energy_container.explosion_machine", tips={"config.definition.trait.gtm_energy_container.explosion_machine.tooltip"})
    private boolean explosionMachine = false;
    @Configurable(name="config.definition.trait.gtm_energy_container.input_voltage", tips={"config.definition.trait.gtm_energy_container.input_voltage.tooltip"})
    @NumberRange(range={0.0, 9.223372036854776E18})
    private long inputVoltage = 128L;
    @Configurable(name="config.definition.trait.gtm_energy_container.input_amperage", tips={"config.definition.trait.gtm_energy_container.input_amperage.tooltip"})
    @NumberRange(range={0.0, 9.223372036854776E18})
    private long inputAmperage = 1L;
    @Configurable(name="config.definition.trait.gtm_energy_container.output_voltage", tips={"config.definition.trait.gtm_energy_container.output_voltage.tooltip"})
    @NumberRange(range={0.0, 9.223372036854776E18})
    private long outputVoltage = 128L;
    @Configurable(name="config.definition.trait.gtm_energy_container.output_amperage", tips={"config.definition.trait.gtm_energy_container.output_amperage.tooltip"})
    @NumberRange(range={0.0, 9.223372036854776E18})
    private long outputAmperage = 1L;
    @Configurable(name="config.definition.trait.auto_io", subConfigurable=true, tips={"config.definition.trait.gtm_energy_container.auto_io.tooltip"})
    private final ToggleAutoIO autoIO = new ToggleAutoIO();
    @Configurable(name="config.definition.trait.gtm_energy_container.fancy_renderer", subConfigurable=true, tips={"config.definition.trait.gtm_energy_container.fancy_renderer.tooltip"})
    private final GTMEnergyFancyRendererSettings fancyRendererSettings = new GTMEnergyFancyRendererSettings(this);

    @Override
    public SimpleCapabilityTrait createTrait(MBDMachine machine) {
        return new GTMEnergyCapabilityTrait(machine, this);
    }

    @Override
    public IGuiTexture getIcon() {
        return new ItemStackTexture(new Item[]{GTItems.BATTERY_HV_SODIUM.m_5456_()});
    }

    @Override
    public IRenderer getBESRenderer(IMachine machine) {
        return this.fancyRendererSettings.getFancyRenderer(machine);
    }

    @Override
    public void createTraitUITemplate(WidgetGroup ui) {
        String prefix = this.uiPrefixName();
        ProgressWidget energyBar = new ProgressWidget(ProgressWidget.JEIProgress, 0, 0, 100, 15, new ProgressTexture(IGuiTexture.EMPTY, (IGuiTexture)GTMEnergyRecipeCapability.HUD_BAR));
        energyBar.setBackground(new IGuiTexture[]{GTMEnergyRecipeCapability.HUD_BACKGROUND});
        energyBar.setId(prefix);
        TextTextureWidget energyBarText = new TextTextureWidget(5, 3, 90, 10).setText("0/0 eu").textureStyle(textTexture -> textTexture.setDropShadow(true));
        energyBarText.setId(prefix + "_text");
        ui.addWidget((Widget)energyBar);
        ui.addWidget((Widget)energyBarText);
    }

    @Override
    public void initTraitUI(ITrait trait, WidgetGroup group) {
        if (trait instanceof GTMEnergyCapabilityTrait) {
            GTMEnergyCapabilityTrait energyTrait = (GTMEnergyCapabilityTrait)trait;
            String prefix = this.uiPrefixName();
            WidgetUtils.widgetByIdForEach(group, "^%s$".formatted(prefix), ProgressWidget.class, energyBar -> {
                energyBar.setProgressSupplier(() -> (double)energyTrait.container.getEnergyStored() * 1.0 / (double)energyTrait.container.getEnergyCapacity());
                energyBar.setDynamicHoverTips(value -> LocalizationUtils.format((String)"config.definition.trait.gtm_energy_container.ui_container_hover", (Object[])new Object[]{Math.round((double)energyTrait.container.getEnergyCapacity() * value), energyTrait.container.getEnergyCapacity()}));
            });
            WidgetUtils.widgetByIdForEach(group, "^%s_text$".formatted(prefix), TextTextureWidget.class, energyBarText -> energyBarText.setText(() -> Component.m_237113_((String)(energyTrait.container.getEnergyStored() + "/" + energyTrait.container.getEnergyCapacity() + " eu"))));
        }
    }

    public long getCapacity() {
        return this.capacity;
    }

    public void setCapacity(long capacity) {
        this.capacity = capacity;
    }

    public boolean isExplosionMachine() {
        return this.explosionMachine;
    }

    public void setExplosionMachine(boolean explosionMachine) {
        this.explosionMachine = explosionMachine;
    }

    public long getInputVoltage() {
        return this.inputVoltage;
    }

    public void setInputVoltage(long inputVoltage) {
        this.inputVoltage = inputVoltage;
    }

    public long getInputAmperage() {
        return this.inputAmperage;
    }

    public void setInputAmperage(long inputAmperage) {
        this.inputAmperage = inputAmperage;
    }

    public long getOutputVoltage() {
        return this.outputVoltage;
    }

    public void setOutputVoltage(long outputVoltage) {
        this.outputVoltage = outputVoltage;
    }

    public long getOutputAmperage() {
        return this.outputAmperage;
    }

    public void setOutputAmperage(long outputAmperage) {
        this.outputAmperage = outputAmperage;
    }

    public ToggleAutoIO getAutoIO() {
        return this.autoIO;
    }
}

