/*
 * Decompiled with CFR 0.152.
 */
package com.lowdragmc.mbd2.integration.mekanism.trait.heat;

import com.lowdragmc.lowdraglib.syncdata.IContentChangeAware;
import com.lowdragmc.lowdraglib.syncdata.ITagSerializable;
import mekanism.api.heat.IHeatHandler;
import net.minecraft.nbt.DoubleTag;
import net.minecraft.nbt.Tag;

public class CopiableHeatContainer
implements IHeatHandler,
ITagSerializable<Tag>,
IContentChangeAware {
    public Runnable onContentsChanged = () -> {};
    public final double capacity;
    public final double inverseConduction;
    public double heat;

    public CopiableHeatContainer(double capacity, double inverseConduction) {
        this.capacity = capacity;
        this.inverseConduction = Math.max(1.0, inverseConduction);
        this.heat = capacity * 300.0;
    }

    public CopiableHeatContainer copy() {
        CopiableHeatContainer copy = new CopiableHeatContainer(this.capacity, this.inverseConduction);
        copy.heat = this.heat;
        return copy;
    }

    public int getHeatCapacitorCount() {
        return 1;
    }

    public double getTemperature(int capacitor) {
        return capacitor == 0 ? this.heat / this.capacity : 0.0;
    }

    public double getInverseConduction(int capacitor) {
        return capacitor == 0 ? this.inverseConduction : 1.0;
    }

    public double getHeatCapacity(int capacitor) {
        return capacitor == 0 ? this.capacity : 0.0;
    }

    public void handleHeat(int capacitor, double transfer) {
        if (capacitor == 0 && transfer != 0.0) {
            this.heat += transfer;
            this.onContentsChanged.run();
        }
    }

    public Tag serializeNBT() {
        return DoubleTag.m_128500_((double)this.heat);
    }

    public void deserializeNBT(Tag nbt) {
        if (nbt instanceof DoubleTag) {
            DoubleTag tag = (DoubleTag)nbt;
            this.heat = tag.m_7061_();
        }
    }

    public Runnable getOnContentsChanged() {
        return this.onContentsChanged;
    }

    public void setOnContentsChanged(Runnable onContentsChanged) {
        this.onContentsChanged = onContentsChanged;
    }
}

