/*
 * Decompiled with CFR 0.152.
 */
package com.lowdragmc.mbd2.integration.pneumaticcraft;

import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import com.lowdragmc.mbd2.api.recipe.content.ContentModifier;
import com.lowdragmc.mbd2.api.recipe.content.IContentSerializer;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.Tag;
import net.minecraft.network.FriendlyByteBuf;
import net.minecraft.util.GsonHelper;

public record PressureAir(boolean isAir, float value) {

    public static class SerializerPressureAir
    implements IContentSerializer<PressureAir> {
        public static final IContentSerializer<PressureAir> INSTANCE = new SerializerPressureAir();

        @Override
        public PressureAir fromJson(JsonElement json) {
            boolean isAir = GsonHelper.m_13912_((JsonObject)json.getAsJsonObject(), (String)"isAir");
            float value = GsonHelper.m_13915_((JsonObject)json.getAsJsonObject(), (String)"value");
            return new PressureAir(isAir, value);
        }

        @Override
        public JsonElement toJson(PressureAir content) {
            JsonObject json = new JsonObject();
            json.addProperty("isAir", Boolean.valueOf(content.isAir));
            json.addProperty("value", (Number)Float.valueOf(content.value));
            return json;
        }

        @Override
        public Tag toNBT(PressureAir content) {
            CompoundTag tag = new CompoundTag();
            tag.m_128379_("isAir", content.isAir);
            tag.m_128350_("value", content.value);
            return tag;
        }

        @Override
        public PressureAir fromNBT(Tag nbt) {
            CompoundTag tag = (CompoundTag)nbt;
            return new PressureAir(tag.m_128471_("isAir"), tag.m_128457_("value"));
        }

        @Override
        public void toNetwork(FriendlyByteBuf buf, PressureAir content) {
            buf.writeBoolean(content.isAir);
            buf.writeFloat(content.value);
        }

        @Override
        public PressureAir fromNetwork(FriendlyByteBuf buf) {
            return new PressureAir(buf.readBoolean(), buf.readFloat());
        }

        @Override
        public PressureAir of(Object o) {
            String str;
            String[] splits;
            if (o instanceof PressureAir) {
                PressureAir pressureAir = (PressureAir)o;
                return pressureAir;
            }
            if (o instanceof Number) {
                Number number = (Number)o;
                return new PressureAir(false, number.floatValue());
            }
            if (o instanceof CharSequence && (splits = (str = o.toString()).split(":")).length == 2) {
                try {
                    boolean isAir = Boolean.parseBoolean(splits[0]);
                    float value = Float.parseFloat(splits[1]);
                    return new PressureAir(isAir, value);
                }
                catch (Exception exception) {
                    // empty catch block
                }
            }
            return new PressureAir(false, 0.0f);
        }

        @Override
        public PressureAir copyWithModifier(PressureAir content, ContentModifier modifier) {
            return new PressureAir(content.isAir, modifier.apply(Float.valueOf(content.value)).floatValue());
        }

        @Override
        public PressureAir copyInner(PressureAir content) {
            return new PressureAir(content.isAir, content.value);
        }

        @Override
        public PressureAir deepCopyInner(PressureAir content) {
            return new PressureAir(content.isAir, content.value);
        }
    }
}

