/*
 * Decompiled with CFR 0.152.
 */
package com.lowdragmc.mbd2.integration.pneumaticcraft.trait.heat;

import com.lowdragmc.lowdraglib.syncdata.annotation.DescSynced;
import com.lowdragmc.lowdraglib.syncdata.annotation.Persisted;
import com.lowdragmc.lowdraglib.syncdata.field.ManagedFieldHolder;
import com.lowdragmc.mbd2.api.capability.recipe.IO;
import com.lowdragmc.mbd2.api.capability.recipe.IRecipeHandlerTrait;
import com.lowdragmc.mbd2.api.recipe.MBDRecipe;
import com.lowdragmc.mbd2.api.recipe.RecipeCondition;
import com.lowdragmc.mbd2.common.machine.MBDMachine;
import com.lowdragmc.mbd2.common.trait.ICapabilityProviderTrait;
import com.lowdragmc.mbd2.common.trait.RecipeCapabilityTrait;
import com.lowdragmc.mbd2.common.trait.RecipeHandlerTrait;
import com.lowdragmc.mbd2.integration.pneumaticcraft.PNCHeatRecipeCapability;
import com.lowdragmc.mbd2.integration.pneumaticcraft.trait.heat.HeatExchanger;
import com.lowdragmc.mbd2.integration.pneumaticcraft.trait.heat.PNCHeatExchangerTraitDefinition;
import com.lowdragmc.mbd2.integration.pneumaticcraft.trait.heat.PNCTemperatureCondition;
import java.util.List;
import me.desht.pneumaticcraft.api.PNCCapabilities;
import me.desht.pneumaticcraft.api.heat.IHeatExchangerLogic;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.world.level.block.Block;
import net.minecraftforge.common.capabilities.Capability;
import org.jetbrains.annotations.Nullable;

public class PNCHeatExchangerTrait
extends RecipeCapabilityTrait {
    public static final ManagedFieldHolder MANAGED_FIELD_HOLDER = new ManagedFieldHolder(PNCHeatExchangerTrait.class);
    @Persisted
    @DescSynced
    public final HeatExchanger handler;
    private final HeatRecipeHandler heatRecipeHandler = new HeatRecipeHandler();
    private final HeatExchangerCap heatExchangerCap = new HeatExchangerCap();
    private boolean isFirstTick = true;

    public ManagedFieldHolder getFieldHolder() {
        return MANAGED_FIELD_HOLDER;
    }

    public PNCHeatExchangerTrait(MBDMachine machine, PNCHeatExchangerTraitDefinition definition) {
        super(machine, definition);
        this.handler = this.createHandler();
    }

    @Override
    public PNCHeatExchangerTraitDefinition getDefinition() {
        return (PNCHeatExchangerTraitDefinition)super.getDefinition();
    }

    @Override
    public void onLoadingTraitInPreview() {
        this.handler.setTemperatureWithoutNotify(100.0);
    }

    protected HeatExchanger createHandler() {
        HeatExchanger handler = new HeatExchanger();
        handler.setThermalCapacity(this.getDefinition().getThermalCapacity());
        handler.setThermalResistance(this.getDefinition().getThermalResistance());
        return handler;
    }

    @Override
    public void serverTick() {
        super.serverTick();
        if (this.isFirstTick) {
            this.handler.initializeAsHull(this.getMachine().getLevel(), this.getMachine().getPos(), IHeatExchangerLogic.ALL_BLOCKS, Direction.values());
            this.isFirstTick = false;
        }
        this.handler.tick();
    }

    @Override
    public void onNeighborChanged(Block block, BlockPos fromPos, boolean isMoving) {
        this.handler.initializeAsHull(this.getMachine().getLevel(), this.getMachine().getPos(), IHeatExchangerLogic.ALL_BLOCKS, Direction.values());
    }

    @Override
    public List<IRecipeHandlerTrait<?>> getRecipeHandlerTraits() {
        return List.of(this.heatRecipeHandler);
    }

    @Override
    public List<ICapabilityProviderTrait<?>> getCapabilityProviderTraits() {
        return List.of(this.heatExchangerCap);
    }

    public HeatExchanger getHandler() {
        return this.handler;
    }

    public HeatRecipeHandler getHeatRecipeHandler() {
        return this.heatRecipeHandler;
    }

    public HeatExchangerCap getHeatExchangerCap() {
        return this.heatExchangerCap;
    }

    public boolean isFirstTick() {
        return this.isFirstTick;
    }

    public class HeatRecipeHandler
    extends RecipeHandlerTrait<Double> {
        protected HeatRecipeHandler() {
            super(PNCHeatExchangerTrait.this, PNCHeatRecipeCapability.CAP);
        }

        @Override
        public List<Double> handleRecipeInner(IO io, MBDRecipe recipe, List<Double> left, @Nullable String slotName, boolean simulate) {
            if (!this.compatibleWith(io)) {
                return left;
            }
            double required = left.stream().reduce(0.0, Double::sum);
            double temp = PNCHeatExchangerTrait.this.handler.getTemperature();
            double cap = PNCHeatExchangerTrait.this.handler.getThermalCapacity();
            for (RecipeCondition condition : recipe.conditions) {
                PNCTemperatureCondition tempCondition;
                if (!(condition instanceof PNCTemperatureCondition) || !((double)(tempCondition = (PNCTemperatureCondition)condition).getMinTemperature() > temp - 273.0) && !((double)tempCondition.getMaxTemperature() < temp - 273.0)) continue;
                return left;
            }
            double requiredTemp = required / cap;
            if (io == IO.IN) {
                if (requiredTemp < temp) {
                    if (!simulate) {
                        PNCHeatExchangerTrait.this.handler.addHeat(-required);
                    }
                    return null;
                }
            } else if (io == IO.OUT && requiredTemp < 2273.0 - temp) {
                if (!simulate) {
                    PNCHeatExchangerTrait.this.handler.addHeat(required);
                }
                return null;
            }
            return List.of(Double.valueOf(required));
        }
    }

    public class HeatExchangerCap
    implements ICapabilityProviderTrait<IHeatExchangerLogic> {
        @Override
        public IO getCapabilityIO(@Nullable Direction side) {
            return IO.BOTH;
        }

        @Override
        public Capability<? super IHeatExchangerLogic> getCapability() {
            return PNCCapabilities.HEAT_EXCHANGER_CAPABILITY;
        }

        @Override
        public IHeatExchangerLogic getCapContent(IO capbilityIO) {
            return PNCHeatExchangerTrait.this.handler;
        }

        @Override
        public IHeatExchangerLogic mergeContents(List<IHeatExchangerLogic> contents) {
            return PNCHeatExchangerTrait.this.handler;
        }
    }
}

