/*
 * Decompiled with CFR 0.152.
 */
package com.superiorplayercommands.alias;

import com.google.gson.Gson;
import com.google.gson.GsonBuilder;
import com.google.gson.reflect.TypeToken;
import com.superiorplayercommands.SuperiorPlayerCommands;
import java.io.BufferedReader;
import java.io.BufferedWriter;
import java.io.IOException;
import java.io.Reader;
import java.lang.reflect.Type;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.OpenOption;
import java.nio.file.Path;
import java.nio.file.attribute.FileAttribute;
import java.util.LinkedHashMap;
import java.util.Map;
import java.util.Optional;
import net.fabricmc.loader.api.FabricLoader;

public class AliasManager {
    private static final Gson GSON = new GsonBuilder().setPrettyPrinting().create();
    private static final Path ALIASES_FILE = FabricLoader.getInstance().getConfigDir().resolve("superior-player-commands-aliases.json");
    private static Map<String, String> aliases = new LinkedHashMap<String, String>();
    private static final Map<String, String> DEFAULT_ALIASES = new LinkedHashMap<String, String>();

    public static void load() {
        if (Files.exists(ALIASES_FILE, new LinkOption[0])) {
            try (BufferedReader reader = Files.newBufferedReader(ALIASES_FILE);){
                Type type = new TypeToken<Map<String, String>>(){}.getType();
                Map loaded = (Map)GSON.fromJson((Reader)reader, type);
                if (loaded != null) {
                    aliases = new LinkedHashMap<String, String>(loaded);
                    SuperiorPlayerCommands.LOGGER.info("Loaded {} aliases", (Object)aliases.size());
                }
            }
            catch (IOException e) {
                SuperiorPlayerCommands.LOGGER.error("Failed to load aliases", (Throwable)e);
            }
        } else {
            aliases = new LinkedHashMap<String, String>(DEFAULT_ALIASES);
            AliasManager.save();
            SuperiorPlayerCommands.LOGGER.info("Created default aliases");
        }
    }

    public static void save() {
        try {
            Files.createDirectories(ALIASES_FILE.getParent(), new FileAttribute[0]);
            try (BufferedWriter writer = Files.newBufferedWriter(ALIASES_FILE, new OpenOption[0]);){
                GSON.toJson(aliases, (Appendable)writer);
            }
        }
        catch (IOException e) {
            SuperiorPlayerCommands.LOGGER.error("Failed to save aliases", (Throwable)e);
        }
    }

    public static void setAlias(String name, String command) {
        aliases.put(name.toLowerCase(), command);
        AliasManager.save();
    }

    public static boolean removeAlias(String name) {
        String removed = aliases.remove(name.toLowerCase());
        if (removed != null) {
            AliasManager.save();
            return true;
        }
        return false;
    }

    public static Optional<String> getAlias(String name) {
        return Optional.ofNullable(aliases.get(name.toLowerCase()));
    }

    public static Map<String, String> getAllAliases() {
        return new LinkedHashMap<String, String>(aliases);
    }

    public static boolean hasAlias(String name) {
        return aliases.containsKey(name.toLowerCase());
    }

    public static void resetToDefaults() {
        aliases = new LinkedHashMap<String, String>(DEFAULT_ALIASES);
        AliasManager.save();
    }

    public static Map<String, String> getDefaultAliases() {
        return new LinkedHashMap<String, String>(DEFAULT_ALIASES);
    }

    static {
        DEFAULT_ALIASES.put("gmc", "gamemode creative");
        DEFAULT_ALIASES.put("gms", "gamemode survival");
        DEFAULT_ALIASES.put("gma", "gamemode adventure");
        DEFAULT_ALIASES.put("gmsp", "gamemode spectator");
        DEFAULT_ALIASES.put("l", "listwaypoints");
    }
}

