/*
 * Decompiled with CFR 0.152.
 */
package com.superiorplayercommands.bind;

import com.google.gson.Gson;
import com.google.gson.GsonBuilder;
import com.google.gson.reflect.TypeToken;
import com.superiorplayercommands.SuperiorPlayerCommands;
import java.io.BufferedReader;
import java.io.BufferedWriter;
import java.io.IOException;
import java.io.Reader;
import java.lang.reflect.Type;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.OpenOption;
import java.nio.file.Path;
import java.nio.file.attribute.FileAttribute;
import java.util.HashMap;
import java.util.Map;
import java.util.Optional;
import net.fabricmc.loader.api.FabricLoader;

public class BindManager {
    private static final Gson GSON = new GsonBuilder().setPrettyPrinting().create();
    private static final Path BINDS_FILE = FabricLoader.getInstance().getConfigDir().resolve("superior-player-commands-binds.json");
    private static Map<String, String> bindings = new HashMap<String, String>();
    private static Map<String, Boolean> keyStates = new HashMap<String, Boolean>();

    public static void load() {
        if (Files.exists(BINDS_FILE, new LinkOption[0])) {
            try (BufferedReader reader = Files.newBufferedReader(BINDS_FILE);){
                Type type = new TypeToken<Map<String, String>>(){}.getType();
                Map loaded = (Map)GSON.fromJson((Reader)reader, type);
                if (loaded != null) {
                    bindings = loaded;
                    SuperiorPlayerCommands.LOGGER.info("Loaded {} key bindings", (Object)bindings.size());
                }
            }
            catch (IOException e) {
                SuperiorPlayerCommands.LOGGER.error("Failed to load bindings", (Throwable)e);
            }
        }
    }

    public static void save() {
        try {
            Files.createDirectories(BINDS_FILE.getParent(), new FileAttribute[0]);
            try (BufferedWriter writer = Files.newBufferedWriter(BINDS_FILE, new OpenOption[0]);){
                GSON.toJson(bindings, (Appendable)writer);
            }
        }
        catch (IOException e) {
            SuperiorPlayerCommands.LOGGER.error("Failed to save bindings", (Throwable)e);
        }
    }

    public static void setBind(String key, String command) {
        bindings.put(key.toLowerCase(), command);
        BindManager.save();
    }

    public static boolean removeBind(String key) {
        String removed = bindings.remove(key.toLowerCase());
        if (removed != null) {
            BindManager.save();
            return true;
        }
        return false;
    }

    public static Optional<String> getBind(String key) {
        return Optional.ofNullable(bindings.get(key.toLowerCase()));
    }

    public static Map<String, String> getAllBindings() {
        return new HashMap<String, String>(bindings);
    }

    public static boolean isKeyJustPressed(String key, boolean currentlyPressed) {
        String keyLower = key.toLowerCase();
        boolean wasPressed = keyStates.getOrDefault(keyLower, false);
        keyStates.put(keyLower, currentlyPressed);
        return currentlyPressed && !wasPressed;
    }

    public static void clearKeyState(String key) {
        keyStates.put(key.toLowerCase(), false);
    }
}

