/*
 * Decompiled with CFR 0.152.
 */
package com.superiorplayercommands.bind;

import java.util.HashMap;
import java.util.Map;

public class KeyHelper {
    private static final Map<String, Integer> NAME_TO_KEY;
    private static final Map<Integer, String> KEY_TO_NAME;

    private static void register(String name, int keyCode) {
        NAME_TO_KEY.put(name.toLowerCase(), keyCode);
        KEY_TO_NAME.put(keyCode, name.toLowerCase());
    }

    public static int getKeyCode(String name) {
        return NAME_TO_KEY.getOrDefault(name.toLowerCase(), -1);
    }

    public static String getKeyName(int keyCode) {
        return KEY_TO_NAME.getOrDefault(keyCode, "unknown");
    }

    public static boolean isValidKey(String name) {
        return NAME_TO_KEY.containsKey(name.toLowerCase());
    }

    static {
        int i;
        NAME_TO_KEY = new HashMap<String, Integer>();
        KEY_TO_NAME = new HashMap<Integer, String>();
        for (char c = 'a'; c <= 'z'; c = (char)(c + '\u0001')) {
            int keyCode = 65 + (c - 97);
            KeyHelper.register(String.valueOf(c), keyCode);
        }
        for (i = 0; i <= 9; ++i) {
            KeyHelper.register(String.valueOf(i), 48 + i);
        }
        for (i = 1; i <= 12; ++i) {
            KeyHelper.register("f" + i, 290 + (i - 1));
        }
        KeyHelper.register("space", 32);
        KeyHelper.register("tab", 258);
        KeyHelper.register("enter", 257);
        KeyHelper.register("escape", 256);
        KeyHelper.register("backspace", 259);
        KeyHelper.register("delete", 261);
        KeyHelper.register("insert", 260);
        KeyHelper.register("home", 268);
        KeyHelper.register("end", 269);
        KeyHelper.register("pageup", 266);
        KeyHelper.register("pagedown", 267);
        KeyHelper.register("up", 265);
        KeyHelper.register("down", 264);
        KeyHelper.register("left", 263);
        KeyHelper.register("right", 262);
        KeyHelper.register("lshift", 340);
        KeyHelper.register("rshift", 344);
        KeyHelper.register("lctrl", 341);
        KeyHelper.register("rctrl", 345);
        KeyHelper.register("lalt", 342);
        KeyHelper.register("ralt", 346);
        KeyHelper.register("minus", 45);
        KeyHelper.register("equals", 61);
        KeyHelper.register("lbracket", 91);
        KeyHelper.register("rbracket", 93);
        KeyHelper.register("backslash", 92);
        KeyHelper.register("semicolon", 59);
        KeyHelper.register("apostrophe", 39);
        KeyHelper.register("grave", 96);
        KeyHelper.register("comma", 44);
        KeyHelper.register("period", 46);
        KeyHelper.register("slash", 47);
        for (i = 0; i <= 9; ++i) {
            KeyHelper.register("numpad" + i, 320 + i);
        }
        KeyHelper.register("numpadenter", 335);
        KeyHelper.register("numpadadd", 334);
        KeyHelper.register("numpadsubtract", 333);
        KeyHelper.register("numpadmultiply", 332);
        KeyHelper.register("numpaddivide", 331);
        KeyHelper.register("numpaddecimal", 330);
    }
}

