/*
 * Decompiled with CFR 0.152.
 */
package com.superiorplayercommands.client;

import com.superiorplayercommands.network.MusicControlPacket;
import net.fabricmc.api.EnvType;
import net.fabricmc.api.Environment;
import net.fabricmc.fabric.api.client.networking.v1.ClientPlayNetworking;
import net.minecraft.class_1144;
import net.minecraft.class_2960;
import net.minecraft.class_310;
import net.minecraft.class_3419;

@Environment(value=EnvType.CLIENT)
public class MusicControlHandler {
    private static boolean isPaused = false;
    private static float musicVolume = 1.0f;

    public static void register() {
        ClientPlayNetworking.registerGlobalReceiver((class_2960)MusicControlPacket.MUSIC_CONTROL_PACKET, (client, handler, buf, responseSender) -> {
            String action = buf.method_19772();
            float volume = buf.readFloat();
            client.execute(() -> MusicControlHandler.handleMusicControl(action, volume));
        });
    }

    private static void handleMusicControl(String action, float volume) {
        class_310 client = class_310.method_1551();
        class_1144 soundManager = client.method_1483();
        switch (action) {
            case "pause": {
                soundManager.method_4879();
                isPaused = true;
                break;
            }
            case "play": {
                if (isPaused) {
                    soundManager.method_4880();
                    isPaused = false;
                }
                if (!(volume >= 0.0f)) break;
                MusicControlHandler.setMusicVolume(volume);
                break;
            }
            case "skip": {
                soundManager.method_4881();
                isPaused = false;
                break;
            }
            case "back": {
                soundManager.method_4881();
                isPaused = false;
                break;
            }
            case "volume": {
                MusicControlHandler.setMusicVolume(volume);
            }
        }
    }

    private static void setMusicVolume(float volume) {
        musicVolume = Math.max(0.0f, Math.min(1.0f, volume));
        class_310 client = class_310.method_1551();
        client.field_1690.method_45578(class_3419.field_15253).method_41748((Object)musicVolume);
    }

    public static float getMusicVolume() {
        return musicVolume;
    }
}

