/*
 * Decompiled with CFR 0.152.
 */
package com.superiorplayercommands.client.gui;

import com.superiorplayercommands.alias.AliasManager;
import com.superiorplayercommands.bind.BindManager;
import com.superiorplayercommands.bind.KeyHelper;
import com.superiorplayercommands.config.ModConfig;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import net.minecraft.class_2561;
import net.minecraft.class_332;
import net.minecraft.class_342;
import net.minecraft.class_364;
import net.minecraft.class_4185;
import net.minecraft.class_437;

public class ModSettingsScreen
extends class_437 {
    private final class_437 parent;
    private int currentTab = 0;
    private static final String[] TAB_NAMES = new String[]{"Commands", "Aliases", "Binds"};
    private static final int ENTRY_HEIGHT = 22;
    private static final int CATEGORY_HEIGHT = 20;
    private int scrollOffset = 0;
    private int maxScroll = 0;
    private final List<CommandEntry> commandEntries = new ArrayList<CommandEntry>();
    private List<Map.Entry<String, String>> aliasList = new ArrayList<Map.Entry<String, String>>();
    private class_342 aliasNameField;
    private class_342 aliasCommandField;
    private String selectedAlias = null;
    private List<Map.Entry<String, String>> bindList = new ArrayList<Map.Entry<String, String>>();
    private class_342 bindCommandField;
    private boolean waitingForKey = false;
    private String pendingKey = null;
    private String selectedBind = null;

    public ModSettingsScreen(class_437 parent) {
        super((class_2561)class_2561.method_43470((String)"Superior Player Commands Settings"));
        this.parent = parent;
        this.buildCommandEntries();
    }

    private void buildCommandEntries() {
        this.commandEntries.clear();
        for (Map.Entry<String, String[]> category : ModConfig.COMMAND_CATEGORIES.entrySet()) {
            this.commandEntries.add(new CommandEntry(category.getKey(), category.getKey(), true));
            for (String cmd : category.getValue()) {
                this.commandEntries.add(new CommandEntry(cmd, category.getKey(), false));
            }
        }
    }

    private void refreshAliasList() {
        this.aliasList = new ArrayList<Map.Entry<String, String>>(AliasManager.getAllAliases().entrySet());
    }

    private void refreshBindList() {
        this.bindList = new ArrayList<Map.Entry<String, String>>(BindManager.getAllBindings().entrySet());
    }

    protected void method_25426() {
        int tabWidth = 80;
        int startX = (this.field_22789 - (TAB_NAMES.length * tabWidth + (TAB_NAMES.length - 1) * 4)) / 2;
        for (int i = 0; i < TAB_NAMES.length; ++i) {
            int tabIndex = i;
            class_4185 tabBtn = class_4185.method_46430((class_2561)class_2561.method_43470((String)TAB_NAMES[i]), button -> this.switchTab(tabIndex)).method_46434(startX + i * (tabWidth + 4), 25, tabWidth, 20).method_46431();
            tabBtn.field_22763 = i != this.currentTab;
            this.method_37063((class_364)tabBtn);
        }
        this.method_37063((class_364)class_4185.method_46430((class_2561)class_2561.method_43471((String)"gui.done"), button -> this.method_25419()).method_46434(this.field_22789 / 2 - 100, this.field_22790 - 27, 200, 20).method_46431());
        this.initCurrentTab();
    }

    private void initCurrentTab() {
        this.scrollOffset = 0;
        switch (this.currentTab) {
            case 0: {
                this.initCommandsTab();
                break;
            }
            case 1: {
                this.initAliasesTab();
                break;
            }
            case 2: {
                this.initBindsTab();
            }
        }
        this.calculateMaxScroll();
    }

    private void initCommandsTab() {
        int centerX = this.field_22789 / 2;
        int buttonY = this.getContentTop() + 5;
        this.method_37063((class_364)class_4185.method_46430((class_2561)class_2561.method_43470((String)("Master: " + (ModConfig.isMasterEnabled() ? "\u00a7aON" : "\u00a7cOFF"))), button -> {
            ModConfig.setMasterEnabled(!ModConfig.isMasterEnabled());
            button.method_25355((class_2561)class_2561.method_43470((String)("Master: " + (ModConfig.isMasterEnabled() ? "\u00a7aON" : "\u00a7cOFF"))));
        }).method_46434(centerX - 155, buttonY, 100, 20).method_46431());
        this.method_37063((class_364)class_4185.method_46430((class_2561)class_2561.method_43470((String)"Enable All"), button -> ModConfig.enableAll()).method_46434(centerX - 50, buttonY, 100, 20).method_46431());
        this.method_37063((class_364)class_4185.method_46430((class_2561)class_2561.method_43470((String)"Disable All"), button -> ModConfig.disableAll()).method_46434(centerX + 55, buttonY, 100, 20).method_46431());
    }

    private void initAliasesTab() {
        this.refreshAliasList();
        int centerX = this.field_22789 / 2;
        int topY = this.getContentTop() + 5;
        this.aliasNameField = new class_342(this.field_22793, centerX - 155, topY, 80, 18, (class_2561)class_2561.method_43470((String)"Alias"));
        this.aliasNameField.method_47404((class_2561)class_2561.method_43470((String)"alias"));
        this.aliasNameField.method_1880(32);
        this.method_37063((class_364)this.aliasNameField);
        this.aliasCommandField = new class_342(this.field_22793, centerX - 70, topY, 150, 18, (class_2561)class_2561.method_43470((String)"Command"));
        this.aliasCommandField.method_47404((class_2561)class_2561.method_43470((String)"command to run"));
        this.aliasCommandField.method_1880(256);
        this.method_37063((class_364)this.aliasCommandField);
        this.method_37063((class_364)class_4185.method_46430((class_2561)class_2561.method_43470((String)"Add"), button -> {
            String name = this.aliasNameField.method_1882().trim();
            String command = this.aliasCommandField.method_1882().trim();
            if (!name.isEmpty() && !command.isEmpty()) {
                AliasManager.setAlias(name, command);
                this.aliasNameField.method_1852("");
                this.aliasCommandField.method_1852("");
                this.selectedAlias = null;
                this.refreshAliasList();
                this.calculateMaxScroll();
            }
        }).method_46434(centerX + 85, topY - 1, 40, 20).method_46431());
        this.method_37063((class_364)class_4185.method_46430((class_2561)class_2561.method_43470((String)"Reset"), button -> {
            AliasManager.resetToDefaults();
            this.refreshAliasList();
            this.calculateMaxScroll();
        }).method_46434(centerX + 130, topY - 1, 45, 20).method_46431());
    }

    private void initBindsTab() {
        this.refreshBindList();
        int centerX = this.field_22789 / 2;
        int topY = this.getContentTop() + 5;
        this.method_37063((class_364)class_4185.method_46430((class_2561)class_2561.method_43470((String)(this.pendingKey != null ? this.pendingKey.toUpperCase() : "Click for Key")), button -> {
            this.waitingForKey = true;
            button.method_25355((class_2561)class_2561.method_43470((String)"\u00a7e> Press Key <"));
        }).method_46434(centerX - 155, topY - 1, 80, 20).method_46431());
        this.bindCommandField = new class_342(this.field_22793, centerX - 70, topY, 150, 18, (class_2561)class_2561.method_43470((String)"Command"));
        this.bindCommandField.method_47404((class_2561)class_2561.method_43470((String)"command to execute"));
        this.bindCommandField.method_1880(256);
        this.method_37063((class_364)this.bindCommandField);
        this.method_37063((class_364)class_4185.method_46430((class_2561)class_2561.method_43470((String)"Bind"), button -> {
            String command = this.bindCommandField.method_1882().trim();
            if (this.pendingKey != null && !command.isEmpty()) {
                BindManager.setBind(this.pendingKey, command);
                this.pendingKey = null;
                this.bindCommandField.method_1852("");
                this.selectedBind = null;
                this.refreshBindList();
                this.calculateMaxScroll();
                this.clearAndReinit();
            }
        }).method_46434(centerX + 85, topY - 1, 45, 20).method_46431());
        this.method_37063((class_364)class_4185.method_46430((class_2561)class_2561.method_43470((String)"Clear"), button -> {
            for (Map.Entry<String, String> entry : new ArrayList<Map.Entry<String, String>>(this.bindList)) {
                BindManager.removeBind(entry.getKey());
            }
            this.refreshBindList();
            this.calculateMaxScroll();
        }).method_46434(centerX + 135, topY - 1, 40, 20).method_46431());
    }

    private void calculateMaxScroll() {
        int totalHeight = 0;
        int visibleHeight = this.getContentBottom() - this.getListTop() - 5;
        switch (this.currentTab) {
            case 0: {
                for (CommandEntry entry : this.commandEntries) {
                    totalHeight += entry.isCategory ? 20 : 22;
                }
                break;
            }
            case 1: {
                totalHeight = this.aliasList.size() * 22;
                break;
            }
            case 2: {
                totalHeight = this.bindList.size() * 22;
            }
        }
        this.maxScroll = Math.max(0, totalHeight - visibleHeight);
        this.scrollOffset = Math.min(this.scrollOffset, this.maxScroll);
    }

    private void switchTab(int tab) {
        if (tab == this.currentTab) {
            return;
        }
        this.currentTab = tab;
        this.clearAndReinit();
    }

    private void clearAndReinit() {
        this.method_37067();
        this.method_25426();
    }

    public void method_25394(class_332 context, int mouseX, int mouseY, float delta) {
        this.method_25420(context);
        context.method_27534(this.field_22793, this.field_22785, this.field_22789 / 2, 8, 0xFFFFFF);
        context.method_25294(20, 50, this.field_22789 - 20, this.field_22790 - 35, Integer.MIN_VALUE);
        switch (this.currentTab) {
            case 0: {
                this.renderCommandsTab(context, mouseX, mouseY);
                break;
            }
            case 1: {
                this.renderAliasesTab(context, mouseX, mouseY);
                break;
            }
            case 2: {
                this.renderBindsTab(context, mouseX, mouseY);
            }
        }
        super.method_25394(context, mouseX, mouseY, delta);
        if (this.waitingForKey) {
            context.method_25294(0, 0, this.field_22789, this.field_22790, -1073741824);
            context.method_25300(this.field_22793, "\u00a7ePress any key to bind...", this.field_22789 / 2, this.field_22790 / 2 - 10, 0xFFFFFF);
            context.method_25300(this.field_22793, "\u00a77(Press ESC to cancel)", this.field_22789 / 2, this.field_22790 / 2 + 5, 0xAAAAAA);
        }
    }

    private void renderCommandsTab(class_332 context, int mouseX, int mouseY) {
        int listTop = this.getListTop();
        int listBottom = this.getContentBottom() - 5;
        int listLeft = this.getContentLeft() + 5;
        int listRight = this.getContentRight() - 5;
        context.method_44379(listLeft, listTop, listRight, listBottom);
        int y = listTop - this.scrollOffset;
        for (CommandEntry entry : this.commandEntries) {
            if (entry.isCategory) {
                if (y + 20 > listTop && y < listBottom) {
                    boolean hovered = mouseX >= listLeft && mouseX <= listRight && mouseY >= y && mouseY < y + 20 - 2;
                    int bgColor = hovered ? -2142220208 : 0x60404040;
                    context.method_25294(listLeft, y, listRight, y + 20 - 2, bgColor);
                    context.method_25303(this.field_22793, "\u00a7e\u00a7l" + entry.name + (hovered ? " \u00a77(click to toggle)" : ""), listLeft + 5, y + 5, 0xFFFFFF);
                }
                y += 20;
                continue;
            }
            if (y + 22 > listTop && y < listBottom) {
                boolean hovered;
                boolean enabled = ModConfig.isCommandEnabled(entry.name);
                boolean bl = hovered = mouseX >= listLeft + 10 && mouseX <= listRight - 10 && mouseY >= y && mouseY < y + 22 - 2;
                int bgColor = enabled ? (hovered ? 0x50009000 : 0x40008000) : (hovered ? 0x50900000 : 0x40800000);
                context.method_25294(listLeft + 10, y, listRight - 10, y + 22 - 2, bgColor);
                context.method_25303(this.field_22793, "/" + entry.name, listLeft + 15, y + 7, 0xFFFFFF);
                String status = enabled ? "\u00a7a[ON]" : "\u00a7c[OFF]";
                int statusWidth = this.field_22793.method_1727(status);
                context.method_25303(this.field_22793, status, listRight - 20 - statusWidth, y + 7, 0xFFFFFF);
            }
            y += 22;
        }
        context.method_44380();
        this.renderScrollbar(context, listTop, listBottom, listRight);
    }

    private void renderAliasesTab(class_332 context, int mouseX, int mouseY) {
        int listTop = this.getListTop();
        int listBottom = this.getContentBottom() - 5;
        int listLeft = this.getContentLeft() + 5;
        int listRight = this.getContentRight() - 5;
        context.method_25303(this.field_22793, "\u00a77Aliases: type shortcut \u2192 runs full command", listLeft, listTop - 14, 0xAAAAAA);
        context.method_44379(listLeft, listTop, listRight, listBottom);
        int y = listTop - this.scrollOffset;
        for (Map.Entry<String, String> entry : this.aliasList) {
            if (y + 22 > listTop && y < listBottom) {
                boolean hovered = mouseX >= listLeft && mouseX <= listRight - 22 && mouseY >= y && mouseY < y + 22 - 2;
                boolean selected = entry.getKey().equals(this.selectedAlias);
                int bgColor = selected ? 0x60606080 : (hovered ? 0x40404060 : 0x30303030);
                context.method_25294(listLeft, y, listRight - 22, y + 22 - 2, bgColor);
                int aliasWidth = this.field_22793.method_1727("/" + entry.getKey());
                boolean aliasHovered = mouseX >= listLeft + 5 && mouseX <= listLeft + 5 + aliasWidth && mouseY >= y && mouseY < y + 22 - 2;
                context.method_25303(this.field_22793, (aliasHovered ? "\u00a7b\u00a7n" : "\u00a7b") + "/" + entry.getKey(), listLeft + 5, y + 6, 0xFFFFFF);
                context.method_25303(this.field_22793, "\u00a77\u2192", listLeft + 80, y + 6, 0xFFFFFF);
                String cmd = entry.getValue();
                String displayCmd = cmd.length() > 35 ? cmd.substring(0, 32) + "..." : cmd;
                boolean cmdHovered = mouseX >= listLeft + 95 && mouseX <= listRight - 25 && mouseY >= y && mouseY < y + 22 - 2;
                context.method_25303(this.field_22793, (cmdHovered ? "\u00a7f\u00a7n" : "\u00a7f") + "/" + displayCmd, listLeft + 95, y + 6, 0xFFFFFF);
                boolean deleteHovered = mouseX >= listRight - 20 && mouseX <= listRight - 4 && mouseY >= y + 2 && mouseY < y + 22 - 4;
                int deleteBg = deleteHovered ? -5636096 : -10092544;
                context.method_25294(listRight - 20, y + 2, listRight - 4, y + 22 - 4, deleteBg);
                context.method_25300(this.field_22793, "\u00a7cX", listRight - 12, y + 5, 0xFFFFFF);
            }
            y += 22;
        }
        context.method_44380();
        if (this.aliasList.isEmpty()) {
            context.method_25300(this.field_22793, "\u00a77No aliases defined. Add one above!", this.field_22789 / 2, listTop + 30, 0x888888);
        }
        this.renderScrollbar(context, listTop, listBottom, listRight);
    }

    private void renderBindsTab(class_332 context, int mouseX, int mouseY) {
        int listTop = this.getListTop();
        int listBottom = this.getContentBottom() - 5;
        int listLeft = this.getContentLeft() + 5;
        int listRight = this.getContentRight() - 5;
        context.method_25303(this.field_22793, "\u00a77Key binds: press key in-game \u2192 runs command", listLeft, listTop - 14, 0xAAAAAA);
        context.method_44379(listLeft, listTop, listRight, listBottom);
        int y = listTop - this.scrollOffset;
        for (Map.Entry<String, String> entry : this.bindList) {
            if (y + 22 > listTop && y < listBottom) {
                boolean hovered = mouseX >= listLeft && mouseX <= listRight - 22 && mouseY >= y && mouseY < y + 22 - 2;
                boolean selected = entry.getKey().equals(this.selectedBind);
                int bgColor = selected ? 0x60606080 : (hovered ? 0x40404060 : 0x30303030);
                context.method_25294(listLeft, y, listRight - 22, y + 22 - 2, bgColor);
                context.method_25303(this.field_22793, "\u00a7d[" + entry.getKey().toUpperCase() + "]", listLeft + 5, y + 6, 0xFFFFFF);
                context.method_25303(this.field_22793, "\u00a77\u2192", listLeft + 70, y + 6, 0xFFFFFF);
                String cmd = entry.getValue();
                String displayCmd = cmd.length() > 40 ? cmd.substring(0, 37) + "..." : cmd;
                context.method_25303(this.field_22793, "\u00a7f/" + displayCmd, listLeft + 85, y + 6, 0xFFFFFF);
                boolean deleteHovered = mouseX >= listRight - 20 && mouseX <= listRight - 4 && mouseY >= y + 2 && mouseY < y + 22 - 4;
                int deleteBg = deleteHovered ? -5636096 : -10092544;
                context.method_25294(listRight - 20, y + 2, listRight - 4, y + 22 - 4, deleteBg);
                context.method_25300(this.field_22793, "\u00a7cX", listRight - 12, y + 5, 0xFFFFFF);
            }
            y += 22;
        }
        context.method_44380();
        if (this.bindList.isEmpty()) {
            context.method_25300(this.field_22793, "\u00a77No key bindings. Add one above!", this.field_22789 / 2, listTop + 30, 0x888888);
        }
        this.renderScrollbar(context, listTop, listBottom, listRight);
    }

    private void renderScrollbar(class_332 context, int listTop, int listBottom, int listRight) {
        if (this.maxScroll > 0) {
            int scrollBarHeight = Math.max(20, (listBottom - listTop) * (listBottom - listTop) / (this.maxScroll + listBottom - listTop));
            int scrollBarY = listTop + (int)((float)(listBottom - listTop - scrollBarHeight) * ((float)this.scrollOffset / (float)this.maxScroll));
            context.method_25294(listRight - 3, scrollBarY, listRight, scrollBarY + scrollBarHeight, -5592406);
        }
    }

    public boolean method_25402(double mouseX, double mouseY, int button) {
        if (this.waitingForKey) {
            String keyName = "mouse" + button;
            this.pendingKey = keyName;
            this.waitingForKey = false;
            this.clearAndReinit();
            return true;
        }
        int listTop = this.getListTop();
        int listBottom = this.getContentBottom() - 5;
        int listLeft = this.getContentLeft() + 5;
        int listRight = this.getContentRight() - 5;
        if (mouseX >= (double)listLeft && mouseX <= (double)listRight && mouseY >= (double)listTop && mouseY <= (double)listBottom) {
            switch (this.currentTab) {
                case 0: {
                    return this.handleCommandsClick(mouseX, mouseY, listLeft, listRight, listTop);
                }
                case 1: {
                    return this.handleAliasesClick(mouseX, mouseY, listLeft, listRight, listTop);
                }
                case 2: {
                    return this.handleBindsClick(mouseX, mouseY, listLeft, listRight, listTop);
                }
            }
        }
        return super.method_25402(mouseX, mouseY, button);
    }

    private boolean handleCommandsClick(double mouseX, double mouseY, int listLeft, int listRight, int listTop) {
        int y = listTop - this.scrollOffset;
        for (CommandEntry entry : this.commandEntries) {
            int entryHeight;
            int n = entryHeight = entry.isCategory ? 20 : 22;
            if (mouseY >= (double)y && mouseY < (double)(y + entryHeight - 2)) {
                if (entry.isCategory) {
                    this.toggleCategory(entry.category);
                    return true;
                }
                if (mouseX >= (double)(listLeft + 10) && mouseX <= (double)(listRight - 10)) {
                    boolean current = ModConfig.isCommandEnabled(entry.name);
                    ModConfig.setCommandEnabled(entry.name, !current);
                    return true;
                }
            }
            y += entryHeight;
        }
        return false;
    }

    private void toggleCategory(String category) {
        String[] commands = ModConfig.COMMAND_CATEGORIES.get(category);
        if (commands == null) {
            return;
        }
        boolean anyEnabled = false;
        for (String cmd : commands) {
            if (!ModConfig.getAllToggles().getOrDefault(cmd, true).booleanValue()) continue;
            anyEnabled = true;
            break;
        }
        for (String cmd : commands) {
            ModConfig.setCommandEnabled(cmd, !anyEnabled);
        }
    }

    private boolean handleAliasesClick(double mouseX, double mouseY, int listLeft, int listRight, int listTop) {
        int y = listTop - this.scrollOffset;
        for (Map.Entry<String, String> entry : this.aliasList) {
            if (mouseY >= (double)y && mouseY < (double)(y + 22 - 2)) {
                if (mouseX >= (double)(listRight - 20) && mouseX <= (double)(listRight - 4)) {
                    AliasManager.removeAlias(entry.getKey());
                    this.refreshAliasList();
                    this.calculateMaxScroll();
                    return true;
                }
                int aliasWidth = this.field_22793.method_1727("/" + entry.getKey());
                if (mouseX >= (double)(listLeft + 5) && mouseX <= (double)(listLeft + 5 + aliasWidth)) {
                    this.selectedAlias = entry.getKey();
                    this.aliasNameField.method_1852(entry.getKey());
                    this.aliasCommandField.method_1852(entry.getValue());
                    this.aliasNameField.method_25365(true);
                    return true;
                }
                if (mouseX >= (double)(listLeft + 95) && mouseX <= (double)(listRight - 25)) {
                    this.selectedAlias = entry.getKey();
                    this.aliasNameField.method_1852(entry.getKey());
                    this.aliasCommandField.method_1852(entry.getValue());
                    this.aliasCommandField.method_25365(true);
                    return true;
                }
            }
            y += 22;
        }
        return false;
    }

    private boolean handleBindsClick(double mouseX, double mouseY, int listLeft, int listRight, int listTop) {
        int y = listTop - this.scrollOffset;
        for (Map.Entry<String, String> entry : this.bindList) {
            if (mouseY >= (double)y && mouseY < (double)(y + 22 - 2)) {
                if (mouseX >= (double)(listRight - 20) && mouseX <= (double)(listRight - 4)) {
                    BindManager.removeBind(entry.getKey());
                    this.refreshBindList();
                    this.calculateMaxScroll();
                    return true;
                }
                this.selectedBind = entry.getKey();
                this.pendingKey = entry.getKey();
                this.bindCommandField.method_1852(entry.getValue());
                this.clearAndReinit();
                return true;
            }
            y += 22;
        }
        return false;
    }

    public boolean method_25401(double mouseX, double mouseY, double amount) {
        if (!this.waitingForKey) {
            this.scrollOffset = Math.max(0, Math.min(this.maxScroll, this.scrollOffset - (int)(amount * 20.0)));
            return true;
        }
        return super.method_25401(mouseX, mouseY, amount);
    }

    public boolean method_25404(int keyCode, int scanCode, int modifiers) {
        if (this.waitingForKey) {
            if (keyCode == 256) {
                this.waitingForKey = false;
                return true;
            }
            String keyName = KeyHelper.getKeyName(keyCode);
            if (keyName != null && !keyName.equals("unknown")) {
                this.pendingKey = keyName;
                this.waitingForKey = false;
                this.clearAndReinit();
            }
            return true;
        }
        if (keyCode == 258 && this.currentTab == 1 && this.aliasNameField != null && this.aliasCommandField != null) {
            if (this.aliasNameField.method_25370()) {
                this.aliasNameField.method_25365(false);
                this.aliasCommandField.method_25365(true);
                return true;
            }
            if (this.aliasCommandField.method_25370()) {
                this.aliasCommandField.method_25365(false);
                this.aliasNameField.method_25365(true);
                return true;
            }
        }
        return super.method_25404(keyCode, scanCode, modifiers);
    }

    public void method_25419() {
        if (this.field_22787 != null) {
            this.field_22787.method_1507(this.parent);
        }
    }

    private int getContentTop() {
        return 55;
    }

    private int getContentBottom() {
        return this.field_22790 - 40;
    }

    private int getContentLeft() {
        return 25;
    }

    private int getContentRight() {
        return this.field_22789 - 25;
    }

    private int getListTop() {
        return this.getContentTop() + 35;
    }

    private record CommandEntry(String name, String category, boolean isCategory) {
    }
}

