/*
 * Decompiled with CFR 0.152.
 */
package com.superiorplayercommands.command.core;

import com.mojang.brigadier.CommandDispatcher;
import com.mojang.brigadier.arguments.ArgumentType;
import com.mojang.brigadier.arguments.StringArgumentType;
import com.mojang.brigadier.builder.LiteralArgumentBuilder;
import com.mojang.brigadier.builder.RequiredArgumentBuilder;
import com.mojang.brigadier.context.CommandContext;
import com.superiorplayercommands.alias.AliasManager;
import java.util.Map;
import java.util.Optional;
import net.minecraft.class_124;
import net.minecraft.class_2168;
import net.minecraft.class_2170;
import net.minecraft.class_2558;
import net.minecraft.class_2561;
import net.minecraft.class_2568;
import net.minecraft.class_5250;

public class AliasCommand {
    public static void register(CommandDispatcher<class_2168> dispatcher) {
        dispatcher.register((LiteralArgumentBuilder)((LiteralArgumentBuilder)((LiteralArgumentBuilder)class_2170.method_9247((String)"alias").requires(source -> source.method_9259(0))).executes(AliasCommand::listAliases)).then(((RequiredArgumentBuilder)class_2170.method_9244((String)"name", (ArgumentType)StringArgumentType.word()).executes(AliasCommand::showAlias)).then(class_2170.method_9244((String)"command", (ArgumentType)StringArgumentType.greedyString()).executes(AliasCommand::setAlias))));
        dispatcher.register((LiteralArgumentBuilder)((LiteralArgumentBuilder)class_2170.method_9247((String)"unalias").requires(source -> source.method_9259(0))).then(class_2170.method_9244((String)"name", (ArgumentType)StringArgumentType.word()).executes(AliasCommand::removeAlias)));
        AliasCommand.registerAliasCommands(dispatcher);
    }

    public static void registerAliasCommands(CommandDispatcher<class_2168> dispatcher) {
        for (Map.Entry<String, String> entry : AliasManager.getAllAliases().entrySet()) {
            AliasCommand.registerSingleAlias(dispatcher, entry.getKey(), entry.getValue());
        }
    }

    private static void registerSingleAlias(CommandDispatcher<class_2168> dispatcher, String name, String command) {
        try {
            dispatcher.register((LiteralArgumentBuilder)((LiteralArgumentBuilder)class_2170.method_9247((String)name).requires(source -> source.method_9259(2))).executes(context -> AliasCommand.executeAlias((CommandContext<class_2168>)context, command)));
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    private static int executeAlias(CommandContext<class_2168> context, String command) {
        class_2168 source = (class_2168)context.getSource();
        try {
            return source.method_9211().method_3734().method_44252(source, "/" + command);
        }
        catch (Exception e) {
            source.method_9213((class_2561)class_2561.method_43470((String)("Failed to execute alias: " + e.getMessage())));
            return 0;
        }
    }

    private static int listAliases(CommandContext<class_2168> context) {
        class_2168 source = (class_2168)context.getSource();
        Map<String, String> aliases = AliasManager.getAllAliases();
        if (aliases.isEmpty()) {
            source.method_9226(() -> class_2561.method_43470((String)"No aliases defined. Use ").method_27692(class_124.field_1080).method_10852((class_2561)class_2561.method_43470((String)"/alias <name> <command>").method_27692(class_124.field_1054)).method_10852((class_2561)class_2561.method_43470((String)" to create one.")), false);
            return 0;
        }
        source.method_9226(() -> class_2561.method_43470((String)"=== Aliases ===").method_27692(class_124.field_1065), false);
        for (Map.Entry<String, String> entry : aliases.entrySet()) {
            String name = entry.getKey();
            String command = entry.getValue();
            class_5250 line = class_2561.method_43470((String)("/" + name)).method_27692(class_124.field_1075).method_10852((class_2561)class_2561.method_43470((String)" \u2192 ").method_27692(class_124.field_1080)).method_10852((class_2561)class_2561.method_43470((String)("/" + command)).method_27692(class_124.field_1068));
            line.method_27694(style -> style.method_10958(new class_2558(class_2558.class_2559.field_11745, "/unalias " + name)).method_10949(new class_2568(class_2568.class_5247.field_24342, (Object)class_2561.method_43470((String)"Click to remove").method_27692(class_124.field_1061))));
            source.method_9226(() -> line, false);
        }
        return aliases.size();
    }

    private static int showAlias(CommandContext<class_2168> context) {
        class_2168 source = (class_2168)context.getSource();
        String name = StringArgumentType.getString(context, (String)"name").toLowerCase();
        Optional<String> alias = AliasManager.getAlias(name);
        if (alias.isPresent()) {
            source.method_9226(() -> class_2561.method_43470((String)("/" + name)).method_27692(class_124.field_1075).method_10852((class_2561)class_2561.method_43470((String)" expands to: ").method_27692(class_124.field_1080)).method_10852((class_2561)class_2561.method_43470((String)("/" + (String)alias.get())).method_27692(class_124.field_1068)), false);
        } else {
            source.method_9226(() -> class_2561.method_43470((String)"No alias named '").method_27692(class_124.field_1061).method_10852((class_2561)class_2561.method_43470((String)name).method_27692(class_124.field_1075)).method_10852((class_2561)class_2561.method_43470((String)"'").method_27692(class_124.field_1061)), false);
        }
        return 1;
    }

    private static int setAlias(CommandContext<class_2168> context) {
        class_2168 source = (class_2168)context.getSource();
        String name = StringArgumentType.getString(context, (String)"name").toLowerCase();
        String command = StringArgumentType.getString(context, (String)"command");
        if (command.startsWith("/")) {
            command = command.substring(1);
        }
        boolean isUpdate = AliasManager.hasAlias(name);
        AliasManager.setAlias(name, command);
        String finalCommand = command;
        String action = isUpdate ? "Updated" : "Created";
        source.method_9226(() -> class_2561.method_43470((String)(action + " alias ")).method_27692(class_124.field_1060).method_10852((class_2561)class_2561.method_43470((String)("/" + name)).method_27692(class_124.field_1075)).method_10852((class_2561)class_2561.method_43470((String)" \u2192 ").method_27692(class_124.field_1080)).method_10852((class_2561)class_2561.method_43470((String)("/" + finalCommand)).method_27692(class_124.field_1068)), false);
        if (!isUpdate) {
            source.method_9226(() -> class_2561.method_43470((String)"Note: Restart or rejoin for the new alias to work as a command").method_27692(class_124.field_1054), false);
        }
        return 1;
    }

    private static int removeAlias(CommandContext<class_2168> context) {
        class_2168 source = (class_2168)context.getSource();
        String name = StringArgumentType.getString(context, (String)"name").toLowerCase();
        if (AliasManager.removeAlias(name)) {
            source.method_9226(() -> class_2561.method_43470((String)"Removed alias ").method_27692(class_124.field_1054).method_10852((class_2561)class_2561.method_43470((String)("/" + name)).method_27692(class_124.field_1075)), false);
            return 1;
        }
        source.method_9226(() -> class_2561.method_43470((String)"No alias named '").method_27692(class_124.field_1061).method_10852((class_2561)class_2561.method_43470((String)name).method_27692(class_124.field_1075)).method_10852((class_2561)class_2561.method_43470((String)"'").method_27692(class_124.field_1061)), false);
        return 0;
    }
}

