/*
 * Decompiled with CFR 0.152.
 */
package com.superiorplayercommands.command.core;

import com.mojang.brigadier.CommandDispatcher;
import com.mojang.brigadier.arguments.ArgumentType;
import com.mojang.brigadier.arguments.StringArgumentType;
import com.mojang.brigadier.builder.LiteralArgumentBuilder;
import com.mojang.brigadier.builder.RequiredArgumentBuilder;
import com.mojang.brigadier.context.CommandContext;
import com.superiorplayercommands.bind.BindManager;
import com.superiorplayercommands.bind.KeyHelper;
import java.util.Map;
import java.util.Optional;
import net.minecraft.class_124;
import net.minecraft.class_2168;
import net.minecraft.class_2170;
import net.minecraft.class_2558;
import net.minecraft.class_2561;
import net.minecraft.class_2568;
import net.minecraft.class_5250;

public class BindCommand {
    public static void register(CommandDispatcher<class_2168> dispatcher) {
        dispatcher.register((LiteralArgumentBuilder)((LiteralArgumentBuilder)((LiteralArgumentBuilder)class_2170.method_9247((String)"bind").requires(source -> source.method_9259(0))).executes(BindCommand::listBindings)).then(((RequiredArgumentBuilder)class_2170.method_9244((String)"key", (ArgumentType)StringArgumentType.word()).executes(BindCommand::showOrUnbind)).then(class_2170.method_9244((String)"command", (ArgumentType)StringArgumentType.greedyString()).executes(BindCommand::setBind))));
        dispatcher.register((LiteralArgumentBuilder)((LiteralArgumentBuilder)class_2170.method_9247((String)"unbind").requires(source -> source.method_9259(0))).then(class_2170.method_9244((String)"key", (ArgumentType)StringArgumentType.word()).executes(BindCommand::unbind)));
    }

    private static int listBindings(CommandContext<class_2168> context) {
        class_2168 source = (class_2168)context.getSource();
        Map<String, String> bindings = BindManager.getAllBindings();
        if (bindings.isEmpty()) {
            source.method_9226(() -> class_2561.method_43470((String)"No key bindings set. Use ").method_27692(class_124.field_1080).method_10852((class_2561)class_2561.method_43470((String)"/bind <key> <command>").method_27692(class_124.field_1054)).method_10852((class_2561)class_2561.method_43470((String)" to create one.")), false);
            return 0;
        }
        source.method_9226(() -> class_2561.method_43470((String)"=== Key Bindings ===").method_27692(class_124.field_1065), false);
        for (Map.Entry<String, String> entry : bindings.entrySet()) {
            String key = entry.getKey();
            String command = entry.getValue();
            class_5250 line = class_2561.method_43470((String)("[" + key.toUpperCase() + "] ")).method_27692(class_124.field_1075).method_10852((class_2561)class_2561.method_43470((String)"\u2192 ").method_27692(class_124.field_1080)).method_10852((class_2561)class_2561.method_43470((String)("/" + command)).method_27692(class_124.field_1068));
            line.method_27694(style -> style.method_10958(new class_2558(class_2558.class_2559.field_11745, "/unbind " + key)).method_10949(new class_2568(class_2568.class_5247.field_24342, (Object)class_2561.method_43470((String)"Click to unbind").method_27692(class_124.field_1061))));
            source.method_9226(() -> line, false);
        }
        return bindings.size();
    }

    private static int showOrUnbind(CommandContext<class_2168> context) {
        class_2168 source = (class_2168)context.getSource();
        String key = StringArgumentType.getString(context, (String)"key").toLowerCase();
        if (!KeyHelper.isValidKey(key)) {
            source.method_9226(() -> class_2561.method_43470((String)("Unknown key: " + key)).method_27692(class_124.field_1061).method_10852((class_2561)class_2561.method_43470((String)"\nValid keys: a-z, 0-9, f1-f12, space, tab, etc.").method_27692(class_124.field_1080)), false);
            return 0;
        }
        Optional<String> binding = BindManager.getBind(key);
        if (binding.isPresent()) {
            source.method_9226(() -> class_2561.method_43470((String)("[" + key.toUpperCase() + "] ")).method_27692(class_124.field_1075).method_10852((class_2561)class_2561.method_43470((String)"is bound to: ").method_27692(class_124.field_1080)).method_10852((class_2561)class_2561.method_43470((String)("/" + (String)binding.get())).method_27692(class_124.field_1068)), false);
        } else {
            source.method_9226(() -> class_2561.method_43470((String)("[" + key.toUpperCase() + "] ")).method_27692(class_124.field_1075).method_10852((class_2561)class_2561.method_43470((String)"is not bound").method_27692(class_124.field_1080)), false);
        }
        return 1;
    }

    private static int setBind(CommandContext<class_2168> context) {
        class_2168 source = (class_2168)context.getSource();
        String key = StringArgumentType.getString(context, (String)"key").toLowerCase();
        String command = StringArgumentType.getString(context, (String)"command");
        if (command.startsWith("/")) {
            command = command.substring(1);
        }
        if (!KeyHelper.isValidKey(key)) {
            source.method_9226(() -> class_2561.method_43470((String)("Unknown key: " + key)).method_27692(class_124.field_1061).method_10852((class_2561)class_2561.method_43470((String)"\nValid keys: a-z, 0-9, f1-f12, space, tab, etc.").method_27692(class_124.field_1080)), false);
            return 0;
        }
        String finalCommand = command;
        BindManager.setBind(key, command);
        source.method_9226(() -> class_2561.method_43470((String)("Bound [" + key.toUpperCase() + "] to: ")).method_27692(class_124.field_1060).method_10852((class_2561)class_2561.method_43470((String)("/" + finalCommand)).method_27692(class_124.field_1068)), false);
        return 1;
    }

    private static int unbind(CommandContext<class_2168> context) {
        class_2168 source = (class_2168)context.getSource();
        String key = StringArgumentType.getString(context, (String)"key").toLowerCase();
        if (BindManager.removeBind(key)) {
            source.method_9226(() -> class_2561.method_43470((String)("Unbound [" + key.toUpperCase() + "]")).method_27692(class_124.field_1054), false);
            return 1;
        }
        source.method_9226(() -> class_2561.method_43470((String)("[" + key.toUpperCase() + "] was not bound")).method_27692(class_124.field_1080), false);
        return 0;
    }
}

