/*
 * Decompiled with CFR 0.152.
 */
package com.superiorplayercommands.command.core;

import com.mojang.brigadier.CommandDispatcher;
import com.mojang.brigadier.arguments.ArgumentType;
import com.mojang.brigadier.arguments.StringArgumentType;
import com.mojang.brigadier.builder.LiteralArgumentBuilder;
import com.mojang.brigadier.context.CommandContext;
import com.mojang.brigadier.suggestion.SuggestionProvider;
import com.mojang.brigadier.suggestion.SuggestionsBuilder;
import com.superiorplayercommands.data.PlayerStateManager;
import com.superiorplayercommands.data.WaypointManager;
import java.util.Optional;
import net.minecraft.class_124;
import net.minecraft.class_2168;
import net.minecraft.class_2170;
import net.minecraft.class_2172;
import net.minecraft.class_2338;
import net.minecraft.class_2382;
import net.minecraft.class_2561;
import net.minecraft.class_2960;
import net.minecraft.class_3218;
import net.minecraft.class_3222;
import net.minecraft.class_5321;
import net.minecraft.class_7924;

public class GotoCommand {
    private static final SuggestionProvider<class_2168> WAYPOINT_SUGGESTIONS = (context, builder) -> {
        class_2168 source = (class_2168)context.getSource();
        if (source.method_43737()) {
            return class_2172.method_9265(WaypointManager.getWaypointNames(source.method_44023().method_5667()), (SuggestionsBuilder)builder);
        }
        return builder.buildFuture();
    };

    public static void register(CommandDispatcher<class_2168> dispatcher) {
        dispatcher.register((LiteralArgumentBuilder)((LiteralArgumentBuilder)class_2170.method_9247((String)"goto").requires(source -> source.method_9259(2))).then(class_2170.method_9244((String)"name", (ArgumentType)StringArgumentType.word()).suggests(WAYPOINT_SUGGESTIONS).executes(GotoCommand::execute)));
    }

    private static int execute(CommandContext<class_2168> context) {
        class_2168 source = (class_2168)context.getSource();
        if (!source.method_43737()) {
            source.method_9213((class_2561)class_2561.method_43470((String)"This command can only be used by players"));
            return 0;
        }
        class_3222 player = source.method_44023();
        String name = StringArgumentType.getString(context, (String)"name");
        Optional<WaypointManager.WaypointData> waypointOpt = WaypointManager.getWaypoint(player.method_5667(), name);
        if (waypointOpt.isEmpty()) {
            source.method_9226(() -> class_2561.method_43470((String)"Waypoint '").method_27692(class_124.field_1061).method_10852((class_2561)class_2561.method_43470((String)name).method_27692(class_124.field_1075)).method_10852((class_2561)class_2561.method_43470((String)"' not found").method_27692(class_124.field_1061)), false);
            return 0;
        }
        WaypointManager.WaypointData waypoint = waypointOpt.get();
        class_2338 targetPos = waypoint.getPos();
        class_5321 targetDimension = class_5321.method_29179((class_5321)class_7924.field_41223, (class_2960)waypoint.getDimensionId());
        class_3218 targetWorld = source.method_9211().method_3847(targetDimension);
        if (targetWorld == null) {
            source.method_9226(() -> class_2561.method_43470((String)"Cannot teleport: dimension not found").method_27692(class_124.field_1061), false);
            return 0;
        }
        double distance = player.method_37908().method_27983().equals(targetDimension) ? Math.sqrt(player.method_24515().method_10262((class_2382)targetPos)) : -1.0;
        PlayerStateManager.setLastTeleportPosition(player.method_5667(), player.method_24515(), player.method_37908().method_27983().method_29177());
        player.method_14251(targetWorld, (double)targetPos.method_10263() + 0.5, (double)targetPos.method_10264(), (double)targetPos.method_10260() + 0.5, player.method_36454(), player.method_36455());
        if (!PlayerStateManager.isHideResponses(player.method_5667())) {
            double finalDistance = distance;
            if (distance >= 0.0) {
                source.method_9226(() -> class_2561.method_43470((String)"Teleported to '").method_27692(class_124.field_1060).method_10852((class_2561)class_2561.method_43470((String)name).method_27692(class_124.field_1075)).method_10852((class_2561)class_2561.method_43470((String)"' (").method_27692(class_124.field_1060)).method_10852((class_2561)class_2561.method_43470((String)String.format("%.1f blocks", finalDistance)).method_27692(class_124.field_1068)).method_10852((class_2561)class_2561.method_43470((String)")").method_27692(class_124.field_1060)), false);
            } else {
                source.method_9226(() -> class_2561.method_43470((String)"Teleported to '").method_27692(class_124.field_1060).method_10852((class_2561)class_2561.method_43470((String)name).method_27692(class_124.field_1075)).method_10852((class_2561)class_2561.method_43470((String)"' in ").method_27692(class_124.field_1060)).method_10852((class_2561)class_2561.method_43470((String)waypoint.getDimensionId().method_12832()).method_27692(class_124.field_1076)), false);
            }
        }
        return 1;
    }
}

