/*
 * Decompiled with CFR 0.152.
 */
package com.superiorplayercommands.command.core;

import com.mojang.brigadier.CommandDispatcher;
import com.mojang.brigadier.builder.LiteralArgumentBuilder;
import com.mojang.brigadier.context.CommandContext;
import com.superiorplayercommands.data.PlayerStateManager;
import com.superiorplayercommands.util.TeleportHelper;
import net.minecraft.class_124;
import net.minecraft.class_1297;
import net.minecraft.class_1937;
import net.minecraft.class_2168;
import net.minecraft.class_2170;
import net.minecraft.class_2338;
import net.minecraft.class_2382;
import net.minecraft.class_239;
import net.minecraft.class_2561;
import net.minecraft.class_3222;
import net.minecraft.class_3959;
import net.minecraft.class_3965;

public class JumpCommand {
    private static final double MAX_DISTANCE = 256.0;

    public static void register(CommandDispatcher<class_2168> dispatcher) {
        dispatcher.register((LiteralArgumentBuilder)((LiteralArgumentBuilder)class_2170.method_9247((String)"jump").requires(source -> source.method_9259(2))).executes(JumpCommand::execute));
    }

    private static int execute(CommandContext<class_2168> context) {
        class_2168 source = (class_2168)context.getSource();
        if (!source.method_43737()) {
            source.method_9213((class_2561)class_2561.method_43470((String)"This command can only be used by players"));
            return 0;
        }
        class_3222 player = source.method_44023();
        class_1937 world = player.method_37908();
        class_3965 hitResult = world.method_17742(new class_3959(player.method_33571(), player.method_33571().method_1019(player.method_5720().method_1021(256.0)), class_3959.class_3960.field_17559, class_3959.class_242.field_1348, (class_1297)player));
        if (hitResult.method_17783() == class_239.class_240.field_1333) {
            source.method_9226(() -> class_2561.method_43470((String)"No block in sight (max range: 256 blocks)").method_27692(class_124.field_1061), false);
            return 0;
        }
        class_2338 hitPos = hitResult.method_17777();
        class_2338 landingPos = JumpCommand.findLandingSpot(world, hitPos, hitResult);
        if (landingPos == null) {
            source.method_9226(() -> class_2561.method_43470((String)"No safe landing spot found").method_27692(class_124.field_1061), false);
            return 0;
        }
        class_2338 startPos = player.method_24515();
        double distance = Math.sqrt(startPos.method_10262((class_2382)landingPos));
        TeleportHelper.teleportPlayer(player, landingPos);
        if (!PlayerStateManager.isHideResponses(player.method_5667())) {
            source.method_9226(() -> class_2561.method_43470((String)("Jumped " + String.format("%.1f", distance) + " blocks")).method_27692(class_124.field_1060), false);
        }
        return 1;
    }

    private static class_2338 findLandingSpot(class_1937 world, class_2338 hitPos, class_3965 hitResult) {
        class_2338 onTop = hitPos.method_10084();
        if (TeleportHelper.hasTwoBlockGap(world, onTop)) {
            return onTop;
        }
        class_2338 adjacent = hitPos.method_10093(hitResult.method_17780());
        if (TeleportHelper.hasTwoBlockGap(world, adjacent) && TeleportHelper.hasSolidFloor(world, adjacent)) {
            return adjacent;
        }
        for (int y = 0; y <= 3; ++y) {
            class_2338 checkPos = hitPos.method_10086(y + 1);
            if (!TeleportHelper.hasTwoBlockGap(world, checkPos) || !TeleportHelper.hasSolidFloor(world, checkPos)) continue;
            return checkPos;
        }
        return null;
    }
}

