/*
 * Decompiled with CFR 0.152.
 */
package com.superiorplayercommands.command.core;

import com.mojang.brigadier.CommandDispatcher;
import com.mojang.brigadier.arguments.ArgumentType;
import com.mojang.brigadier.arguments.StringArgumentType;
import com.mojang.brigadier.builder.LiteralArgumentBuilder;
import com.mojang.brigadier.context.CommandContext;
import com.mojang.brigadier.suggestion.SuggestionProvider;
import com.mojang.brigadier.suggestion.SuggestionsBuilder;
import com.superiorplayercommands.data.PlayerStateManager;
import com.superiorplayercommands.data.WaypointManager;
import java.util.Map;
import net.minecraft.class_124;
import net.minecraft.class_2168;
import net.minecraft.class_2170;
import net.minecraft.class_2172;
import net.minecraft.class_2338;
import net.minecraft.class_2382;
import net.minecraft.class_2561;
import net.minecraft.class_3222;

public class RemCommand {
    private static final SuggestionProvider<class_2168> WAYPOINT_SUGGESTIONS = (context, builder) -> {
        class_2168 source = (class_2168)context.getSource();
        if (source.method_43737()) {
            return class_2172.method_9265(WaypointManager.getWaypointNames(source.method_44023().method_5667()), (SuggestionsBuilder)builder);
        }
        return builder.buildFuture();
    };

    public static void register(CommandDispatcher<class_2168> dispatcher) {
        dispatcher.register((LiteralArgumentBuilder)((LiteralArgumentBuilder)((LiteralArgumentBuilder)class_2170.method_9247((String)"rem").requires(source -> source.method_9259(0))).executes(RemCommand::executeNoArg)).then(class_2170.method_9244((String)"name", (ArgumentType)StringArgumentType.word()).suggests(WAYPOINT_SUGGESTIONS).executes(RemCommand::execute)));
    }

    private static int executeNoArg(CommandContext<class_2168> context) {
        class_2168 source = (class_2168)context.getSource();
        if (!source.method_43737()) {
            source.method_9213((class_2561)class_2561.method_43470((String)"This command can only be used by players"));
            return 0;
        }
        class_3222 player = source.method_44023();
        class_2338 playerPos = player.method_24515();
        String currentDimension = player.method_37908().method_27983().method_29177().toString();
        Map<String, WaypointManager.WaypointData> waypoints = WaypointManager.getWaypoints(player.method_5667());
        for (Map.Entry<String, WaypointManager.WaypointData> entry : waypoints.entrySet()) {
            class_2338 waypointPos;
            WaypointManager.WaypointData data = entry.getValue();
            if (!data.dimension.equals(currentDimension) || !playerPos.method_19771((class_2382)(waypointPos = data.getPos()), 2.0)) continue;
            String name = entry.getKey();
            WaypointManager.removeWaypoint(player.method_5667(), name);
            if (!PlayerStateManager.isHideResponses(player.method_5667())) {
                source.method_9226(() -> class_2561.method_43470((String)"Removed waypoint '").method_27692(class_124.field_1054).method_10852((class_2561)class_2561.method_43470((String)name).method_27692(class_124.field_1075)).method_10852((class_2561)class_2561.method_43470((String)"'").method_27692(class_124.field_1054)), false);
            }
            return 1;
        }
        source.method_9226(() -> class_2561.method_43470((String)"Please specify a waypoint name: ").method_27692(class_124.field_1054).method_10852((class_2561)class_2561.method_43470((String)"/rem <name>").method_27692(class_124.field_1075)), false);
        if (!waypoints.isEmpty()) {
            source.method_9226(() -> class_2561.method_43470((String)"Your waypoints: ").method_27692(class_124.field_1080).method_10852((class_2561)class_2561.method_43470((String)String.join((CharSequence)", ", waypoints.keySet())).method_27692(class_124.field_1068)), false);
        }
        return 0;
    }

    private static int execute(CommandContext<class_2168> context) {
        class_2168 source = (class_2168)context.getSource();
        if (!source.method_43737()) {
            source.method_9213((class_2561)class_2561.method_43470((String)"This command can only be used by players"));
            return 0;
        }
        class_3222 player = source.method_44023();
        String name = StringArgumentType.getString(context, (String)"name");
        if (WaypointManager.removeWaypoint(player.method_5667(), name)) {
            if (!PlayerStateManager.isHideResponses(player.method_5667())) {
                source.method_9226(() -> class_2561.method_43470((String)"Removed waypoint '").method_27692(class_124.field_1054).method_10852((class_2561)class_2561.method_43470((String)name).method_27692(class_124.field_1075)).method_10852((class_2561)class_2561.method_43470((String)"'").method_27692(class_124.field_1054)), false);
            }
            return 1;
        }
        source.method_9226(() -> class_2561.method_43470((String)"Waypoint '").method_27692(class_124.field_1061).method_10852((class_2561)class_2561.method_43470((String)name).method_27692(class_124.field_1075)).method_10852((class_2561)class_2561.method_43470((String)"' not found").method_27692(class_124.field_1061)), false);
        return 0;
    }
}

