/*
 * Decompiled with CFR 0.152.
 */
package com.superiorplayercommands.command.core;

import com.mojang.brigadier.CommandDispatcher;
import com.mojang.brigadier.builder.LiteralArgumentBuilder;
import com.mojang.brigadier.context.CommandContext;
import com.superiorplayercommands.data.PlayerStateManager;
import com.superiorplayercommands.util.TeleportHelper;
import net.minecraft.class_124;
import net.minecraft.class_1937;
import net.minecraft.class_2168;
import net.minecraft.class_2170;
import net.minecraft.class_2338;
import net.minecraft.class_2561;
import net.minecraft.class_3222;

public class UnstuckCommand {
    private static final int SEARCH_RADIUS = 5;

    public static void register(CommandDispatcher<class_2168> dispatcher) {
        dispatcher.register((LiteralArgumentBuilder)((LiteralArgumentBuilder)class_2170.method_9247((String)"unstuck").requires(source -> source.method_9259(2))).executes(UnstuckCommand::execute));
    }

    private static int execute(CommandContext<class_2168> context) {
        class_2338 playerPos;
        class_2168 source = (class_2168)context.getSource();
        if (!source.method_43737()) {
            source.method_9213((class_2561)class_2561.method_43470((String)"This command can only be used by players"));
            return 0;
        }
        class_3222 player = source.method_44023();
        class_1937 world = player.method_37908();
        if (UnstuckCommand.hasSpace(world, playerPos = player.method_24515())) {
            source.method_9226(() -> class_2561.method_43470((String)"You don't appear to be stuck").method_27692(class_124.field_1080), false);
            return 0;
        }
        class_2338 safePos = UnstuckCommand.findSafePosition(world, playerPos);
        if (safePos == null) {
            source.method_9226(() -> class_2561.method_43470((String)"No safe position found nearby").method_27692(class_124.field_1061), false);
            return 0;
        }
        TeleportHelper.teleportPlayer(player, safePos);
        if (!PlayerStateManager.isHideResponses(player.method_5667())) {
            source.method_9226(() -> class_2561.method_43470((String)"Teleported to safe position").method_27692(class_124.field_1060), false);
        }
        return 1;
    }

    private static boolean hasSpace(class_1937 world, class_2338 pos) {
        return world.method_8320(pos).method_26215() && world.method_8320(pos.method_10084()).method_26215();
    }

    private static class_2338 findSafePosition(class_1937 world, class_2338 center) {
        for (int radius = 1; radius <= 5; ++radius) {
            for (int x = -radius; x <= radius; ++x) {
                for (int y = -radius; y <= radius; ++y) {
                    for (int z = -radius; z <= radius; ++z) {
                        class_2338 checkPos;
                        if (Math.abs(x) != radius && Math.abs(y) != radius && Math.abs(z) != radius || !TeleportHelper.hasTwoBlockGap(world, checkPos = center.method_10069(x, y, z)) || !TeleportHelper.hasSolidFloor(world, checkPos)) continue;
                        return checkPos;
                    }
                }
            }
        }
        return null;
    }
}

